/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.math.LongMath;
import com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.TimeUnit;

@GwtIncompatible
abstract class SmoothRateLimiter
extends RateLimiter {
    double storedPermits;
    double maxPermits;
    double stableIntervalMicros;
    private long nextFreeTicketMicros = 0L;

    private SmoothRateLimiter(RateLimiter.SleepingStopwatch sleepingStopwatch) {
        super(sleepingStopwatch);
    }

    @Override
    final void doSetRate(double d2, long l2) {
        double d3;
        this.resync(l2);
        this.stableIntervalMicros = d3 = (double)TimeUnit.SECONDS.toMicros(1L) / d2;
        this.doSetRate(d2, d3);
    }

    abstract void doSetRate(double var1, double var3);

    @Override
    final double doGetRate() {
        return (double)TimeUnit.SECONDS.toMicros(1L) / this.stableIntervalMicros;
    }

    @Override
    final long queryEarliestAvailable(long l2) {
        return this.nextFreeTicketMicros;
    }

    @Override
    final long reserveEarliestAvailable(int n2, long l2) {
        this.resync(l2);
        long l3 = this.nextFreeTicketMicros;
        double d2 = Math.min((double)n2, this.storedPermits);
        double d3 = (double)n2 - d2;
        long l4 = this.storedPermitsToWaitTime(this.storedPermits, d2) + (long)(d3 * this.stableIntervalMicros);
        this.nextFreeTicketMicros = LongMath.saturatedAdd(this.nextFreeTicketMicros, l4);
        this.storedPermits -= d2;
        return l3;
    }

    abstract long storedPermitsToWaitTime(double var1, double var3);

    abstract double coolDownIntervalMicros();

    void resync(long l2) {
        if (l2 > this.nextFreeTicketMicros) {
            double d2 = (double)(l2 - this.nextFreeTicketMicros) / this.coolDownIntervalMicros();
            this.storedPermits = Math.min(this.maxPermits, this.storedPermits + d2);
            this.nextFreeTicketMicros = l2;
        }
    }

    static final class SmoothBursty
    extends SmoothRateLimiter {
        final double maxBurstSeconds;

        SmoothBursty(RateLimiter.SleepingStopwatch sleepingStopwatch, double d2) {
            super(sleepingStopwatch);
            this.maxBurstSeconds = d2;
        }

        @Override
        void doSetRate(double d2, double d3) {
            double d4 = this.maxPermits;
            this.maxPermits = this.maxBurstSeconds * d2;
            this.storedPermits = d4 == Double.POSITIVE_INFINITY ? this.maxPermits : (d4 == 0.0 ? 0.0 : this.storedPermits * this.maxPermits / d4);
        }

        @Override
        long storedPermitsToWaitTime(double d2, double d3) {
            return 0L;
        }

        @Override
        double coolDownIntervalMicros() {
            return this.stableIntervalMicros;
        }
    }

    static final class SmoothWarmingUp
    extends SmoothRateLimiter {
        private final long warmupPeriodMicros;
        private double slope;
        private double thresholdPermits;
        private double coldFactor;

        SmoothWarmingUp(RateLimiter.SleepingStopwatch sleepingStopwatch, long l2, TimeUnit timeUnit, double d2) {
            super(sleepingStopwatch);
            this.warmupPeriodMicros = timeUnit.toMicros(l2);
            this.coldFactor = d2;
        }

        @Override
        void doSetRate(double d2, double d3) {
            double d4 = this.maxPermits;
            double d5 = d3 * this.coldFactor;
            this.thresholdPermits = 0.5 * (double)this.warmupPeriodMicros / d3;
            this.maxPermits = this.thresholdPermits + 2.0 * (double)this.warmupPeriodMicros / (d3 + d5);
            this.slope = (d5 - d3) / (this.maxPermits - this.thresholdPermits);
            this.storedPermits = d4 == Double.POSITIVE_INFINITY ? 0.0 : (d4 == 0.0 ? this.maxPermits : this.storedPermits * this.maxPermits / d4);
        }

        @Override
        long storedPermitsToWaitTime(double d2, double d3) {
            double d4 = d2 - this.thresholdPermits;
            long l2 = 0L;
            if (d4 > 0.0) {
                double d5 = Math.min(d4, d3);
                double d6 = this.permitsToTime(d4) + this.permitsToTime(d4 - d5);
                l2 = (long)(d5 * d6 / 2.0);
                d3 -= d5;
            }
            return l2 += (long)(this.stableIntervalMicros * d3);
        }

        private double permitsToTime(double d2) {
            return this.stableIntervalMicros + d2 * this.slope;
        }

        @Override
        double coolDownIntervalMicros() {
            return (double)this.warmupPeriodMicros / this.maxPermits;
        }
    }
}

