/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

@GwtIncompatible
final class SequentialExecutor
implements Executor {
    private static final Logger log = Logger.getLogger(SequentialExecutor.class.getName());
    private final Executor executor;
    @GuardedBy(value="queue")
    private final Deque<Runnable> queue = new ArrayDeque<Runnable>();
    @GuardedBy(value="queue")
    private WorkerRunningState workerRunningState = WorkerRunningState.IDLE;
    @GuardedBy(value="queue")
    private long workerRunCount = 0L;
    private final QueueWorker worker = new QueueWorker();

    SequentialExecutor(Executor executor) {
        this.executor = Preconditions.checkNotNull(executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(final Runnable runnable) {
        boolean bl2;
        Runnable runnable2;
        long l2;
        Preconditions.checkNotNull(runnable);
        Deque<Runnable> deque = this.queue;
        synchronized (deque) {
            if (this.workerRunningState == WorkerRunningState.RUNNING || this.workerRunningState == WorkerRunningState.QUEUED) {
                this.queue.add(runnable);
                return;
            }
            l2 = this.workerRunCount;
            runnable2 = new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                }
            };
            this.queue.add(runnable2);
            this.workerRunningState = WorkerRunningState.QUEUING;
        }
        try {
            this.executor.execute(this.worker);
        }
        catch (Error | RuntimeException throwable) {
            Deque<Runnable> deque2 = this.queue;
            synchronized (deque2) {
                boolean bl3;
                boolean bl4 = bl3 = (this.workerRunningState == WorkerRunningState.IDLE || this.workerRunningState == WorkerRunningState.QUEUING) && this.queue.removeLastOccurrence(runnable2);
                if (!(throwable instanceof RejectedExecutionException) || bl3) {
                    throw throwable;
                }
            }
            return;
        }
        boolean bl5 = bl2 = this.workerRunningState != WorkerRunningState.QUEUING;
        if (bl2) {
            return;
        }
        Deque<Runnable> deque3 = this.queue;
        synchronized (deque3) {
            if (this.workerRunCount == l2 && this.workerRunningState == WorkerRunningState.QUEUING) {
                this.workerRunningState = WorkerRunningState.QUEUED;
            }
        }
    }

    static /* synthetic */ WorkerRunningState access$200(SequentialExecutor sequentialExecutor) {
        return sequentialExecutor.workerRunningState;
    }

    static /* synthetic */ long access$308(SequentialExecutor sequentialExecutor) {
        return sequentialExecutor.workerRunCount++;
    }

    static /* synthetic */ Logger access$400() {
        return log;
    }

    private final class QueueWorker
    implements Runnable {
        private QueueWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.workOnQueue();
            }
            catch (Error error) {
                Deque deque = SequentialExecutor.this.queue;
                synchronized (deque) {
                    SequentialExecutor.this.workerRunningState = WorkerRunningState.IDLE;
                }
                throw error;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void workOnQueue() {
            var1_1 = false;
            var2_2 = false;
            while (true) {
                var4_4 = SequentialExecutor.access$100(SequentialExecutor.this);
                synchronized (var4_4) {
                    if (var2_2) break block14;
                    if (SequentialExecutor.access$200(SequentialExecutor.this) != WorkerRunningState.RUNNING) ** break block15
                    ** if (!var1_1) goto lbl11
                }
lbl-1000:
                // 1 sources

                {
                    Thread.currentThread().interrupt();
                }
lbl11:
                // 2 sources

                return;
                break;
            }
            {
                catch (Throwable var6_6) {
                    if (var1_1) {
                        Thread.currentThread().interrupt();
                    }
                    throw var6_6;
                }
                {
                    block14: {
                        SequentialExecutor.access$308(SequentialExecutor.this);
                        SequentialExecutor.access$202(SequentialExecutor.this, WorkerRunningState.RUNNING);
                        var2_2 = true;
                    }
                    if ((var3_3 = (Runnable)SequentialExecutor.access$100(SequentialExecutor.this).poll()) == null) {
                        SequentialExecutor.access$202(SequentialExecutor.this, WorkerRunningState.IDLE);
                        // MONITOREXIT @DISABLED, blocks:[6, 9, 12] lbl21 : MonitorExitStatement: MONITOREXIT : var4_4
                        if (var1_1) {
                            Thread.currentThread().interrupt();
                        }
                        return;
                    }
                    // MONITOREXIT @DISABLED, blocks:[3, 6, 9] lbl26 : MonitorExitStatement: MONITOREXIT : var4_4
                    var1_1 |= Thread.interrupted();
                    try {
                        var3_3.run();
                    }
                    catch (RuntimeException var4_5) {
                        SequentialExecutor.access$400().log(Level.SEVERE, "Exception while executing runnable " + var3_3, var4_5);
                    }
                    continue;
                }
            }
        }
    }

    static enum WorkerRunningState {
        IDLE,
        QUEUING,
        QUEUED,
        RUNNING;

    }
}

