/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.Internal;
import com.google.common.util.concurrent.SmoothRateLimiter;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Duration;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@Beta
@GwtIncompatible
public abstract class RateLimiter {
    private final SleepingStopwatch stopwatch;
    private volatile @MonotonicNonNull Object mutexDoNotUseDirectly;

    public static RateLimiter create(double d2) {
        return RateLimiter.create(d2, SleepingStopwatch.createFromSystemTimer());
    }

    @VisibleForTesting
    static RateLimiter create(double d2, SleepingStopwatch sleepingStopwatch) {
        SmoothRateLimiter.SmoothBursty smoothBursty = new SmoothRateLimiter.SmoothBursty(sleepingStopwatch, 1.0);
        smoothBursty.setRate(d2);
        return smoothBursty;
    }

    public static RateLimiter create(double d2, Duration duration) {
        return RateLimiter.create(d2, Internal.saturatedToNanos(duration), TimeUnit.NANOSECONDS);
    }

    public static RateLimiter create(double d2, long l2, TimeUnit timeUnit) {
        Preconditions.checkArgument(l2 >= 0L, "warmupPeriod must not be negative: %s", l2);
        return RateLimiter.create(d2, l2, timeUnit, 3.0, SleepingStopwatch.createFromSystemTimer());
    }

    @VisibleForTesting
    static RateLimiter create(double d2, long l2, TimeUnit timeUnit, double d3, SleepingStopwatch sleepingStopwatch) {
        SmoothRateLimiter.SmoothWarmingUp smoothWarmingUp = new SmoothRateLimiter.SmoothWarmingUp(sleepingStopwatch, l2, timeUnit, d3);
        smoothWarmingUp.setRate(d2);
        return smoothWarmingUp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object mutex() {
        Object object = this.mutexDoNotUseDirectly;
        if (object == null) {
            RateLimiter rateLimiter = this;
            synchronized (rateLimiter) {
                object = this.mutexDoNotUseDirectly;
                if (object == null) {
                    this.mutexDoNotUseDirectly = object = new Object();
                }
            }
        }
        return object;
    }

    RateLimiter(SleepingStopwatch sleepingStopwatch) {
        this.stopwatch = Preconditions.checkNotNull(sleepingStopwatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setRate(double d2) {
        Preconditions.checkArgument(d2 > 0.0 && !Double.isNaN(d2), "rate must be positive");
        Object object = this.mutex();
        synchronized (object) {
            this.doSetRate(d2, this.stopwatch.readMicros());
        }
    }

    abstract void doSetRate(double var1, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double getRate() {
        Object object = this.mutex();
        synchronized (object) {
            return this.doGetRate();
        }
    }

    abstract double doGetRate();

    @CanIgnoreReturnValue
    public double acquire() {
        return this.acquire(1);
    }

    @CanIgnoreReturnValue
    public double acquire(int n2) {
        long l2 = this.reserve(n2);
        this.stopwatch.sleepMicrosUninterruptibly(l2);
        return 1.0 * (double)l2 / (double)TimeUnit.SECONDS.toMicros(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long reserve(int n2) {
        RateLimiter.checkPermits(n2);
        Object object = this.mutex();
        synchronized (object) {
            return this.reserveAndGetWaitLength(n2, this.stopwatch.readMicros());
        }
    }

    public boolean tryAcquire(Duration duration) {
        return this.tryAcquire(1, Internal.saturatedToNanos(duration), TimeUnit.NANOSECONDS);
    }

    public boolean tryAcquire(long l2, TimeUnit timeUnit) {
        return this.tryAcquire(1, l2, timeUnit);
    }

    public boolean tryAcquire(int n2) {
        return this.tryAcquire(n2, 0L, TimeUnit.MICROSECONDS);
    }

    public boolean tryAcquire() {
        return this.tryAcquire(1, 0L, TimeUnit.MICROSECONDS);
    }

    public boolean tryAcquire(int n2, Duration duration) {
        return this.tryAcquire(n2, Internal.saturatedToNanos(duration), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryAcquire(int n2, long l2, TimeUnit timeUnit) {
        long l3;
        long l4 = Math.max(timeUnit.toMicros(l2), 0L);
        RateLimiter.checkPermits(n2);
        Object object = this.mutex();
        synchronized (object) {
            long l5 = this.stopwatch.readMicros();
            if (!this.canAcquire(l5, l4)) {
                return false;
            }
            l3 = this.reserveAndGetWaitLength(n2, l5);
        }
        this.stopwatch.sleepMicrosUninterruptibly(l3);
        return true;
    }

    private boolean canAcquire(long l2, long l3) {
        return this.queryEarliestAvailable(l2) - l3 <= l2;
    }

    final long reserveAndGetWaitLength(int n2, long l2) {
        long l3 = this.reserveEarliestAvailable(n2, l2);
        return Math.max(l3 - l2, 0L);
    }

    abstract long queryEarliestAvailable(long var1);

    abstract long reserveEarliestAvailable(int var1, long var2);

    public String toString() {
        return String.format(Locale.ROOT, "RateLimiter[stableRate=%3.1fqps]", this.getRate());
    }

    private static void checkPermits(int n2) {
        Preconditions.checkArgument(n2 > 0, "Requested permits (%s) must be positive", n2);
    }

    static abstract class SleepingStopwatch {
        protected SleepingStopwatch() {
        }

        protected abstract long readMicros();

        protected abstract void sleepMicrosUninterruptibly(long var1);

        public static SleepingStopwatch createFromSystemTimer() {
            return new SleepingStopwatch(){
                final Stopwatch stopwatch = Stopwatch.createStarted();

                @Override
                protected long readMicros() {
                    return this.stopwatch.elapsed(TimeUnit.MICROSECONDS);
                }

                @Override
                protected void sleepMicrosUninterruptibly(long l2) {
                    if (l2 > 0L) {
                        Uninterruptibles.sleepUninterruptibly(l2, TimeUnit.MICROSECONDS);
                    }
                }
            };
        }
    }
}

