/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Internal;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.j2objc.annotations.Weak;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BooleanSupplier;
import org.checkerframework.checker.nullness.qual.Nullable;

@Beta
@GwtIncompatible
public final class Monitor {
    private final boolean fair;
    private final ReentrantLock lock;
    @GuardedBy(value="lock")
    private Guard activeGuards = null;

    public Monitor() {
        this(false);
    }

    public Monitor(boolean bl2) {
        this.fair = bl2;
        this.lock = new ReentrantLock(bl2);
    }

    public Guard newGuard(final BooleanSupplier booleanSupplier) {
        Preconditions.checkNotNull(booleanSupplier, "isSatisfied");
        return new Guard(this){

            @Override
            public boolean isSatisfied() {
                return booleanSupplier.getAsBoolean();
            }
        };
    }

    public void enter() {
        this.lock.lock();
    }

    public boolean enter(Duration duration) {
        return this.enter(Internal.saturatedToNanos(duration), TimeUnit.NANOSECONDS);
    }

    public boolean enter(long l2, TimeUnit timeUnit) {
        long l3 = Monitor.toSafeNanos(l2, timeUnit);
        ReentrantLock reentrantLock = this.lock;
        if (!this.fair && reentrantLock.tryLock()) {
            return true;
        }
        boolean bl2 = Thread.interrupted();
        try {
            long l4 = System.nanoTime();
            long l5 = l3;
            while (true) {
                try {
                    boolean bl3 = reentrantLock.tryLock(l5, TimeUnit.NANOSECONDS);
                    return bl3;
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                    l5 = Monitor.remainingNanos(l4, l3);
                    continue;
                }
                break;
            }
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void enterInterruptibly() {
        this.lock.lockInterruptibly();
    }

    public boolean enterInterruptibly(Duration duration) {
        return this.enterInterruptibly(Internal.saturatedToNanos(duration), TimeUnit.NANOSECONDS);
    }

    public boolean enterInterruptibly(long l2, TimeUnit timeUnit) {
        return this.lock.tryLock(l2, timeUnit);
    }

    public boolean tryEnter() {
        return this.lock.tryLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterWhen(Guard guard) {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock reentrantLock = this.lock;
        boolean bl2 = reentrantLock.isHeldByCurrentThread();
        reentrantLock.lockInterruptibly();
        boolean bl3 = false;
        try {
            if (!guard.isSatisfied()) {
                this.await(guard, bl2);
            }
            bl3 = true;
        }
        finally {
            if (!bl3) {
                this.leave();
            }
        }
    }

    public boolean enterWhen(Guard guard, Duration duration) {
        return this.enterWhen(guard, Internal.saturatedToNanos(duration), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enterWhen(Guard guard, long l2, TimeUnit timeUnit) {
        long l3;
        boolean bl2;
        ReentrantLock reentrantLock;
        long l4;
        block19: {
            block18: {
                l4 = Monitor.toSafeNanos(l2, timeUnit);
                if (guard.monitor != this) {
                    throw new IllegalMonitorStateException();
                }
                reentrantLock = this.lock;
                bl2 = reentrantLock.isHeldByCurrentThread();
                l3 = 0L;
                if (this.fair) break block18;
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (reentrantLock.tryLock()) break block19;
            }
            l3 = Monitor.initNanoTime(l4);
            if (!reentrantLock.tryLock(l2, timeUnit)) {
                return false;
            }
        }
        boolean bl3 = false;
        boolean bl4 = true;
        try {
            bl3 = guard.isSatisfied() || this.awaitNanos(guard, l3 == 0L ? l4 : Monitor.remainingNanos(l3, l4), bl2);
            bl4 = false;
            boolean bl5 = bl3;
            return bl5;
        }
        finally {
            if (!bl3) {
                try {
                    if (bl4 && !bl2) {
                        this.signalNextWaiter();
                    }
                }
                finally {
                    reentrantLock.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterWhenUninterruptibly(Guard guard) {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock reentrantLock = this.lock;
        boolean bl2 = reentrantLock.isHeldByCurrentThread();
        reentrantLock.lock();
        boolean bl3 = false;
        try {
            if (!guard.isSatisfied()) {
                this.awaitUninterruptibly(guard, bl2);
            }
            bl3 = true;
        }
        finally {
            if (!bl3) {
                this.leave();
            }
        }
    }

    public boolean enterWhenUninterruptibly(Guard guard, Duration duration) {
        return this.enterWhenUninterruptibly(guard, Internal.saturatedToNanos(duration), TimeUnit.NANOSECONDS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean enterWhenUninterruptibly(Guard guard, long l2, TimeUnit timeUnit) {
        long l3 = Monitor.toSafeNanos(l2, timeUnit);
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock reentrantLock = this.lock;
        long l4 = 0L;
        boolean bl2 = reentrantLock.isHeldByCurrentThread();
        boolean bl3 = Thread.interrupted();
        if (this.fair || !reentrantLock.tryLock()) {
            l4 = Monitor.initNanoTime(l3);
            long l5 = l3;
            while (true) {
                try {
                    if (!reentrantLock.tryLock(l5, TimeUnit.NANOSECONDS)) {
                        boolean bl4 = false;
                        return bl4;
                    }
                }
                catch (InterruptedException interruptedException) {
                    bl3 = true;
                    l5 = Monitor.remainingNanos(l4, l3);
                    continue;
                }
                break;
            }
        }
        boolean bl5 = false;
        while (true) {
            try {
                if (guard.isSatisfied()) {
                    bl5 = true;
                } else {
                    long l6;
                    if (l4 == 0L) {
                        l4 = Monitor.initNanoTime(l3);
                        l6 = l3;
                    } else {
                        l6 = Monitor.remainingNanos(l4, l3);
                    }
                    bl5 = this.awaitNanos(guard, l6, bl2);
                }
                boolean bl6 = bl5;
                return bl6;
            }
            catch (InterruptedException interruptedException) {
                bl3 = true;
                bl2 = false;
                continue;
            }
            break;
        }
        finally {
            if (!bl5) {
                reentrantLock.unlock();
            }
        }
        finally {
            if (bl3) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enterIf(Guard guard) {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        boolean bl2 = false;
        try {
            boolean bl3 = bl2 = guard.isSatisfied();
            return bl3;
        }
        finally {
            if (!bl2) {
                reentrantLock.unlock();
            }
        }
    }

    public boolean enterIf(Guard guard, Duration duration) {
        return this.enterIf(guard, Internal.saturatedToNanos(duration), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enterIf(Guard guard, long l2, TimeUnit timeUnit) {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        if (!this.enter(l2, timeUnit)) {
            return false;
        }
        boolean bl2 = false;
        try {
            boolean bl3 = bl2 = guard.isSatisfied();
            return bl3;
        }
        finally {
            if (!bl2) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enterIfInterruptibly(Guard guard) {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lockInterruptibly();
        boolean bl2 = false;
        try {
            boolean bl3 = bl2 = guard.isSatisfied();
            return bl3;
        }
        finally {
            if (!bl2) {
                reentrantLock.unlock();
            }
        }
    }

    public boolean enterIfInterruptibly(Guard guard, Duration duration) {
        return this.enterIfInterruptibly(guard, Internal.saturatedToNanos(duration), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enterIfInterruptibly(Guard guard, long l2, TimeUnit timeUnit) {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock reentrantLock = this.lock;
        if (!reentrantLock.tryLock(l2, timeUnit)) {
            return false;
        }
        boolean bl2 = false;
        try {
            boolean bl3 = bl2 = guard.isSatisfied();
            return bl3;
        }
        finally {
            if (!bl2) {
                reentrantLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryEnterIf(Guard guard) {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock reentrantLock = this.lock;
        if (!reentrantLock.tryLock()) {
            return false;
        }
        boolean bl2 = false;
        try {
            boolean bl3 = bl2 = guard.isSatisfied();
            return bl3;
        }
        finally {
            if (!bl2) {
                reentrantLock.unlock();
            }
        }
    }

    public void waitFor(Guard guard) {
        if (!(guard.monitor == this & this.lock.isHeldByCurrentThread())) {
            throw new IllegalMonitorStateException();
        }
        if (!guard.isSatisfied()) {
            this.await(guard, true);
        }
    }

    public boolean waitFor(Guard guard, Duration duration) {
        return this.waitFor(guard, Internal.saturatedToNanos(duration), TimeUnit.NANOSECONDS);
    }

    public boolean waitFor(Guard guard, long l2, TimeUnit timeUnit) {
        long l3 = Monitor.toSafeNanos(l2, timeUnit);
        if (!(guard.monitor == this & this.lock.isHeldByCurrentThread())) {
            throw new IllegalMonitorStateException();
        }
        if (guard.isSatisfied()) {
            return true;
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.awaitNanos(guard, l3, true);
    }

    public void waitForUninterruptibly(Guard guard) {
        if (!(guard.monitor == this & this.lock.isHeldByCurrentThread())) {
            throw new IllegalMonitorStateException();
        }
        if (!guard.isSatisfied()) {
            this.awaitUninterruptibly(guard, true);
        }
    }

    public boolean waitForUninterruptibly(Guard guard, Duration duration) {
        return this.waitForUninterruptibly(guard, Internal.saturatedToNanos(duration), TimeUnit.NANOSECONDS);
    }

    public boolean waitForUninterruptibly(Guard guard, long l2, TimeUnit timeUnit) {
        long l3 = Monitor.toSafeNanos(l2, timeUnit);
        if (!(guard.monitor == this & this.lock.isHeldByCurrentThread())) {
            throw new IllegalMonitorStateException();
        }
        if (guard.isSatisfied()) {
            return true;
        }
        boolean bl2 = true;
        long l4 = Monitor.initNanoTime(l3);
        boolean bl3 = Thread.interrupted();
        try {
            long l5 = l3;
            while (true) {
                try {
                    boolean bl4 = this.awaitNanos(guard, l5, bl2);
                    return bl4;
                }
                catch (InterruptedException interruptedException) {
                    block12: {
                        bl3 = true;
                        if (!guard.isSatisfied()) break block12;
                        boolean bl5 = true;
                        if (bl3) {
                            Thread.currentThread().interrupt();
                        }
                        return bl5;
                    }
                    bl2 = false;
                    l5 = Monitor.remainingNanos(l4, l3);
                    continue;
                }
                break;
            }
        }
        finally {
            if (bl3) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void leave() {
        ReentrantLock reentrantLock = this.lock;
        try {
            if (reentrantLock.getHoldCount() == 1) {
                this.signalNextWaiter();
            }
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public boolean isFair() {
        return this.fair;
    }

    public boolean isOccupied() {
        return this.lock.isLocked();
    }

    public boolean isOccupiedByCurrentThread() {
        return this.lock.isHeldByCurrentThread();
    }

    public int getOccupiedDepth() {
        return this.lock.getHoldCount();
    }

    public int getQueueLength() {
        return this.lock.getQueueLength();
    }

    public boolean hasQueuedThreads() {
        return this.lock.hasQueuedThreads();
    }

    public boolean hasQueuedThread(Thread thread) {
        return this.lock.hasQueuedThread(thread);
    }

    public boolean hasWaiters(Guard guard) {
        return this.getWaitQueueLength(guard) > 0;
    }

    public int getWaitQueueLength(Guard guard) {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        this.lock.lock();
        try {
            int n2 = guard.waiterCount;
            return n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static long toSafeNanos(long l2, TimeUnit timeUnit) {
        long l3 = timeUnit.toNanos(l2);
        return l3 <= 0L ? 0L : (l3 > 0x5FFFFFFFFFFFFFFDL ? 0x5FFFFFFFFFFFFFFDL : l3);
    }

    private static long initNanoTime(long l2) {
        if (l2 <= 0L) {
            return 0L;
        }
        long l3 = System.nanoTime();
        return l3 == 0L ? 1L : l3;
    }

    private static long remainingNanos(long l2, long l3) {
        return l3 <= 0L ? 0L : l3 - (System.nanoTime() - l2);
    }

    @GuardedBy(value="lock")
    private void signalNextWaiter() {
        Guard guard = this.activeGuards;
        while (guard != null) {
            if (this.isSatisfied(guard)) {
                guard.condition.signal();
                break;
            }
            guard = guard.next;
        }
    }

    @GuardedBy(value="lock")
    private boolean isSatisfied(Guard guard) {
        try {
            return guard.isSatisfied();
        }
        catch (Throwable throwable) {
            this.signalAllWaiters();
            throw throwable;
        }
    }

    @GuardedBy(value="lock")
    private void signalAllWaiters() {
        Guard guard = this.activeGuards;
        while (guard != null) {
            guard.condition.signalAll();
            guard = guard.next;
        }
    }

    @GuardedBy(value="lock")
    private void beginWaitingFor(Guard guard) {
        int n2;
        if ((n2 = guard.waiterCount++) == 0) {
            guard.next = this.activeGuards;
            this.activeGuards = guard;
        }
    }

    @GuardedBy(value="lock")
    private void endWaitingFor(Guard guard) {
        int n2;
        if ((n2 = --guard.waiterCount) == 0) {
            Guard guard2 = this.activeGuards;
            Guard guard3 = null;
            while (true) {
                if (guard2 == guard) {
                    if (guard3 == null) {
                        this.activeGuards = guard2.next;
                    } else {
                        guard3.next = guard2.next;
                    }
                    guard2.next = null;
                    break;
                }
                guard3 = guard2;
                guard2 = guard2.next;
            }
        }
    }

    @GuardedBy(value="lock")
    private void await(Guard guard, boolean bl2) {
        if (bl2) {
            this.signalNextWaiter();
        }
        this.beginWaitingFor(guard);
        try {
            do {
                guard.condition.await();
            } while (!guard.isSatisfied());
        }
        finally {
            this.endWaitingFor(guard);
        }
    }

    @GuardedBy(value="lock")
    private void awaitUninterruptibly(Guard guard, boolean bl2) {
        if (bl2) {
            this.signalNextWaiter();
        }
        this.beginWaitingFor(guard);
        try {
            do {
                guard.condition.awaitUninterruptibly();
            } while (!guard.isSatisfied());
        }
        finally {
            this.endWaitingFor(guard);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="lock")
    private boolean awaitNanos(Guard guard, long l2, boolean bl2) {
        boolean bl3 = true;
        try {
            do {
                if (l2 <= 0L) {
                    boolean bl4 = false;
                    return bl4;
                }
                if (bl3) {
                    if (bl2) {
                        this.signalNextWaiter();
                    }
                    this.beginWaitingFor(guard);
                    bl3 = false;
                }
                l2 = guard.condition.awaitNanos(l2);
            } while (!guard.isSatisfied());
            boolean bl5 = true;
            return bl5;
        }
        finally {
            if (!bl3) {
                this.endWaitingFor(guard);
            }
        }
    }

    @Beta
    public static abstract class Guard {
        @Weak
        final Monitor monitor;
        final Condition condition;
        @GuardedBy(value="monitor.lock")
        int waiterCount = 0;
        @GuardedBy(value="monitor.lock")
        @Nullable Guard next;

        protected Guard(Monitor monitor) {
            this.monitor = Preconditions.checkNotNull(monitor, "monitor");
            this.condition = monitor.lock.newCondition();
        }

        public abstract boolean isSatisfied();
    }
}

