/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.j2objc.annotations.ReflectionSupport;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(emulated=true)
@ReflectionSupport(value=ReflectionSupport.Level.FULL)
abstract class InterruptibleTask<T>
extends AtomicReference<Runnable>
implements Runnable {
    private static final Runnable DONE;
    private static final Runnable INTERRUPTING;
    private static final Runnable PARKED;
    private static final int MAX_BUSY_WAIT_SPINS = 1000;

    InterruptibleTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Throwable throwable;
        T t2;
        boolean bl2;
        Thread thread;
        block26: {
            thread = Thread.currentThread();
            if (!this.compareAndSet(null, thread)) {
                return;
            }
            bl2 = !this.isDone();
            t2 = null;
            throwable = null;
            try {
                if (!bl2) break block26;
                t2 = this.runInterruptibly();
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                }
                catch (Throwable throwable3) {
                    if (!this.compareAndSet(thread, DONE)) {
                        boolean bl3 = false;
                        int n2 = 0;
                        Runnable runnable = (Runnable)this.get();
                        while (runnable == INTERRUPTING || runnable == PARKED) {
                            if (++n2 > 1000) {
                                if (runnable == PARKED || this.compareAndSet(INTERRUPTING, PARKED)) {
                                    bl3 = Thread.interrupted() || bl3;
                                    LockSupport.park(this);
                                }
                            } else {
                                Thread.yield();
                            }
                            runnable = (Runnable)this.get();
                        }
                        if (bl3) {
                            thread.interrupt();
                        }
                    }
                    if (bl2) {
                        this.afterRanInterruptibly(t2, throwable);
                    }
                    throw throwable3;
                }
                if (!this.compareAndSet(thread, DONE)) {
                    boolean bl4 = false;
                    int n3 = 0;
                    Runnable runnable = (Runnable)this.get();
                    while (runnable == INTERRUPTING || runnable == PARKED) {
                        if (++n3 > 1000) {
                            if (runnable == PARKED || this.compareAndSet(INTERRUPTING, PARKED)) {
                                bl4 = Thread.interrupted() || bl4;
                                LockSupport.park(this);
                            }
                        } else {
                            Thread.yield();
                        }
                        runnable = (Runnable)this.get();
                    }
                    if (bl4) {
                        thread.interrupt();
                    }
                }
                if (bl2) {
                    this.afterRanInterruptibly(t2, throwable);
                }
            }
        }
        if (!this.compareAndSet(thread, DONE)) {
            boolean bl5 = false;
            int n4 = 0;
            Runnable runnable = (Runnable)this.get();
            while (runnable == INTERRUPTING || runnable == PARKED) {
                if (++n4 > 1000) {
                    if (runnable == PARKED || this.compareAndSet(INTERRUPTING, PARKED)) {
                        bl5 = Thread.interrupted() || bl5;
                        LockSupport.park(this);
                    }
                } else {
                    Thread.yield();
                }
                runnable = (Runnable)this.get();
            }
            if (bl5) {
                thread.interrupt();
            }
        }
        if (bl2) {
            this.afterRanInterruptibly(t2, throwable);
        }
    }

    abstract boolean isDone();

    abstract T runInterruptibly();

    abstract void afterRanInterruptibly(@Nullable T var1, @Nullable Throwable var2);

    final void interruptTask() {
        Runnable runnable = (Runnable)this.get();
        if (runnable instanceof Thread && this.compareAndSet(runnable, INTERRUPTING)) {
            try {
                ((Thread)runnable).interrupt();
            }
            finally {
                Runnable runnable2 = this.getAndSet(DONE);
                if (runnable2 == PARKED) {
                    LockSupport.unpark((Thread)runnable);
                }
            }
        }
    }

    @Override
    public final String toString() {
        Runnable runnable = (Runnable)this.get();
        String string = runnable == DONE ? "running=[DONE]" : (runnable == INTERRUPTING ? "running=[INTERRUPTED]" : (runnable instanceof Thread ? "running=[RUNNING ON " + ((Thread)runnable).getName() + "]" : "running=[NOT STARTED YET]"));
        return string + ", " + this.toPendingString();
    }

    abstract String toPendingString();

    static {
        Class<LockSupport> clazz = LockSupport.class;
        DONE = new DoNothingRunnable();
        INTERRUPTING = new DoNothingRunnable();
        PARKED = new DoNothingRunnable();
    }

    private static final class DoNothingRunnable
    implements Runnable {
        private DoNothingRunnable() {
        }

        @Override
        public void run() {
        }
    }
}

