/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.AbstractCatchingFuture;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AbstractTransformFuture;
import com.google.common.util.concurrent.AsyncCallable;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.CollectionFuture;
import com.google.common.util.concurrent.CombinedFuture;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.FuturesGetChecked;
import com.google.common.util.concurrent.GwtFuturesCatchingSpecialization;
import com.google.common.util.concurrent.ImmediateFuture;
import com.google.common.util.concurrent.Internal;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Partially;
import com.google.common.util.concurrent.TimeoutFuture;
import com.google.common.util.concurrent.TrustedListenableFutureTask;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(emulated=true)
public final class Futures
extends GwtFuturesCatchingSpecialization {
    private Futures() {
    }

    public static <V> ListenableFuture<V> immediateFuture(@Nullable V v2) {
        if (v2 == null) {
            ImmediateFuture.ImmediateSuccessfulFuture<Object> immediateSuccessfulFuture = ImmediateFuture.ImmediateSuccessfulFuture.NULL;
            return immediateSuccessfulFuture;
        }
        return new ImmediateFuture.ImmediateSuccessfulFuture<V>(v2);
    }

    public static <V> ListenableFuture<V> immediateFailedFuture(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        return new ImmediateFuture.ImmediateFailedFuture(throwable);
    }

    public static <V> ListenableFuture<V> immediateCancelledFuture() {
        return new ImmediateFuture.ImmediateCancelledFuture();
    }

    @Beta
    public static <O> ListenableFuture<O> submitAsync(AsyncCallable<O> asyncCallable, Executor executor) {
        TrustedListenableFutureTask<O> trustedListenableFutureTask = TrustedListenableFutureTask.create(asyncCallable);
        executor.execute(trustedListenableFutureTask);
        return trustedListenableFutureTask;
    }

    @Beta
    @GwtIncompatible
    public static <O> ListenableFuture<O> scheduleAsync(AsyncCallable<O> asyncCallable, Duration duration, ScheduledExecutorService scheduledExecutorService) {
        return Futures.scheduleAsync(asyncCallable, Internal.saturatedToNanos(duration), TimeUnit.NANOSECONDS, scheduledExecutorService);
    }

    @Beta
    @GwtIncompatible
    public static <O> ListenableFuture<O> scheduleAsync(AsyncCallable<O> asyncCallable, long l2, TimeUnit timeUnit, ScheduledExecutorService scheduledExecutorService) {
        TrustedListenableFutureTask<O> trustedListenableFutureTask = TrustedListenableFutureTask.create(asyncCallable);
        final ScheduledFuture<?> scheduledFuture = scheduledExecutorService.schedule(trustedListenableFutureTask, l2, timeUnit);
        trustedListenableFutureTask.addListener(new Runnable(){

            @Override
            public void run() {
                scheduledFuture.cancel(false);
            }
        }, MoreExecutors.directExecutor());
        return trustedListenableFutureTask;
    }

    @Beta
    @Partially.GwtIncompatible(value="AVAILABLE but requires exceptionType to be Throwable.class")
    public static <V, X extends Throwable> ListenableFuture<V> catching(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, Function<? super X, ? extends V> function, Executor executor) {
        return AbstractCatchingFuture.create(listenableFuture, clazz, function, executor);
    }

    @Beta
    @Partially.GwtIncompatible(value="AVAILABLE but requires exceptionType to be Throwable.class")
    public static <V, X extends Throwable> ListenableFuture<V> catchingAsync(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, AsyncFunction<? super X, ? extends V> asyncFunction, Executor executor) {
        return AbstractCatchingFuture.create(listenableFuture, clazz, asyncFunction, executor);
    }

    @Beta
    @GwtIncompatible
    public static <V> ListenableFuture<V> withTimeout(ListenableFuture<V> listenableFuture, Duration duration, ScheduledExecutorService scheduledExecutorService) {
        return Futures.withTimeout(listenableFuture, Internal.saturatedToNanos(duration), TimeUnit.NANOSECONDS, scheduledExecutorService);
    }

    @Beta
    @GwtIncompatible
    public static <V> ListenableFuture<V> withTimeout(ListenableFuture<V> listenableFuture, long l2, TimeUnit timeUnit, ScheduledExecutorService scheduledExecutorService) {
        if (listenableFuture.isDone()) {
            return listenableFuture;
        }
        return TimeoutFuture.create(listenableFuture, l2, timeUnit, scheduledExecutorService);
    }

    @Beta
    public static <I, O> ListenableFuture<O> transformAsync(ListenableFuture<I> listenableFuture, AsyncFunction<? super I, ? extends O> asyncFunction, Executor executor) {
        return AbstractTransformFuture.create(listenableFuture, asyncFunction, executor);
    }

    @Beta
    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> listenableFuture, Function<? super I, ? extends O> function, Executor executor) {
        return AbstractTransformFuture.create(listenableFuture, function, executor);
    }

    @Beta
    @GwtIncompatible
    public static <I, O> Future<O> lazyTransform(final Future<I> future, final Function<? super I, ? extends O> function) {
        Preconditions.checkNotNull(future);
        Preconditions.checkNotNull(function);
        return new Future<O>(){

            @Override
            public boolean cancel(boolean bl2) {
                return future.cancel(bl2);
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future.isDone();
            }

            @Override
            public O get() {
                return this.applyTransformation(future.get());
            }

            @Override
            public O get(long l2, TimeUnit timeUnit) {
                return this.applyTransformation(future.get(l2, timeUnit));
            }

            private O applyTransformation(I i2) {
                try {
                    return function.apply(i2);
                }
                catch (Throwable throwable) {
                    throw new ExecutionException(throwable);
                }
            }
        };
    }

    @SafeVarargs
    @Beta
    public static <V> ListenableFuture<List<V>> allAsList(ListenableFuture<? extends V> ... listenableFutureArray) {
        return new CollectionFuture.ListFuture<V>(ImmutableList.copyOf(listenableFutureArray), true);
    }

    @Beta
    public static <V> ListenableFuture<List<V>> allAsList(Iterable<? extends ListenableFuture<? extends V>> iterable) {
        return new CollectionFuture.ListFuture(ImmutableList.copyOf(iterable), true);
    }

    @SafeVarargs
    @Beta
    public static <V> FutureCombiner<V> whenAllComplete(ListenableFuture<? extends V> ... listenableFutureArray) {
        return new FutureCombiner(false, ImmutableList.copyOf(listenableFutureArray));
    }

    @Beta
    public static <V> FutureCombiner<V> whenAllComplete(Iterable<? extends ListenableFuture<? extends V>> iterable) {
        return new FutureCombiner(false, ImmutableList.copyOf(iterable));
    }

    @SafeVarargs
    @Beta
    public static <V> FutureCombiner<V> whenAllSucceed(ListenableFuture<? extends V> ... listenableFutureArray) {
        return new FutureCombiner(true, ImmutableList.copyOf(listenableFutureArray));
    }

    @Beta
    public static <V> FutureCombiner<V> whenAllSucceed(Iterable<? extends ListenableFuture<? extends V>> iterable) {
        return new FutureCombiner(true, ImmutableList.copyOf(iterable));
    }

    @Beta
    public static <V> ListenableFuture<V> nonCancellationPropagating(ListenableFuture<V> listenableFuture) {
        if (listenableFuture.isDone()) {
            return listenableFuture;
        }
        NonCancellationPropagatingFuture<V> nonCancellationPropagatingFuture = new NonCancellationPropagatingFuture<V>(listenableFuture);
        listenableFuture.addListener(nonCancellationPropagatingFuture, MoreExecutors.directExecutor());
        return nonCancellationPropagatingFuture;
    }

    @SafeVarargs
    @Beta
    public static <V> ListenableFuture<List<V>> successfulAsList(ListenableFuture<? extends V> ... listenableFutureArray) {
        return new CollectionFuture.ListFuture<V>(ImmutableList.copyOf(listenableFutureArray), false);
    }

    @Beta
    public static <V> ListenableFuture<List<V>> successfulAsList(Iterable<? extends ListenableFuture<? extends V>> iterable) {
        return new CollectionFuture.ListFuture(ImmutableList.copyOf(iterable), false);
    }

    @Beta
    public static <T> ImmutableList<ListenableFuture<T>> inCompletionOrder(Iterable<? extends ListenableFuture<? extends T>> iterable) {
        ImmutableList<ListenableFuture<ListenableFuture>> immutableList = iterable instanceof Collection ? (ImmutableList<ListenableFuture<ListenableFuture>>)iterable : ImmutableList.copyOf(iterable);
        ListenableFuture[] listenableFutureArray = immutableList.toArray(new ListenableFuture[immutableList.size()]);
        final InCompletionOrderState inCompletionOrderState = new InCompletionOrderState(listenableFutureArray);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i2 = 0; i2 < listenableFutureArray.length; ++i2) {
            builder.add(new InCompletionOrderFuture(inCompletionOrderState));
        }
        ImmutableCollection immutableCollection = builder.build();
        for (int i3 = 0; i3 < listenableFutureArray.length; ++i3) {
            int n2 = i3;
            listenableFutureArray[i3].addListener(new Runnable((ImmutableList)immutableCollection, n2){
                final /* synthetic */ ImmutableList val$delegates;
                final /* synthetic */ int val$localI;
                {
                    this.val$delegates = immutableList;
                    this.val$localI = n2;
                }

                @Override
                public void run() {
                    inCompletionOrderState.recordInputCompletion(this.val$delegates, this.val$localI);
                }
            }, MoreExecutors.directExecutor());
        }
        ImmutableCollection immutableCollection2 = immutableCollection;
        return immutableCollection2;
    }

    public static <V> void addCallback(ListenableFuture<V> listenableFuture, FutureCallback<? super V> futureCallback, Executor executor) {
        Preconditions.checkNotNull(futureCallback);
        listenableFuture.addListener(new CallbackListener<V>(listenableFuture, futureCallback), executor);
    }

    @CanIgnoreReturnValue
    public static <V> V getDone(Future<V> future) {
        Preconditions.checkState(future.isDone(), "Future was expected to be done: %s", future);
        return Uninterruptibles.getUninterruptibly(future);
    }

    @Beta
    @CanIgnoreReturnValue
    @GwtIncompatible
    public static <V, X extends Exception> V getChecked(Future<V> future, Class<X> clazz) {
        return FuturesGetChecked.getChecked(future, clazz);
    }

    @Beta
    @CanIgnoreReturnValue
    @GwtIncompatible
    public static <V, X extends Exception> V getChecked(Future<V> future, Class<X> clazz, Duration duration) {
        return Futures.getChecked(future, clazz, Internal.saturatedToNanos(duration), TimeUnit.NANOSECONDS);
    }

    @Beta
    @CanIgnoreReturnValue
    @GwtIncompatible
    public static <V, X extends Exception> V getChecked(Future<V> future, Class<X> clazz, long l2, TimeUnit timeUnit) {
        return FuturesGetChecked.getChecked(future, clazz, l2, timeUnit);
    }

    @CanIgnoreReturnValue
    public static <V> V getUnchecked(Future<V> future) {
        Preconditions.checkNotNull(future);
        try {
            return Uninterruptibles.getUninterruptibly(future);
        }
        catch (ExecutionException executionException) {
            Futures.wrapAndThrowUnchecked(executionException.getCause());
            throw new AssertionError();
        }
    }

    private static void wrapAndThrowUnchecked(Throwable throwable) {
        if (throwable instanceof Error) {
            throw new ExecutionError((Error)throwable);
        }
        throw new UncheckedExecutionException(throwable);
    }

    private static final class CallbackListener<V>
    implements Runnable {
        final Future<V> future;
        final FutureCallback<? super V> callback;

        CallbackListener(Future<V> future, FutureCallback<? super V> futureCallback) {
            this.future = future;
            this.callback = futureCallback;
        }

        @Override
        public void run() {
            V v2;
            try {
                v2 = Futures.getDone(this.future);
            }
            catch (ExecutionException executionException) {
                this.callback.onFailure(executionException.getCause());
                return;
            }
            catch (Error | RuntimeException throwable) {
                this.callback.onFailure(throwable);
                return;
            }
            this.callback.onSuccess(v2);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).addValue(this.callback).toString();
        }
    }

    private static final class InCompletionOrderState<T> {
        private boolean wasCancelled = false;
        private boolean shouldInterrupt = true;
        private final AtomicInteger incompleteOutputCount;
        private final ListenableFuture<? extends T>[] inputFutures;
        private volatile int delegateIndex = 0;

        private InCompletionOrderState(ListenableFuture<? extends T>[] listenableFutureArray) {
            this.inputFutures = listenableFutureArray;
            this.incompleteOutputCount = new AtomicInteger(listenableFutureArray.length);
        }

        private void recordOutputCancellation(boolean bl2) {
            this.wasCancelled = true;
            if (!bl2) {
                this.shouldInterrupt = false;
            }
            this.recordCompletion();
        }

        private void recordInputCompletion(ImmutableList<AbstractFuture<T>> immutableList, int n2) {
            ListenableFuture<? extends T> listenableFuture = this.inputFutures[n2];
            this.inputFutures[n2] = null;
            for (int i2 = this.delegateIndex; i2 < immutableList.size(); ++i2) {
                if (!((AbstractFuture)immutableList.get(i2)).setFuture(listenableFuture)) continue;
                this.recordCompletion();
                this.delegateIndex = i2 + 1;
                return;
            }
            this.delegateIndex = immutableList.size();
        }

        private void recordCompletion() {
            if (this.incompleteOutputCount.decrementAndGet() == 0 && this.wasCancelled) {
                for (ListenableFuture<T> listenableFuture : this.inputFutures) {
                    if (listenableFuture == null) continue;
                    listenableFuture.cancel(this.shouldInterrupt);
                }
            }
        }
    }

    private static final class InCompletionOrderFuture<T>
    extends AbstractFuture<T> {
        private InCompletionOrderState<T> state;

        private InCompletionOrderFuture(InCompletionOrderState<T> inCompletionOrderState) {
            this.state = inCompletionOrderState;
        }

        @Override
        public boolean cancel(boolean bl2) {
            InCompletionOrderState<T> inCompletionOrderState = this.state;
            if (super.cancel(bl2)) {
                ((InCompletionOrderState)inCompletionOrderState).recordOutputCancellation(bl2);
                return true;
            }
            return false;
        }

        @Override
        protected void afterDone() {
            this.state = null;
        }

        @Override
        protected String pendingToString() {
            InCompletionOrderState<T> inCompletionOrderState = this.state;
            if (inCompletionOrderState != null) {
                return "inputCount=[" + ((InCompletionOrderState)inCompletionOrderState).inputFutures.length + "], remaining=[" + ((InCompletionOrderState)inCompletionOrderState).incompleteOutputCount.get() + "]";
            }
            return null;
        }
    }

    private static final class NonCancellationPropagatingFuture<V>
    extends AbstractFuture.TrustedFuture<V>
    implements Runnable {
        private ListenableFuture<V> delegate;

        NonCancellationPropagatingFuture(ListenableFuture<V> listenableFuture) {
            this.delegate = listenableFuture;
        }

        @Override
        public void run() {
            ListenableFuture<V> listenableFuture = this.delegate;
            if (listenableFuture != null) {
                this.setFuture(listenableFuture);
            }
        }

        @Override
        protected String pendingToString() {
            ListenableFuture<V> listenableFuture = this.delegate;
            if (listenableFuture != null) {
                return "delegate=[" + listenableFuture + "]";
            }
            return null;
        }

        @Override
        protected void afterDone() {
            this.delegate = null;
        }
    }

    @Beta
    @CanIgnoreReturnValue
    @GwtCompatible
    public static final class FutureCombiner<V> {
        private final boolean allMustSucceed;
        private final ImmutableList<ListenableFuture<? extends V>> futures;

        private FutureCombiner(boolean bl2, ImmutableList<ListenableFuture<? extends V>> immutableList) {
            this.allMustSucceed = bl2;
            this.futures = immutableList;
        }

        public <C> ListenableFuture<C> callAsync(AsyncCallable<C> asyncCallable, Executor executor) {
            return new CombinedFuture<C>(this.futures, this.allMustSucceed, executor, asyncCallable);
        }

        @CanIgnoreReturnValue
        public <C> ListenableFuture<C> call(Callable<C> callable, Executor executor) {
            return new CombinedFuture<C>(this.futures, this.allMustSucceed, executor, callable);
        }

        public ListenableFuture<?> run(final Runnable runnable, Executor executor) {
            return this.call(new Callable<Void>(){

                @Override
                public Void call() {
                    runnable.run();
                    return null;
                }
            }, executor);
        }
    }
}

