/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.ForwardingFluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.GwtFluentFutureCatchingSpecialization;
import com.google.common.util.concurrent.Internal;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Partially;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

@Beta
@GwtCompatible(emulated=true)
public abstract class FluentFuture<V>
extends GwtFluentFutureCatchingSpecialization<V> {
    FluentFuture() {
    }

    public static <V> FluentFuture<V> from(ListenableFuture<V> listenableFuture) {
        return listenableFuture instanceof FluentFuture ? (FluentFuture<V>)listenableFuture : new ForwardingFluentFuture<V>(listenableFuture);
    }

    @Deprecated
    public static <V> FluentFuture<V> from(FluentFuture<V> fluentFuture) {
        return Preconditions.checkNotNull(fluentFuture);
    }

    @Partially.GwtIncompatible(value="AVAILABLE but requires exceptionType to be Throwable.class")
    public final <X extends Throwable> FluentFuture<V> catching(Class<X> clazz, Function<? super X, ? extends V> function, Executor executor) {
        return (FluentFuture)Futures.catching(this, clazz, function, executor);
    }

    @Partially.GwtIncompatible(value="AVAILABLE but requires exceptionType to be Throwable.class")
    public final <X extends Throwable> FluentFuture<V> catchingAsync(Class<X> clazz, AsyncFunction<? super X, ? extends V> asyncFunction, Executor executor) {
        return (FluentFuture)Futures.catchingAsync(this, clazz, asyncFunction, executor);
    }

    @GwtIncompatible
    public final FluentFuture<V> withTimeout(Duration duration, ScheduledExecutorService scheduledExecutorService) {
        return this.withTimeout(Internal.saturatedToNanos(duration), TimeUnit.NANOSECONDS, scheduledExecutorService);
    }

    @GwtIncompatible
    public final FluentFuture<V> withTimeout(long l2, TimeUnit timeUnit, ScheduledExecutorService scheduledExecutorService) {
        return (FluentFuture)Futures.withTimeout(this, l2, timeUnit, scheduledExecutorService);
    }

    public final <T> FluentFuture<T> transformAsync(AsyncFunction<? super V, T> asyncFunction, Executor executor) {
        return (FluentFuture)Futures.transformAsync(this, asyncFunction, executor);
    }

    public final <T> FluentFuture<T> transform(Function<? super V, T> function, Executor executor) {
        return (FluentFuture)Futures.transform(this, function, executor);
    }

    public final void addCallback(FutureCallback<? super V> futureCallback, Executor executor) {
        Futures.addCallback(this, futureCallback, executor);
    }

    static abstract class TrustedFuture<V>
    extends FluentFuture<V>
    implements AbstractFuture.Trusted<V> {
        TrustedFuture() {
        }

        @Override
        @CanIgnoreReturnValue
        public final V get() {
            return super.get();
        }

        @Override
        @CanIgnoreReturnValue
        public final V get(long l2, TimeUnit timeUnit) {
            return super.get(l2, timeUnit);
        }

        @Override
        public final boolean isDone() {
            return super.isDone();
        }

        @Override
        public final boolean isCancelled() {
            return super.isCancelled();
        }

        @Override
        public final void addListener(Runnable runnable, Executor executor) {
            super.addListener(runnable, executor);
        }

        @Override
        @CanIgnoreReturnValue
        public final boolean cancel(boolean bl2) {
            return super.cancel(bl2);
        }
    }
}

