/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.TimeLimiter;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

@Beta
@CanIgnoreReturnValue
@GwtIncompatible
public final class FakeTimeLimiter
implements TimeLimiter {
    @Override
    public <T> T newProxy(T t2, Class<T> clazz, long l2, TimeUnit timeUnit) {
        Preconditions.checkNotNull(t2);
        Preconditions.checkNotNull(clazz);
        Preconditions.checkNotNull(timeUnit);
        return t2;
    }

    @Override
    public <T> T callWithTimeout(Callable<T> callable, long l2, TimeUnit timeUnit) {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(timeUnit);
        try {
            return callable.call();
        }
        catch (RuntimeException runtimeException) {
            throw new UncheckedExecutionException(runtimeException);
        }
        catch (Exception exception) {
            throw new ExecutionException(exception);
        }
        catch (Error error) {
            throw new ExecutionError(error);
        }
        catch (Throwable throwable) {
            throw new ExecutionException(throwable);
        }
    }

    @Override
    public <T> T callUninterruptiblyWithTimeout(Callable<T> callable, long l2, TimeUnit timeUnit) {
        return this.callWithTimeout(callable, l2, timeUnit);
    }

    @Override
    public void runWithTimeout(Runnable runnable, long l2, TimeUnit timeUnit) {
        Preconditions.checkNotNull(runnable);
        Preconditions.checkNotNull(timeUnit);
        try {
            runnable.run();
        }
        catch (RuntimeException runtimeException) {
            throw new UncheckedExecutionException(runtimeException);
        }
        catch (Error error) {
            throw new ExecutionError(error);
        }
        catch (Throwable throwable) {
            throw new UncheckedExecutionException(throwable);
        }
    }

    @Override
    public void runUninterruptiblyWithTimeout(Runnable runnable, long l2, TimeUnit timeUnit) {
        this.runWithTimeout(runnable, l2, timeUnit);
    }
}

