/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AsyncCallable;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

@Beta
public final class ExecutionSequencer {
    private final AtomicReference<ListenableFuture<Object>> ref = new AtomicReference<ListenableFuture<Object>>(Futures.immediateFuture(null));

    private ExecutionSequencer() {
    }

    public static ExecutionSequencer create() {
        return new ExecutionSequencer();
    }

    public <T> ListenableFuture<T> submit(final Callable<T> callable, Executor executor) {
        Preconditions.checkNotNull(callable);
        return this.submitAsync(new AsyncCallable<T>(){

            @Override
            public ListenableFuture<T> call() {
                return Futures.immediateFuture(callable.call());
            }

            public String toString() {
                return callable.toString();
            }
        }, executor);
    }

    public <T> ListenableFuture<T> submitAsync(final AsyncCallable<T> asyncCallable, final Executor executor) {
        Preconditions.checkNotNull(asyncCallable);
        final AtomicReference<RunningState> atomicReference = new AtomicReference<RunningState>(RunningState.NOT_RUN);
        AsyncCallable asyncCallable2 = new AsyncCallable<T>(){

            @Override
            public ListenableFuture<T> call() {
                if (!atomicReference.compareAndSet(RunningState.NOT_RUN, RunningState.STARTED)) {
                    return Futures.immediateCancelledFuture();
                }
                return asyncCallable.call();
            }

            public String toString() {
                return asyncCallable.toString();
            }
        };
        final SettableFuture settableFuture = SettableFuture.create();
        final ListenableFuture listenableFuture = this.ref.getAndSet(settableFuture);
        final ListenableFuture listenableFuture2 = Futures.submitAsync(asyncCallable2, new Executor(){

            @Override
            public void execute(Runnable runnable) {
                listenableFuture.addListener(runnable, executor);
            }
        });
        final ListenableFuture listenableFuture3 = Futures.nonCancellationPropagating(listenableFuture2);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (listenableFuture2.isDone() || listenableFuture3.isCancelled() && atomicReference.compareAndSet(RunningState.NOT_RUN, RunningState.CANCELLED)) {
                    settableFuture.setFuture(listenableFuture);
                }
            }
        };
        listenableFuture3.addListener(runnable, MoreExecutors.directExecutor());
        listenableFuture2.addListener(runnable, MoreExecutors.directExecutor());
        return listenableFuture3;
    }

    static enum RunningState {
        NOT_RUN,
        CANCELLED,
        STARTED;

    }
}

