/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AggregateFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(emulated=true)
abstract class CollectionFuture<V, C>
extends AggregateFuture<V, C> {
    CollectionFuture() {
    }

    static final class ListFuture<V>
    extends CollectionFuture<V, List<V>> {
        ListFuture(ImmutableCollection<? extends ListenableFuture<? extends V>> immutableCollection, boolean bl2) {
            this.init(new ListFutureRunningState(immutableCollection, bl2));
        }

        private final class ListFutureRunningState
        extends CollectionFutureRunningState {
            ListFutureRunningState(ImmutableCollection<? extends ListenableFuture<? extends V>> immutableCollection, boolean bl2) {
                super(immutableCollection, bl2);
            }

            public List<V> combine(List<Optional<V>> list) {
                ArrayList<Object> arrayList = Lists.newArrayListWithCapacity(list.size());
                for (Optional optional : list) {
                    arrayList.add(optional != null ? (Object)optional.orNull() : null);
                }
                return Collections.unmodifiableList(arrayList);
            }
        }
    }

    abstract class CollectionFutureRunningState
    extends AggregateFuture.RunningState {
        private List<Optional<V>> values;

        CollectionFutureRunningState(ImmutableCollection<? extends ListenableFuture<? extends V>> immutableCollection, boolean bl2) {
            super(immutableCollection, bl2, true);
            this.values = immutableCollection.isEmpty() ? ImmutableList.of() : Lists.newArrayListWithCapacity(immutableCollection.size());
            for (int i2 = 0; i2 < immutableCollection.size(); ++i2) {
                this.values.add(null);
            }
        }

        final void collectOneValue(boolean bl2, int n2, @Nullable V v2) {
            List list = this.values;
            if (list != null) {
                list.set(n2, Optional.fromNullable(v2));
            } else {
                Preconditions.checkState(bl2 || CollectionFuture.this.isCancelled(), "Future was done before all dependencies completed");
            }
        }

        @Override
        final void handleAllCompleted() {
            List list = this.values;
            if (list != null) {
                CollectionFuture.this.set(this.combine(list));
            } else {
                Preconditions.checkState(CollectionFuture.this.isDone());
            }
        }

        @Override
        void releaseResourcesAfterFailure() {
            super.releaseResourcesAfterFailure();
            this.values = null;
        }

        abstract C combine(List<Optional<V>> var1);
    }
}

