/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongBinaryOperator;
import java.util.function.LongUnaryOperator;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@GwtCompatible
public final class AtomicLongMap<K>
implements Serializable {
    private final ConcurrentHashMap<K, Long> map;
    private transient @MonotonicNonNull Map<K, Long> asMap;

    private AtomicLongMap(ConcurrentHashMap<K, Long> concurrentHashMap) {
        this.map = Preconditions.checkNotNull(concurrentHashMap);
    }

    public static <K> AtomicLongMap<K> create() {
        return new AtomicLongMap(new ConcurrentHashMap());
    }

    public static <K> AtomicLongMap<K> create(Map<? extends K, ? extends Long> map) {
        AtomicLongMap<? extends K> atomicLongMap = AtomicLongMap.create();
        atomicLongMap.putAll(map);
        return atomicLongMap;
    }

    public long get(K k2) {
        return this.map.getOrDefault(k2, 0L);
    }

    @CanIgnoreReturnValue
    public long incrementAndGet(K k2) {
        return this.addAndGet(k2, 1L);
    }

    @CanIgnoreReturnValue
    public long decrementAndGet(K k2) {
        return this.addAndGet(k2, -1L);
    }

    @CanIgnoreReturnValue
    public long addAndGet(K k2, long l2) {
        return this.accumulateAndGet(k2, l2, Long::sum);
    }

    @CanIgnoreReturnValue
    public long getAndIncrement(K k2) {
        return this.getAndAdd(k2, 1L);
    }

    @CanIgnoreReturnValue
    public long getAndDecrement(K k2) {
        return this.getAndAdd(k2, -1L);
    }

    @CanIgnoreReturnValue
    public long getAndAdd(K k2, long l2) {
        return this.getAndAccumulate(k2, l2, Long::sum);
    }

    @CanIgnoreReturnValue
    public long updateAndGet(K k2, LongUnaryOperator longUnaryOperator) {
        Preconditions.checkNotNull(longUnaryOperator);
        return this.map.compute(k2, (object, l2) -> longUnaryOperator.applyAsLong(l2 == null ? 0L : l2));
    }

    @CanIgnoreReturnValue
    public long getAndUpdate(K k2, LongUnaryOperator longUnaryOperator) {
        Preconditions.checkNotNull(longUnaryOperator);
        AtomicLong atomicLong = new AtomicLong();
        this.map.compute(k2, (object, l2) -> {
            long l3 = l2 == null ? 0L : l2;
            atomicLong.set(l3);
            return longUnaryOperator.applyAsLong(l3);
        });
        return atomicLong.get();
    }

    @CanIgnoreReturnValue
    public long accumulateAndGet(K k2, long l2, LongBinaryOperator longBinaryOperator) {
        Preconditions.checkNotNull(longBinaryOperator);
        return this.updateAndGet(k2, l3 -> longBinaryOperator.applyAsLong(l3, l2));
    }

    @CanIgnoreReturnValue
    public long getAndAccumulate(K k2, long l2, LongBinaryOperator longBinaryOperator) {
        Preconditions.checkNotNull(longBinaryOperator);
        return this.getAndUpdate(k2, l3 -> longBinaryOperator.applyAsLong(l3, l2));
    }

    @CanIgnoreReturnValue
    public long put(K k2, long l2) {
        return this.getAndUpdate(k2, l3 -> l2);
    }

    public void putAll(Map<? extends K, ? extends Long> map) {
        map.forEach(this::put);
    }

    @CanIgnoreReturnValue
    public long remove(K k2) {
        Long l2 = this.map.remove(k2);
        return l2 == null ? 0L : l2;
    }

    boolean remove(K k2, long l2) {
        return this.map.remove(k2, l2);
    }

    @Beta
    @CanIgnoreReturnValue
    public boolean removeIfZero(K k2) {
        return this.remove(k2, 0L);
    }

    public void removeAllZeros() {
        this.map.values().removeIf(l2 -> l2 == 0L);
    }

    public long sum() {
        return this.map.values().stream().mapToLong(Long::longValue).sum();
    }

    public Map<K, Long> asMap() {
        Map<K, Long> map = this.asMap;
        return map == null ? (this.asMap = this.createAsMap()) : map;
    }

    private Map<K, Long> createAsMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void clear() {
        this.map.clear();
    }

    public String toString() {
        return this.map.toString();
    }

    long putIfAbsent(K k2, long l2) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        Long l4 = this.map.compute(k2, (object, l3) -> {
            if (l3 == null || l3 == 0L) {
                atomicBoolean.set(true);
                return l2;
            }
            return l3;
        });
        return atomicBoolean.get() ? 0L : l4;
    }

    boolean replace(K k2, long l2, long l3) {
        if (l2 == 0L) {
            return this.putIfAbsent(k2, l3) == 0L;
        }
        return this.map.replace(k2, l2, l3);
    }
}

