/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.primitives.ImmutableLongArray;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLongArray;

@GwtIncompatible
public class AtomicDoubleArray
implements Serializable {
    private static final long serialVersionUID = 0L;
    private transient AtomicLongArray longs;

    public AtomicDoubleArray(int n2) {
        this.longs = new AtomicLongArray(n2);
    }

    public AtomicDoubleArray(double[] dArray) {
        int n2 = dArray.length;
        long[] lArray = new long[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            lArray[i2] = Double.doubleToRawLongBits(dArray[i2]);
        }
        this.longs = new AtomicLongArray(lArray);
    }

    public final int length() {
        return this.longs.length();
    }

    public final double get(int n2) {
        return Double.longBitsToDouble(this.longs.get(n2));
    }

    public final void set(int n2, double d2) {
        long l2 = Double.doubleToRawLongBits(d2);
        this.longs.set(n2, l2);
    }

    public final void lazySet(int n2, double d2) {
        long l2 = Double.doubleToRawLongBits(d2);
        this.longs.lazySet(n2, l2);
    }

    public final double getAndSet(int n2, double d2) {
        long l2 = Double.doubleToRawLongBits(d2);
        return Double.longBitsToDouble(this.longs.getAndSet(n2, l2));
    }

    public final boolean compareAndSet(int n2, double d2, double d3) {
        return this.longs.compareAndSet(n2, Double.doubleToRawLongBits(d2), Double.doubleToRawLongBits(d3));
    }

    public final boolean weakCompareAndSet(int n2, double d2, double d3) {
        return this.longs.weakCompareAndSet(n2, Double.doubleToRawLongBits(d2), Double.doubleToRawLongBits(d3));
    }

    @CanIgnoreReturnValue
    public final double getAndAdd(int n2, double d2) {
        double d3;
        double d4;
        long l2;
        long l3;
        while (!this.longs.compareAndSet(n2, l3 = this.longs.get(n2), l2 = Double.doubleToRawLongBits(d4 = (d3 = Double.longBitsToDouble(l3)) + d2))) {
        }
        return d3;
    }

    @CanIgnoreReturnValue
    public double addAndGet(int n2, double d2) {
        double d3;
        double d4;
        long l2;
        long l3;
        while (!this.longs.compareAndSet(n2, l3 = this.longs.get(n2), l2 = Double.doubleToRawLongBits(d4 = (d3 = Double.longBitsToDouble(l3)) + d2))) {
        }
        return d4;
    }

    public String toString() {
        int n2 = this.length() - 1;
        if (n2 == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(19 * (n2 + 1));
        stringBuilder.append('[');
        int n3 = 0;
        while (true) {
            stringBuilder.append(Double.longBitsToDouble(this.longs.get(n3)));
            if (n3 == n2) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(',').append(' ');
            ++n3;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        int n2 = this.length();
        objectOutputStream.writeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            objectOutputStream.writeDouble(this.get(i2));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        ImmutableLongArray.Builder builder = ImmutableLongArray.builder();
        for (int i2 = 0; i2 < n2; ++i2) {
            builder.add(Double.doubleToRawLongBits(objectInputStream.readDouble()));
        }
        this.longs = new AtomicLongArray(builder.build().toArray());
    }
}

