/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AggregateFutureState;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.errorprone.annotations.ForOverride;
import com.google.errorprone.annotations.OverridingMethodsMustInvokeSuper;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
abstract class AggregateFuture<InputT, OutputT>
extends AbstractFuture.TrustedFuture<OutputT> {
    private static final Logger logger = Logger.getLogger(AggregateFuture.class.getName());
    private @Nullable RunningState runningState;

    AggregateFuture() {
    }

    @Override
    protected final void afterDone() {
        super.afterDone();
        this.releaseResources();
    }

    protected final void releaseResources() {
        RunningState runningState = this.runningState;
        if (runningState != null) {
            this.runningState = null;
            ImmutableCollection immutableCollection = runningState.futures;
            boolean bl2 = this.wasInterrupted();
            if (bl2) {
                runningState.interruptTask();
            }
            if (this.isCancelled() & immutableCollection != null) {
                for (ListenableFuture listenableFuture : immutableCollection) {
                    listenableFuture.cancel(bl2);
                }
            }
        }
    }

    @Override
    protected String pendingToString() {
        RunningState runningState = this.runningState;
        if (runningState == null) {
            return null;
        }
        ImmutableCollection immutableCollection = runningState.futures;
        if (immutableCollection != null) {
            return "futures=[" + immutableCollection + "]";
        }
        return null;
    }

    final void init(RunningState runningState) {
        this.runningState = runningState;
        runningState.init();
    }

    private static boolean addCausalChain(Set<Throwable> set, Throwable throwable) {
        while (throwable != null) {
            boolean bl2 = set.add(throwable);
            if (!bl2) {
                return false;
            }
            throwable = throwable.getCause();
        }
        return true;
    }

    abstract class RunningState
    extends AggregateFutureState
    implements Runnable {
        private ImmutableCollection<? extends ListenableFuture<? extends InputT>> futures;
        private final boolean allMustSucceed;
        private final boolean collectsValues;

        RunningState(ImmutableCollection<? extends ListenableFuture<? extends InputT>> immutableCollection, boolean bl2, boolean bl3) {
            super(immutableCollection.size());
            this.futures = Preconditions.checkNotNull(immutableCollection);
            this.allMustSucceed = bl2;
            this.collectsValues = bl3;
        }

        @Override
        public final void run() {
            this.decrementCountAndMaybeComplete();
        }

        private void init() {
            if (this.futures.isEmpty()) {
                this.handleAllCompleted();
                return;
            }
            if (this.allMustSucceed) {
                int n2 = 0;
                for (final ListenableFuture listenableFuture : this.futures) {
                    final int n3 = n2++;
                    listenableFuture.addListener(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                RunningState.this.handleOneInputDone(n3, listenableFuture);
                            }
                            finally {
                                RunningState.this.decrementCountAndMaybeComplete();
                            }
                        }
                    }, MoreExecutors.directExecutor());
                }
            } else {
                for (ListenableFuture listenableFuture : this.futures) {
                    listenableFuture.addListener(this, MoreExecutors.directExecutor());
                }
            }
        }

        private void handleException(Throwable throwable) {
            Preconditions.checkNotNull(throwable);
            boolean bl2 = false;
            boolean bl3 = true;
            if (this.allMustSucceed) {
                bl2 = AggregateFuture.this.setException(throwable);
                if (bl2) {
                    this.releaseResourcesAfterFailure();
                } else {
                    bl3 = AggregateFuture.addCausalChain(this.getOrInitSeenExceptions(), throwable);
                }
            }
            if (throwable instanceof Error | this.allMustSucceed & !bl2 & bl3) {
                String string = throwable instanceof Error ? "Input Future failed with Error" : "Got more than one input Future failure. Logging failures after the first";
                logger.log(Level.SEVERE, string, throwable);
            }
        }

        @Override
        final void addInitialException(Set<Throwable> set) {
            if (!AggregateFuture.this.isCancelled()) {
                boolean bl2 = AggregateFuture.addCausalChain(set, AggregateFuture.this.tryInternalFastPathGetFailure());
            }
        }

        private void handleOneInputDone(int n2, Future<? extends InputT> future) {
            Preconditions.checkState(this.allMustSucceed || !AggregateFuture.this.isDone() || AggregateFuture.this.isCancelled(), "Future was done before all dependencies completed");
            try {
                Preconditions.checkState(future.isDone(), "Tried to set value from future which is not done");
                if (this.allMustSucceed) {
                    if (future.isCancelled()) {
                        AggregateFuture.this.runningState = null;
                        AggregateFuture.this.cancel(false);
                    } else {
                        Object InputT = Futures.getDone(future);
                        if (this.collectsValues) {
                            this.collectOneValue(this.allMustSucceed, n2, InputT);
                        }
                    }
                } else if (this.collectsValues && !future.isCancelled()) {
                    this.collectOneValue(this.allMustSucceed, n2, Futures.getDone(future));
                }
            }
            catch (ExecutionException executionException) {
                this.handleException(executionException.getCause());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }

        private void decrementCountAndMaybeComplete() {
            int n2 = this.decrementRemainingAndGet();
            Preconditions.checkState(n2 >= 0, "Less than 0 remaining futures");
            if (n2 == 0) {
                this.processCompleted();
            }
        }

        private void processCompleted() {
            if (this.collectsValues & !this.allMustSucceed) {
                int n2 = 0;
                for (ListenableFuture listenableFuture : this.futures) {
                    this.handleOneInputDone(n2++, listenableFuture);
                }
            }
            this.handleAllCompleted();
        }

        @ForOverride
        @OverridingMethodsMustInvokeSuper
        void releaseResourcesAfterFailure() {
            this.futures = null;
        }

        abstract void collectOneValue(boolean var1, int var2, @Nullable InputT var3);

        abstract void handleAllCompleted();

        void interruptTask() {
        }
    }
}

