/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.errorprone.annotations.ForOverride;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
abstract class AbstractTransformFuture<I, O, F, T>
extends FluentFuture.TrustedFuture<O>
implements Runnable {
    @Nullable ListenableFuture<? extends I> inputFuture;
    @Nullable F function;

    static <I, O> ListenableFuture<O> create(ListenableFuture<I> listenableFuture, AsyncFunction<? super I, ? extends O> asyncFunction, Executor executor) {
        Preconditions.checkNotNull(executor);
        AsyncTransformFuture<? super I, ? extends O> asyncTransformFuture = new AsyncTransformFuture<I, O>(listenableFuture, asyncFunction);
        listenableFuture.addListener(asyncTransformFuture, MoreExecutors.rejectionPropagatingExecutor(executor, asyncTransformFuture));
        return asyncTransformFuture;
    }

    static <I, O> ListenableFuture<O> create(ListenableFuture<I> listenableFuture, Function<? super I, ? extends O> function, Executor executor) {
        Preconditions.checkNotNull(function);
        TransformFuture<? super I, ? extends O> transformFuture = new TransformFuture<I, O>(listenableFuture, function);
        listenableFuture.addListener(transformFuture, MoreExecutors.rejectionPropagatingExecutor(executor, transformFuture));
        return transformFuture;
    }

    AbstractTransformFuture(ListenableFuture<? extends I> listenableFuture, F f2) {
        this.inputFuture = Preconditions.checkNotNull(listenableFuture);
        this.function = Preconditions.checkNotNull(f2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        T t2;
        I i2;
        ListenableFuture<I> listenableFuture = this.inputFuture;
        F f2 = this.function;
        if (this.isCancelled() | listenableFuture == null | f2 == null) {
            return;
        }
        this.inputFuture = null;
        if (listenableFuture.isCancelled()) {
            boolean bl2 = this.setFuture(listenableFuture);
            return;
        }
        try {
            i2 = Futures.getDone(listenableFuture);
        }
        catch (CancellationException cancellationException) {
            this.cancel(false);
            return;
        }
        catch (ExecutionException executionException) {
            this.setException(executionException.getCause());
            return;
        }
        catch (RuntimeException runtimeException) {
            this.setException(runtimeException);
            return;
        }
        catch (Error error) {
            this.setException(error);
            return;
        }
        try {
            t2 = this.doTransform(f2, i2);
        }
        catch (Throwable throwable) {
            this.setException(throwable);
            return;
        }
        finally {
            this.function = null;
        }
        this.setResult(t2);
    }

    @ForOverride
    abstract @Nullable T doTransform(F var1, @Nullable I var2);

    @ForOverride
    abstract void setResult(@Nullable T var1);

    @Override
    protected final void afterDone() {
        this.maybePropagateCancellationTo(this.inputFuture);
        this.inputFuture = null;
        this.function = null;
    }

    @Override
    protected String pendingToString() {
        ListenableFuture<? extends I> listenableFuture = this.inputFuture;
        F f2 = this.function;
        String string = super.pendingToString();
        String string2 = "";
        if (listenableFuture != null) {
            string2 = "inputFuture=[" + listenableFuture + "], ";
        }
        if (f2 != null) {
            return string2 + "function=[" + f2 + "]";
        }
        if (string != null) {
            return string2 + string;
        }
        return null;
    }

    private static final class TransformFuture<I, O>
    extends AbstractTransformFuture<I, O, Function<? super I, ? extends O>, O> {
        TransformFuture(ListenableFuture<? extends I> listenableFuture, Function<? super I, ? extends O> function) {
            super(listenableFuture, function);
        }

        @Override
        @Nullable O doTransform(Function<? super I, ? extends O> function, @Nullable I i2) {
            return function.apply(i2);
        }

        @Override
        void setResult(@Nullable O o2) {
            this.set(o2);
        }
    }

    private static final class AsyncTransformFuture<I, O>
    extends AbstractTransformFuture<I, O, AsyncFunction<? super I, ? extends O>, ListenableFuture<? extends O>> {
        AsyncTransformFuture(ListenableFuture<? extends I> listenableFuture, AsyncFunction<? super I, ? extends O> asyncFunction) {
            super(listenableFuture, asyncFunction);
        }

        @Override
        ListenableFuture<? extends O> doTransform(AsyncFunction<? super I, ? extends O> asyncFunction, @Nullable I i2) {
            ListenableFuture<? extends O> listenableFuture = asyncFunction.apply(i2);
            Preconditions.checkNotNull(listenableFuture, "AsyncFunction.apply returned null instead of a Future. Did you mean to return immediateFuture(null)? %s", asyncFunction);
            return listenableFuture;
        }

        @Override
        void setResult(ListenableFuture<? extends O> listenableFuture) {
            this.setFuture(listenableFuture);
        }
    }
}

