/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Platform;
import com.google.errorprone.annotations.ForOverride;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
abstract class AbstractCatchingFuture<V, X extends Throwable, F, T>
extends FluentFuture.TrustedFuture<V>
implements Runnable {
    @Nullable ListenableFuture<? extends V> inputFuture;
    @Nullable Class<X> exceptionType;
    @Nullable F fallback;

    static <V, X extends Throwable> ListenableFuture<V> create(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, Function<? super X, ? extends V> function, Executor executor) {
        CatchingFuture<? extends V, ? super X> catchingFuture = new CatchingFuture<V, X>(listenableFuture, clazz, function);
        listenableFuture.addListener(catchingFuture, MoreExecutors.rejectionPropagatingExecutor(executor, catchingFuture));
        return catchingFuture;
    }

    static <X extends Throwable, V> ListenableFuture<V> create(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, AsyncFunction<? super X, ? extends V> asyncFunction, Executor executor) {
        AsyncCatchingFuture<? extends V, ? super X> asyncCatchingFuture = new AsyncCatchingFuture<V, X>(listenableFuture, clazz, asyncFunction);
        listenableFuture.addListener(asyncCatchingFuture, MoreExecutors.rejectionPropagatingExecutor(executor, asyncCatchingFuture));
        return asyncCatchingFuture;
    }

    AbstractCatchingFuture(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, F f2) {
        this.inputFuture = Preconditions.checkNotNull(listenableFuture);
        this.exceptionType = Preconditions.checkNotNull(clazz);
        this.fallback = Preconditions.checkNotNull(f2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        T t2;
        F f2;
        Class<X> clazz;
        ListenableFuture<? extends V> listenableFuture = this.inputFuture;
        if (listenableFuture == null | (clazz = this.exceptionType) == null | (f2 = this.fallback) == null | this.isCancelled()) {
            return;
        }
        this.inputFuture = null;
        Object v2 = null;
        Throwable throwable = null;
        try {
            v2 = Futures.getDone(listenableFuture);
        }
        catch (ExecutionException executionException) {
            throwable = Preconditions.checkNotNull(executionException.getCause());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        if (throwable == null) {
            this.set(v2);
            return;
        }
        if (!Platform.isInstanceOfThrowableClass(throwable, clazz)) {
            this.setFuture(listenableFuture);
            return;
        }
        Throwable throwable3 = throwable;
        try {
            t2 = this.doFallback(f2, throwable3);
        }
        catch (Throwable throwable4) {
            this.setException(throwable4);
            return;
        }
        finally {
            this.exceptionType = null;
            this.fallback = null;
        }
        this.setResult(t2);
    }

    @Override
    protected String pendingToString() {
        ListenableFuture<? extends V> listenableFuture = this.inputFuture;
        Class<X> clazz = this.exceptionType;
        F f2 = this.fallback;
        String string = super.pendingToString();
        String string2 = "";
        if (listenableFuture != null) {
            string2 = "inputFuture=[" + listenableFuture + "], ";
        }
        if (clazz != null && f2 != null) {
            return string2 + "exceptionType=[" + clazz + "], fallback=[" + f2 + "]";
        }
        if (string != null) {
            return string2 + string;
        }
        return null;
    }

    @ForOverride
    abstract @Nullable T doFallback(F var1, X var2);

    @ForOverride
    abstract void setResult(@Nullable T var1);

    @Override
    protected final void afterDone() {
        this.maybePropagateCancellationTo(this.inputFuture);
        this.inputFuture = null;
        this.exceptionType = null;
        this.fallback = null;
    }

    private static final class CatchingFuture<V, X extends Throwable>
    extends AbstractCatchingFuture<V, X, Function<? super X, ? extends V>, V> {
        CatchingFuture(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, Function<? super X, ? extends V> function) {
            super(listenableFuture, clazz, function);
        }

        @Override
        @Nullable V doFallback(Function<? super X, ? extends V> function, X x2) {
            return function.apply(x2);
        }

        @Override
        void setResult(@Nullable V v2) {
            this.set(v2);
        }
    }

    private static final class AsyncCatchingFuture<V, X extends Throwable>
    extends AbstractCatchingFuture<V, X, AsyncFunction<? super X, ? extends V>, ListenableFuture<? extends V>> {
        AsyncCatchingFuture(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, AsyncFunction<? super X, ? extends V> asyncFunction) {
            super(listenableFuture, clazz, asyncFunction);
        }

        @Override
        ListenableFuture<? extends V> doFallback(AsyncFunction<? super X, ? extends V> asyncFunction, X x2) {
            ListenableFuture<? extends V> listenableFuture = asyncFunction.apply(x2);
            Preconditions.checkNotNull(listenableFuture, "AsyncFunction.apply returned null instead of a Future. Did you mean to return immediateFuture(null)? %s", asyncFunction);
            return listenableFuture;
        }

        @Override
        void setResult(ListenableFuture<? extends V> listenableFuture) {
            this.setFuture(listenableFuture);
        }
    }
}

