/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import com.google.common.primitives.ParseRequest;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Comparator;

@Beta
@GwtCompatible
public final class UnsignedLongs {
    public static final long MAX_VALUE = -1L;

    private UnsignedLongs() {
    }

    private static long flip(long l2) {
        return l2 ^ Long.MIN_VALUE;
    }

    public static int compare(long l2, long l3) {
        return Longs.compare(UnsignedLongs.flip(l2), UnsignedLongs.flip(l3));
    }

    public static long min(long ... lArray) {
        Preconditions.checkArgument(lArray.length > 0);
        long l2 = UnsignedLongs.flip(lArray[0]);
        for (int i2 = 1; i2 < lArray.length; ++i2) {
            long l3 = UnsignedLongs.flip(lArray[i2]);
            if (l3 >= l2) continue;
            l2 = l3;
        }
        return UnsignedLongs.flip(l2);
    }

    public static long max(long ... lArray) {
        Preconditions.checkArgument(lArray.length > 0);
        long l2 = UnsignedLongs.flip(lArray[0]);
        for (int i2 = 1; i2 < lArray.length; ++i2) {
            long l3 = UnsignedLongs.flip(lArray[i2]);
            if (l3 <= l2) continue;
            l2 = l3;
        }
        return UnsignedLongs.flip(l2);
    }

    public static String join(String string, long ... lArray) {
        Preconditions.checkNotNull(string);
        if (lArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(lArray.length * 5);
        stringBuilder.append(UnsignedLongs.toString(lArray[0]));
        for (int i2 = 1; i2 < lArray.length; ++i2) {
            stringBuilder.append(string).append(UnsignedLongs.toString(lArray[i2]));
        }
        return stringBuilder.toString();
    }

    public static Comparator<long[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sort(long[] lArray) {
        Preconditions.checkNotNull(lArray);
        UnsignedLongs.sort(lArray, 0, lArray.length);
    }

    public static void sort(long[] lArray, int n2, int n3) {
        int n4;
        Preconditions.checkNotNull(lArray);
        Preconditions.checkPositionIndexes(n2, n3, lArray.length);
        for (n4 = n2; n4 < n3; ++n4) {
            lArray[n4] = UnsignedLongs.flip(lArray[n4]);
        }
        Arrays.sort(lArray, n2, n3);
        for (n4 = n2; n4 < n3; ++n4) {
            lArray[n4] = UnsignedLongs.flip(lArray[n4]);
        }
    }

    public static void sortDescending(long[] lArray) {
        Preconditions.checkNotNull(lArray);
        UnsignedLongs.sortDescending(lArray, 0, lArray.length);
    }

    public static void sortDescending(long[] lArray, int n2, int n3) {
        Preconditions.checkNotNull(lArray);
        Preconditions.checkPositionIndexes(n2, n3, lArray.length);
        int n4 = n2;
        while (n4 < n3) {
            int n5 = n4++;
            lArray[n5] = lArray[n5] ^ Long.MAX_VALUE;
        }
        Arrays.sort(lArray, n2, n3);
        n4 = n2;
        while (n4 < n3) {
            int n6 = n4++;
            lArray[n6] = lArray[n6] ^ Long.MAX_VALUE;
        }
    }

    public static long divide(long l2, long l3) {
        long l4;
        if (l3 < 0L) {
            if (UnsignedLongs.compare(l2, l3) < 0) {
                return 0L;
            }
            return 1L;
        }
        if (l2 >= 0L) {
            return l2 / l3;
        }
        long l5 = l2 - (l4 = (l2 >>> 1) / l3 << 1) * l3;
        return l4 + (long)(UnsignedLongs.compare(l5, l3) >= 0 ? 1 : 0);
    }

    public static long remainder(long l2, long l3) {
        long l4;
        if (l3 < 0L) {
            if (UnsignedLongs.compare(l2, l3) < 0) {
                return l2;
            }
            return l2 - l3;
        }
        if (l2 >= 0L) {
            return l2 % l3;
        }
        long l5 = (l2 >>> 1) / l3 << 1;
        return l4 - (UnsignedLongs.compare(l4 = l2 - l5 * l3, l3) >= 0 ? l3 : 0L);
    }

    @CanIgnoreReturnValue
    public static long parseUnsignedLong(String string) {
        return UnsignedLongs.parseUnsignedLong(string, 10);
    }

    @CanIgnoreReturnValue
    public static long parseUnsignedLong(String string, int n2) {
        Preconditions.checkNotNull(string);
        if (string.length() == 0) {
            throw new NumberFormatException("empty string");
        }
        if (n2 < 2 || n2 > 36) {
            throw new NumberFormatException("illegal radix: " + n2);
        }
        int n3 = ParseOverflowDetection.maxSafeDigits[n2] - 1;
        long l2 = 0L;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n4 = Character.digit(string.charAt(i2), n2);
            if (n4 == -1) {
                throw new NumberFormatException(string);
            }
            if (i2 > n3 && ParseOverflowDetection.overflowInParse(l2, n4, n2)) {
                throw new NumberFormatException("Too large for unsigned long: " + string);
            }
            l2 = l2 * (long)n2 + (long)n4;
        }
        return l2;
    }

    @CanIgnoreReturnValue
    public static long decode(String string) {
        ParseRequest parseRequest = ParseRequest.fromString(string);
        try {
            return UnsignedLongs.parseUnsignedLong(parseRequest.rawValue, parseRequest.radix);
        }
        catch (NumberFormatException numberFormatException) {
            NumberFormatException numberFormatException2 = new NumberFormatException("Error parsing value: " + string);
            numberFormatException2.initCause(numberFormatException);
            throw numberFormatException2;
        }
    }

    public static String toString(long l2) {
        return UnsignedLongs.toString(l2, 10);
    }

    public static String toString(long l2, int n2) {
        Preconditions.checkArgument(n2 >= 2 && n2 <= 36, "radix (%s) must be between Character.MIN_RADIX and Character.MAX_RADIX", n2);
        if (l2 == 0L) {
            return "0";
        }
        if (l2 > 0L) {
            return Long.toString(l2, n2);
        }
        char[] cArray = new char[64];
        int n3 = cArray.length;
        if ((n2 & n2 - 1) == 0) {
            int n4 = Integer.numberOfTrailingZeros(n2);
            int n5 = n2 - 1;
            do {
                cArray[--n3] = Character.forDigit((int)l2 & n5, n2);
            } while ((l2 >>>= n4) != 0L);
        } else {
            long l3 = (n2 & 1) == 0 ? (l2 >>> 1) / (long)(n2 >>> 1) : UnsignedLongs.divide(l2, n2);
            long l4 = l2 - l3 * (long)n2;
            cArray[--n3] = Character.forDigit((int)l4, n2);
            for (l2 = l3; l2 > 0L; l2 /= (long)n2) {
                cArray[--n3] = Character.forDigit((int)(l2 % (long)n2), n2);
            }
        }
        return new String(cArray, n3, cArray.length - n3);
    }

    private static final class ParseOverflowDetection {
        static final long[] maxValueDivs = new long[37];
        static final int[] maxValueMods = new int[37];
        static final int[] maxSafeDigits = new int[37];

        private ParseOverflowDetection() {
        }

        static boolean overflowInParse(long l2, int n2, int n3) {
            if (l2 >= 0L) {
                if (l2 < maxValueDivs[n3]) {
                    return false;
                }
                if (l2 > maxValueDivs[n3]) {
                    return true;
                }
                return n2 > maxValueMods[n3];
            }
            return true;
        }

        static {
            BigInteger bigInteger = new BigInteger("10000000000000000", 16);
            for (int i2 = 2; i2 <= 36; ++i2) {
                ParseOverflowDetection.maxValueDivs[i2] = UnsignedLongs.divide(-1L, i2);
                ParseOverflowDetection.maxValueMods[i2] = (int)UnsignedLongs.remainder(-1L, i2);
                ParseOverflowDetection.maxSafeDigits[i2] = bigInteger.toString(i2).length() - 1;
            }
        }
    }

    static enum LexicographicalComparator implements Comparator<long[]>
    {
        INSTANCE;


        @Override
        public int compare(long[] lArray, long[] lArray2) {
            int n2 = Math.min(lArray.length, lArray2.length);
            for (int i2 = 0; i2 < n2; ++i2) {
                if (lArray[i2] == lArray2[i2]) continue;
                return UnsignedLongs.compare(lArray[i2], lArray2[i2]);
            }
            return lArray.length - lArray2.length;
        }

        public String toString() {
            return "UnsignedLongs.lexicographicalComparator()";
        }
    }
}

