/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.common.primitives.ParseRequest;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Arrays;
import java.util.Comparator;

@Beta
@GwtCompatible
public final class UnsignedInts {
    static final long INT_MASK = 0xFFFFFFFFL;

    private UnsignedInts() {
    }

    static int flip(int n2) {
        return n2 ^ Integer.MIN_VALUE;
    }

    public static int compare(int n2, int n3) {
        return Ints.compare(UnsignedInts.flip(n2), UnsignedInts.flip(n3));
    }

    public static long toLong(int n2) {
        return (long)n2 & 0xFFFFFFFFL;
    }

    public static int checkedCast(long l2) {
        Preconditions.checkArgument(l2 >> 32 == 0L, "out of range: %s", l2);
        return (int)l2;
    }

    public static int saturatedCast(long l2) {
        if (l2 <= 0L) {
            return 0;
        }
        if (l2 >= 0x100000000L) {
            return -1;
        }
        return (int)l2;
    }

    public static int min(int ... nArray) {
        Preconditions.checkArgument(nArray.length > 0);
        int n2 = UnsignedInts.flip(nArray[0]);
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            int n3 = UnsignedInts.flip(nArray[i2]);
            if (n3 >= n2) continue;
            n2 = n3;
        }
        return UnsignedInts.flip(n2);
    }

    public static int max(int ... nArray) {
        Preconditions.checkArgument(nArray.length > 0);
        int n2 = UnsignedInts.flip(nArray[0]);
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            int n3 = UnsignedInts.flip(nArray[i2]);
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return UnsignedInts.flip(n2);
    }

    public static String join(String string, int ... nArray) {
        Preconditions.checkNotNull(string);
        if (nArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(nArray.length * 5);
        stringBuilder.append(UnsignedInts.toString(nArray[0]));
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            stringBuilder.append(string).append(UnsignedInts.toString(nArray[i2]));
        }
        return stringBuilder.toString();
    }

    public static Comparator<int[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sort(int[] nArray) {
        Preconditions.checkNotNull(nArray);
        UnsignedInts.sort(nArray, 0, nArray.length);
    }

    public static void sort(int[] nArray, int n2, int n3) {
        int n4;
        Preconditions.checkNotNull(nArray);
        Preconditions.checkPositionIndexes(n2, n3, nArray.length);
        for (n4 = n2; n4 < n3; ++n4) {
            nArray[n4] = UnsignedInts.flip(nArray[n4]);
        }
        Arrays.sort(nArray, n2, n3);
        for (n4 = n2; n4 < n3; ++n4) {
            nArray[n4] = UnsignedInts.flip(nArray[n4]);
        }
    }

    public static void sortDescending(int[] nArray) {
        Preconditions.checkNotNull(nArray);
        UnsignedInts.sortDescending(nArray, 0, nArray.length);
    }

    public static void sortDescending(int[] nArray, int n2, int n3) {
        Preconditions.checkNotNull(nArray);
        Preconditions.checkPositionIndexes(n2, n3, nArray.length);
        int n4 = n2;
        while (n4 < n3) {
            int n5 = n4++;
            nArray[n5] = nArray[n5] ^ Integer.MAX_VALUE;
        }
        Arrays.sort(nArray, n2, n3);
        n4 = n2;
        while (n4 < n3) {
            int n6 = n4++;
            nArray[n6] = nArray[n6] ^ Integer.MAX_VALUE;
        }
    }

    public static int divide(int n2, int n3) {
        return (int)(UnsignedInts.toLong(n2) / UnsignedInts.toLong(n3));
    }

    public static int remainder(int n2, int n3) {
        return (int)(UnsignedInts.toLong(n2) % UnsignedInts.toLong(n3));
    }

    @CanIgnoreReturnValue
    public static int decode(String string) {
        ParseRequest parseRequest = ParseRequest.fromString(string);
        try {
            return UnsignedInts.parseUnsignedInt(parseRequest.rawValue, parseRequest.radix);
        }
        catch (NumberFormatException numberFormatException) {
            NumberFormatException numberFormatException2 = new NumberFormatException("Error parsing value: " + string);
            numberFormatException2.initCause(numberFormatException);
            throw numberFormatException2;
        }
    }

    @CanIgnoreReturnValue
    public static int parseUnsignedInt(String string) {
        return UnsignedInts.parseUnsignedInt(string, 10);
    }

    @CanIgnoreReturnValue
    public static int parseUnsignedInt(String string, int n2) {
        Preconditions.checkNotNull(string);
        long l2 = Long.parseLong(string, n2);
        if ((l2 & 0xFFFFFFFFL) != l2) {
            throw new NumberFormatException("Input " + string + " in base " + n2 + " is not in the range of an unsigned integer");
        }
        return (int)l2;
    }

    public static String toString(int n2) {
        return UnsignedInts.toString(n2, 10);
    }

    public static String toString(int n2, int n3) {
        long l2 = (long)n2 & 0xFFFFFFFFL;
        return Long.toString(l2, n3);
    }

    static enum LexicographicalComparator implements Comparator<int[]>
    {
        INSTANCE;


        @Override
        public int compare(int[] nArray, int[] nArray2) {
            int n2 = Math.min(nArray.length, nArray2.length);
            for (int i2 = 0; i2 < n2; ++i2) {
                if (nArray[i2] == nArray2[i2]) continue;
                return UnsignedInts.compare(nArray[i2], nArray2[i2]);
            }
            return nArray.length - nArray2.length;
        }

        public String toString() {
            return "UnsignedInts.lexicographicalComparator()";
        }
    }
}

