/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedLongs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Comparator;
import sun.misc.Unsafe;

@GwtIncompatible
public final class UnsignedBytes {
    public static final byte MAX_POWER_OF_TWO = -128;
    public static final byte MAX_VALUE = -1;
    private static final int UNSIGNED_MASK = 255;

    private UnsignedBytes() {
    }

    public static int toInt(byte by2) {
        return by2 & 0xFF;
    }

    @CanIgnoreReturnValue
    public static byte checkedCast(long l2) {
        Preconditions.checkArgument(l2 >> 8 == 0L, "out of range: %s", l2);
        return (byte)l2;
    }

    public static byte saturatedCast(long l2) {
        if (l2 > (long)UnsignedBytes.toInt((byte)-1)) {
            return -1;
        }
        if (l2 < 0L) {
            return 0;
        }
        return (byte)l2;
    }

    public static int compare(byte by2, byte by3) {
        return UnsignedBytes.toInt(by2) - UnsignedBytes.toInt(by3);
    }

    public static byte min(byte ... byArray) {
        Preconditions.checkArgument(byArray.length > 0);
        int n2 = UnsignedBytes.toInt(byArray[0]);
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            int n3 = UnsignedBytes.toInt(byArray[i2]);
            if (n3 >= n2) continue;
            n2 = n3;
        }
        return (byte)n2;
    }

    public static byte max(byte ... byArray) {
        Preconditions.checkArgument(byArray.length > 0);
        int n2 = UnsignedBytes.toInt(byArray[0]);
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            int n3 = UnsignedBytes.toInt(byArray[i2]);
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return (byte)n2;
    }

    @Beta
    public static String toString(byte by2) {
        return UnsignedBytes.toString(by2, 10);
    }

    @Beta
    public static String toString(byte by2, int n2) {
        Preconditions.checkArgument(n2 >= 2 && n2 <= 36, "radix (%s) must be between Character.MIN_RADIX and Character.MAX_RADIX", n2);
        return Integer.toString(UnsignedBytes.toInt(by2), n2);
    }

    @Beta
    @CanIgnoreReturnValue
    public static byte parseUnsignedByte(String string) {
        return UnsignedBytes.parseUnsignedByte(string, 10);
    }

    @Beta
    @CanIgnoreReturnValue
    public static byte parseUnsignedByte(String string, int n2) {
        int n3 = Integer.parseInt(Preconditions.checkNotNull(string), n2);
        if (n3 >> 8 == 0) {
            return (byte)n3;
        }
        throw new NumberFormatException("out of range: " + n3);
    }

    public static String join(String string, byte ... byArray) {
        Preconditions.checkNotNull(string);
        if (byArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(byArray.length * (3 + string.length()));
        stringBuilder.append(UnsignedBytes.toInt(byArray[0]));
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            stringBuilder.append(string).append(UnsignedBytes.toString(byArray[i2]));
        }
        return stringBuilder.toString();
    }

    public static Comparator<byte[]> lexicographicalComparator() {
        return LexicographicalComparatorHolder.BEST_COMPARATOR;
    }

    @VisibleForTesting
    static Comparator<byte[]> lexicographicalComparatorJavaImpl() {
        return LexicographicalComparatorHolder.PureJavaComparator.INSTANCE;
    }

    private static byte flip(byte by2) {
        return (byte)(by2 ^ 0x80);
    }

    public static void sort(byte[] byArray) {
        Preconditions.checkNotNull(byArray);
        UnsignedBytes.sort(byArray, 0, byArray.length);
    }

    public static void sort(byte[] byArray, int n2, int n3) {
        int n4;
        Preconditions.checkNotNull(byArray);
        Preconditions.checkPositionIndexes(n2, n3, byArray.length);
        for (n4 = n2; n4 < n3; ++n4) {
            byArray[n4] = UnsignedBytes.flip(byArray[n4]);
        }
        Arrays.sort(byArray, n2, n3);
        for (n4 = n2; n4 < n3; ++n4) {
            byArray[n4] = UnsignedBytes.flip(byArray[n4]);
        }
    }

    public static void sortDescending(byte[] byArray) {
        Preconditions.checkNotNull(byArray);
        UnsignedBytes.sortDescending(byArray, 0, byArray.length);
    }

    public static void sortDescending(byte[] byArray, int n2, int n3) {
        Preconditions.checkNotNull(byArray);
        Preconditions.checkPositionIndexes(n2, n3, byArray.length);
        int n4 = n2;
        while (n4 < n3) {
            int n5 = n4++;
            byArray[n5] = (byte)(byArray[n5] ^ 0x7F);
        }
        Arrays.sort(byArray, n2, n3);
        n4 = n2;
        while (n4 < n3) {
            int n6 = n4++;
            byArray[n6] = (byte)(byArray[n6] ^ 0x7F);
        }
    }

    @VisibleForTesting
    static class LexicographicalComparatorHolder {
        static final String UNSAFE_COMPARATOR_NAME = LexicographicalComparatorHolder.class.getName() + "$UnsafeComparator";
        static final Comparator<byte[]> BEST_COMPARATOR = LexicographicalComparatorHolder.getBestComparator();

        LexicographicalComparatorHolder() {
        }

        static Comparator<byte[]> getBestComparator() {
            try {
                Class<?> clazz = Class.forName(UNSAFE_COMPARATOR_NAME);
                Comparator comparator = (Comparator)clazz.getEnumConstants()[0];
                return comparator;
            }
            catch (Throwable throwable) {
                return UnsignedBytes.lexicographicalComparatorJavaImpl();
            }
        }

        static enum PureJavaComparator implements Comparator<byte[]>
        {
            INSTANCE;


            @Override
            public int compare(byte[] byArray, byte[] byArray2) {
                int n2 = Math.min(byArray.length, byArray2.length);
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n3 = UnsignedBytes.compare(byArray[i2], byArray2[i2]);
                    if (n3 == 0) continue;
                    return n3;
                }
                return byArray.length - byArray2.length;
            }

            public String toString() {
                return "UnsignedBytes.lexicographicalComparator() (pure Java version)";
            }
        }

        @VisibleForTesting
        static enum UnsafeComparator implements Comparator<byte[]>
        {
            INSTANCE;

            static final boolean BIG_ENDIAN;
            static final Unsafe theUnsafe;
            static final int BYTE_ARRAY_BASE_OFFSET;

            private static Unsafe getUnsafe() {
                try {
                    return Unsafe.getUnsafe();
                }
                catch (SecurityException securityException) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                            @Override
                            public Unsafe run() {
                                Class<Unsafe> clazz = Unsafe.class;
                                for (Field field : clazz.getDeclaredFields()) {
                                    field.setAccessible(true);
                                    Object object = field.get(null);
                                    if (!clazz.isInstance(object)) continue;
                                    return (Unsafe)clazz.cast(object);
                                }
                                throw new NoSuchFieldError("the Unsafe");
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw new RuntimeException("Could not initialize intrinsics", privilegedActionException.getCause());
                    }
                }
            }

            @Override
            public int compare(byte[] byArray, byte[] byArray2) {
                int n2;
                int n3 = 8;
                int n4 = Math.min(byArray.length, byArray2.length);
                int n5 = n4 & 0xFFFFFFF8;
                for (n2 = 0; n2 < n5; n2 += 8) {
                    long l2;
                    long l3 = theUnsafe.getLong(byArray, (long)BYTE_ARRAY_BASE_OFFSET + (long)n2);
                    if (l3 == (l2 = theUnsafe.getLong(byArray2, (long)BYTE_ARRAY_BASE_OFFSET + (long)n2))) continue;
                    if (BIG_ENDIAN) {
                        return UnsignedLongs.compare(l3, l2);
                    }
                    int n6 = Long.numberOfTrailingZeros(l3 ^ l2) & 0xFFFFFFF8;
                    return (int)(l3 >>> n6 & 0xFFL) - (int)(l2 >>> n6 & 0xFFL);
                }
                while (n2 < n4) {
                    int n7 = UnsignedBytes.compare(byArray[n2], byArray2[n2]);
                    if (n7 != 0) {
                        return n7;
                    }
                    ++n2;
                }
                return byArray.length - byArray2.length;
            }

            public String toString() {
                return "UnsignedBytes.lexicographicalComparator() (sun.misc.Unsafe version)";
            }

            static {
                BIG_ENDIAN = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
                theUnsafe = UnsafeComparator.getUnsafe();
                BYTE_ARRAY_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
                if (!"64".equals(System.getProperty("sun.arch.data.model")) || BYTE_ARRAY_BASE_OFFSET % 8 != 0 || theUnsafe.arrayIndexScale(byte[].class) != 1) {
                    throw new Error();
                }
            }
        }
    }
}

