/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Bytes;
import java.util.Arrays;
import java.util.Comparator;

@GwtCompatible
public final class SignedBytes {
    public static final byte MAX_POWER_OF_TWO = 64;

    private SignedBytes() {
    }

    public static byte checkedCast(long l2) {
        byte by2 = (byte)l2;
        Preconditions.checkArgument((long)by2 == l2, "Out of range: %s", l2);
        return by2;
    }

    public static byte saturatedCast(long l2) {
        if (l2 > 127L) {
            return 127;
        }
        if (l2 < -128L) {
            return -128;
        }
        return (byte)l2;
    }

    public static int compare(byte by2, byte by3) {
        return by2 - by3;
    }

    public static byte min(byte ... byArray) {
        Preconditions.checkArgument(byArray.length > 0);
        byte by2 = byArray[0];
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            if (byArray[i2] >= by2) continue;
            by2 = byArray[i2];
        }
        return by2;
    }

    public static byte max(byte ... byArray) {
        Preconditions.checkArgument(byArray.length > 0);
        byte by2 = byArray[0];
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            if (byArray[i2] <= by2) continue;
            by2 = byArray[i2];
        }
        return by2;
    }

    public static String join(String string, byte ... byArray) {
        Preconditions.checkNotNull(string);
        if (byArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 5);
        stringBuilder.append(byArray[0]);
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            stringBuilder.append(string).append(byArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static Comparator<byte[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sortDescending(byte[] byArray) {
        Preconditions.checkNotNull(byArray);
        SignedBytes.sortDescending(byArray, 0, byArray.length);
    }

    public static void sortDescending(byte[] byArray, int n2, int n3) {
        Preconditions.checkNotNull(byArray);
        Preconditions.checkPositionIndexes(n2, n3, byArray.length);
        Arrays.sort(byArray, n2, n3);
        Bytes.reverse(byArray, n2, n3);
    }

    private static enum LexicographicalComparator implements Comparator<byte[]>
    {
        INSTANCE;


        @Override
        public int compare(byte[] byArray, byte[] byArray2) {
            int n2 = Math.min(byArray.length, byArray2.length);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = SignedBytes.compare(byArray[i2], byArray2[i2]);
                if (n3 == 0) continue;
                return n3;
            }
            return byArray.length - byArray2.length;
        }

        public String toString() {
            return "SignedBytes.lexicographicalComparator()";
        }
    }
}

