/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(emulated=true)
public final class Shorts {
    public static final int BYTES = 2;
    public static final short MAX_POWER_OF_TWO = 16384;

    private Shorts() {
    }

    public static int hashCode(short s2) {
        return s2;
    }

    public static short checkedCast(long l2) {
        short s2 = (short)l2;
        Preconditions.checkArgument((long)s2 == l2, "Out of range: %s", l2);
        return s2;
    }

    public static short saturatedCast(long l2) {
        if (l2 > 32767L) {
            return Short.MAX_VALUE;
        }
        if (l2 < -32768L) {
            return Short.MIN_VALUE;
        }
        return (short)l2;
    }

    public static int compare(short s2, short s3) {
        return s2 - s3;
    }

    public static boolean contains(short[] sArray, short s2) {
        for (short s3 : sArray) {
            if (s3 != s2) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(short[] sArray, short s2) {
        return Shorts.indexOf(sArray, s2, 0, sArray.length);
    }

    private static int indexOf(short[] sArray, short s2, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            if (sArray[i2] != s2) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(short[] sArray, short[] sArray2) {
        Preconditions.checkNotNull(sArray, "array");
        Preconditions.checkNotNull(sArray2, "target");
        if (sArray2.length == 0) {
            return 0;
        }
        block0: for (int i2 = 0; i2 < sArray.length - sArray2.length + 1; ++i2) {
            for (int i3 = 0; i3 < sArray2.length; ++i3) {
                if (sArray[i2 + i3] != sArray2[i3]) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(short[] sArray, short s2) {
        return Shorts.lastIndexOf(sArray, s2, 0, sArray.length);
    }

    private static int lastIndexOf(short[] sArray, short s2, int n2, int n3) {
        for (int i2 = n3 - 1; i2 >= n2; --i2) {
            if (sArray[i2] != s2) continue;
            return i2;
        }
        return -1;
    }

    public static short min(short ... sArray) {
        Preconditions.checkArgument(sArray.length > 0);
        short s2 = sArray[0];
        for (int i2 = 1; i2 < sArray.length; ++i2) {
            if (sArray[i2] >= s2) continue;
            s2 = sArray[i2];
        }
        return s2;
    }

    public static short max(short ... sArray) {
        Preconditions.checkArgument(sArray.length > 0);
        short s2 = sArray[0];
        for (int i2 = 1; i2 < sArray.length; ++i2) {
            if (sArray[i2] <= s2) continue;
            s2 = sArray[i2];
        }
        return s2;
    }

    @Beta
    public static short constrainToRange(short s2, short s3, short s4) {
        Preconditions.checkArgument(s3 <= s4, "min (%s) must be less than or equal to max (%s)", (int)s3, (int)s4);
        return s2 < s3 ? s3 : (s2 < s4 ? s2 : s4);
    }

    public static short[] concat(short[] ... sArray) {
        int n2 = 0;
        for (short[] sArray2 : sArray) {
            n2 += sArray2.length;
        }
        short[] sArray3 = new short[n2];
        int n3 = 0;
        for (short[] sArray4 : sArray) {
            System.arraycopy(sArray4, 0, sArray3, n3, sArray4.length);
            n3 += sArray4.length;
        }
        return sArray3;
    }

    @GwtIncompatible
    public static byte[] toByteArray(short s2) {
        return new byte[]{(byte)(s2 >> 8), (byte)s2};
    }

    @GwtIncompatible
    public static short fromByteArray(byte[] byArray) {
        Preconditions.checkArgument(byArray.length >= 2, "array too small: %s < %s", byArray.length, 2);
        return Shorts.fromBytes(byArray[0], byArray[1]);
    }

    @GwtIncompatible
    public static short fromBytes(byte by2, byte by3) {
        return (short)(by2 << 8 | by3 & 0xFF);
    }

    @Beta
    public static Converter<String, Short> stringConverter() {
        return ShortConverter.INSTANCE;
    }

    public static short[] ensureCapacity(short[] sArray, int n2, int n3) {
        Preconditions.checkArgument(n2 >= 0, "Invalid minLength: %s", n2);
        Preconditions.checkArgument(n3 >= 0, "Invalid padding: %s", n3);
        return sArray.length < n2 ? Arrays.copyOf(sArray, n2 + n3) : sArray;
    }

    public static String join(String string, short ... sArray) {
        Preconditions.checkNotNull(string);
        if (sArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(sArray.length * 6);
        stringBuilder.append(sArray[0]);
        for (int i2 = 1; i2 < sArray.length; ++i2) {
            stringBuilder.append(string).append(sArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static Comparator<short[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sortDescending(short[] sArray) {
        Preconditions.checkNotNull(sArray);
        Shorts.sortDescending(sArray, 0, sArray.length);
    }

    public static void sortDescending(short[] sArray, int n2, int n3) {
        Preconditions.checkNotNull(sArray);
        Preconditions.checkPositionIndexes(n2, n3, sArray.length);
        Arrays.sort(sArray, n2, n3);
        Shorts.reverse(sArray, n2, n3);
    }

    public static void reverse(short[] sArray) {
        Preconditions.checkNotNull(sArray);
        Shorts.reverse(sArray, 0, sArray.length);
    }

    public static void reverse(short[] sArray, int n2, int n3) {
        Preconditions.checkNotNull(sArray);
        Preconditions.checkPositionIndexes(n2, n3, sArray.length);
        int n4 = n2;
        for (int i2 = n3 - 1; n4 < i2; ++n4, --i2) {
            short s2 = sArray[n4];
            sArray[n4] = sArray[i2];
            sArray[i2] = s2;
        }
    }

    public static short[] toArray(Collection<? extends Number> collection) {
        if (collection instanceof ShortArrayAsList) {
            return ((ShortArrayAsList)collection).toShortArray();
        }
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        short[] sArray = new short[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            sArray[i2] = ((Number)Preconditions.checkNotNull(objectArray[i2])).shortValue();
        }
        return sArray;
    }

    public static List<Short> asList(short ... sArray) {
        if (sArray.length == 0) {
            return Collections.emptyList();
        }
        return new ShortArrayAsList(sArray);
    }

    @GwtCompatible
    private static class ShortArrayAsList
    extends AbstractList<Short>
    implements Serializable,
    RandomAccess {
        final short[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        ShortArrayAsList(short[] sArray) {
            this(sArray, 0, sArray.length);
        }

        ShortArrayAsList(short[] sArray, int n2, int n3) {
            this.array = sArray;
            this.start = n2;
            this.end = n3;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Short get(int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            return this.array[this.start + n2];
        }

        @Override
        public boolean contains(@Nullable Object object) {
            return object instanceof Short && Shorts.indexOf(this.array, (Short)object, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(@Nullable Object object) {
            int n2;
            if (object instanceof Short && (n2 = Shorts.indexOf(this.array, (Short)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(@Nullable Object object) {
            int n2;
            if (object instanceof Short && (n2 = Shorts.lastIndexOf(this.array, (Short)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public Short set(int n2, Short s2) {
            Preconditions.checkElementIndex(n2, this.size());
            short s3 = this.array[this.start + n2];
            this.array[this.start + n2] = Preconditions.checkNotNull(s2);
            return s3;
        }

        @Override
        public List<Short> subList(int n2, int n3) {
            int n4 = this.size();
            Preconditions.checkPositionIndexes(n2, n3, n4);
            if (n2 == n3) {
                return Collections.emptyList();
            }
            return new ShortArrayAsList(this.array, this.start + n2, this.start + n3);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ShortArrayAsList) {
                ShortArrayAsList shortArrayAsList = (ShortArrayAsList)object;
                int n2 = this.size();
                if (shortArrayAsList.size() != n2) {
                    return false;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.array[this.start + i2] == shortArrayAsList.array[shortArrayAsList.start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int n2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                n2 = 31 * n2 + Shorts.hashCode(this.array[i2]);
            }
            return n2;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.size() * 6);
            stringBuilder.append('[').append(this.array[this.start]);
            for (int i2 = this.start + 1; i2 < this.end; ++i2) {
                stringBuilder.append(", ").append(this.array[i2]);
            }
            return stringBuilder.append(']').toString();
        }

        short[] toShortArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }
    }

    private static enum LexicographicalComparator implements Comparator<short[]>
    {
        INSTANCE;


        @Override
        public int compare(short[] sArray, short[] sArray2) {
            int n2 = Math.min(sArray.length, sArray2.length);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = Shorts.compare(sArray[i2], sArray2[i2]);
                if (n3 == 0) continue;
                return n3;
            }
            return sArray.length - sArray2.length;
        }

        public String toString() {
            return "Shorts.lexicographicalComparator()";
        }
    }

    private static final class ShortConverter
    extends Converter<String, Short>
    implements Serializable {
        static final ShortConverter INSTANCE = new ShortConverter();
        private static final long serialVersionUID = 1L;

        private ShortConverter() {
        }

        @Override
        protected Short doForward(String string) {
            return Short.decode(string);
        }

        @Override
        protected String doBackward(Short s2) {
            return s2.toString();
        }

        public String toString() {
            return "Shorts.stringConverter()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

