/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
public final class Longs {
    public static final int BYTES = 8;
    public static final long MAX_POWER_OF_TWO = 0x4000000000000000L;

    private Longs() {
    }

    public static int hashCode(long l2) {
        return (int)(l2 ^ l2 >>> 32);
    }

    public static int compare(long l2, long l3) {
        return l2 < l3 ? -1 : (l2 > l3 ? 1 : 0);
    }

    public static boolean contains(long[] lArray, long l2) {
        for (long l3 : lArray) {
            if (l3 != l2) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(long[] lArray, long l2) {
        return Longs.indexOf(lArray, l2, 0, lArray.length);
    }

    private static int indexOf(long[] lArray, long l2, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            if (lArray[i2] != l2) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(long[] lArray, long[] lArray2) {
        Preconditions.checkNotNull(lArray, "array");
        Preconditions.checkNotNull(lArray2, "target");
        if (lArray2.length == 0) {
            return 0;
        }
        block0: for (int i2 = 0; i2 < lArray.length - lArray2.length + 1; ++i2) {
            for (int i3 = 0; i3 < lArray2.length; ++i3) {
                if (lArray[i2 + i3] != lArray2[i3]) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(long[] lArray, long l2) {
        return Longs.lastIndexOf(lArray, l2, 0, lArray.length);
    }

    private static int lastIndexOf(long[] lArray, long l2, int n2, int n3) {
        for (int i2 = n3 - 1; i2 >= n2; --i2) {
            if (lArray[i2] != l2) continue;
            return i2;
        }
        return -1;
    }

    public static long min(long ... lArray) {
        Preconditions.checkArgument(lArray.length > 0);
        long l2 = lArray[0];
        for (int i2 = 1; i2 < lArray.length; ++i2) {
            if (lArray[i2] >= l2) continue;
            l2 = lArray[i2];
        }
        return l2;
    }

    public static long max(long ... lArray) {
        Preconditions.checkArgument(lArray.length > 0);
        long l2 = lArray[0];
        for (int i2 = 1; i2 < lArray.length; ++i2) {
            if (lArray[i2] <= l2) continue;
            l2 = lArray[i2];
        }
        return l2;
    }

    @Beta
    public static long constrainToRange(long l2, long l3, long l4) {
        Preconditions.checkArgument(l3 <= l4, "min (%s) must be less than or equal to max (%s)", l3, l4);
        return Math.min(Math.max(l2, l3), l4);
    }

    public static long[] concat(long[] ... lArray) {
        int n2 = 0;
        for (long[] lArray2 : lArray) {
            n2 += lArray2.length;
        }
        long[] lArray3 = new long[n2];
        int n3 = 0;
        for (long[] lArray4 : lArray) {
            System.arraycopy(lArray4, 0, lArray3, n3, lArray4.length);
            n3 += lArray4.length;
        }
        return lArray3;
    }

    public static byte[] toByteArray(long l2) {
        byte[] byArray = new byte[8];
        for (int i2 = 7; i2 >= 0; --i2) {
            byArray[i2] = (byte)(l2 & 0xFFL);
            l2 >>= 8;
        }
        return byArray;
    }

    public static long fromByteArray(byte[] byArray) {
        Preconditions.checkArgument(byArray.length >= 8, "array too small: %s < %s", byArray.length, 8);
        return Longs.fromBytes(byArray[0], byArray[1], byArray[2], byArray[3], byArray[4], byArray[5], byArray[6], byArray[7]);
    }

    public static long fromBytes(byte by2, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8, byte by9) {
        return ((long)by2 & 0xFFL) << 56 | ((long)by3 & 0xFFL) << 48 | ((long)by4 & 0xFFL) << 40 | ((long)by5 & 0xFFL) << 32 | ((long)by6 & 0xFFL) << 24 | ((long)by7 & 0xFFL) << 16 | ((long)by8 & 0xFFL) << 8 | (long)by9 & 0xFFL;
    }

    @Beta
    public static @Nullable Long tryParse(String string) {
        return Longs.tryParse(string, 10);
    }

    @Beta
    public static @Nullable Long tryParse(String string, int n2) {
        int n3;
        int n4;
        if (Preconditions.checkNotNull(string).isEmpty()) {
            return null;
        }
        if (n2 < 2 || n2 > 36) {
            throw new IllegalArgumentException("radix must be between MIN_RADIX and MAX_RADIX but was " + n2);
        }
        boolean bl2 = string.charAt(0) == '-';
        int n5 = n4 = bl2 ? 1 : 0;
        if (n4 == string.length()) {
            return null;
        }
        if ((n3 = AsciiDigits.digit(string.charAt(n4++))) < 0 || n3 >= n2) {
            return null;
        }
        long l2 = -n3;
        long l3 = Long.MIN_VALUE / (long)n2;
        while (n4 < string.length()) {
            if ((n3 = AsciiDigits.digit(string.charAt(n4++))) < 0 || n3 >= n2 || l2 < l3) {
                return null;
            }
            if ((l2 *= (long)n2) < Long.MIN_VALUE + (long)n3) {
                return null;
            }
            l2 -= (long)n3;
        }
        if (bl2) {
            return l2;
        }
        if (l2 == Long.MIN_VALUE) {
            return null;
        }
        return -l2;
    }

    @Beta
    public static Converter<String, Long> stringConverter() {
        return LongConverter.INSTANCE;
    }

    public static long[] ensureCapacity(long[] lArray, int n2, int n3) {
        Preconditions.checkArgument(n2 >= 0, "Invalid minLength: %s", n2);
        Preconditions.checkArgument(n3 >= 0, "Invalid padding: %s", n3);
        return lArray.length < n2 ? Arrays.copyOf(lArray, n2 + n3) : lArray;
    }

    public static String join(String string, long ... lArray) {
        Preconditions.checkNotNull(string);
        if (lArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(lArray.length * 10);
        stringBuilder.append(lArray[0]);
        for (int i2 = 1; i2 < lArray.length; ++i2) {
            stringBuilder.append(string).append(lArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static Comparator<long[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sortDescending(long[] lArray) {
        Preconditions.checkNotNull(lArray);
        Longs.sortDescending(lArray, 0, lArray.length);
    }

    public static void sortDescending(long[] lArray, int n2, int n3) {
        Preconditions.checkNotNull(lArray);
        Preconditions.checkPositionIndexes(n2, n3, lArray.length);
        Arrays.sort(lArray, n2, n3);
        Longs.reverse(lArray, n2, n3);
    }

    public static void reverse(long[] lArray) {
        Preconditions.checkNotNull(lArray);
        Longs.reverse(lArray, 0, lArray.length);
    }

    public static void reverse(long[] lArray, int n2, int n3) {
        Preconditions.checkNotNull(lArray);
        Preconditions.checkPositionIndexes(n2, n3, lArray.length);
        int n4 = n2;
        for (int i2 = n3 - 1; n4 < i2; ++n4, --i2) {
            long l2 = lArray[n4];
            lArray[n4] = lArray[i2];
            lArray[i2] = l2;
        }
    }

    public static long[] toArray(Collection<? extends Number> collection) {
        if (collection instanceof LongArrayAsList) {
            return ((LongArrayAsList)collection).toLongArray();
        }
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        long[] lArray = new long[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            lArray[i2] = ((Number)Preconditions.checkNotNull(objectArray[i2])).longValue();
        }
        return lArray;
    }

    public static List<Long> asList(long ... lArray) {
        if (lArray.length == 0) {
            return Collections.emptyList();
        }
        return new LongArrayAsList(lArray);
    }

    @GwtCompatible
    private static class LongArrayAsList
    extends AbstractList<Long>
    implements Serializable,
    RandomAccess {
        final long[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        LongArrayAsList(long[] lArray) {
            this(lArray, 0, lArray.length);
        }

        LongArrayAsList(long[] lArray, int n2, int n3) {
            this.array = lArray;
            this.start = n2;
            this.end = n3;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Long get(int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            return this.array[this.start + n2];
        }

        public Spliterator.OfLong spliterator() {
            return Spliterators.spliterator(this.array, this.start, this.end, 0);
        }

        @Override
        public boolean contains(Object object) {
            return object instanceof Long && Longs.indexOf(this.array, (Long)object, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object object) {
            int n2;
            if (object instanceof Long && (n2 = Longs.indexOf(this.array, (Long)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            int n2;
            if (object instanceof Long && (n2 = Longs.lastIndexOf(this.array, (Long)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public Long set(int n2, Long l2) {
            Preconditions.checkElementIndex(n2, this.size());
            long l3 = this.array[this.start + n2];
            this.array[this.start + n2] = Preconditions.checkNotNull(l2);
            return l3;
        }

        @Override
        public List<Long> subList(int n2, int n3) {
            int n4 = this.size();
            Preconditions.checkPositionIndexes(n2, n3, n4);
            if (n2 == n3) {
                return Collections.emptyList();
            }
            return new LongArrayAsList(this.array, this.start + n2, this.start + n3);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof LongArrayAsList) {
                LongArrayAsList longArrayAsList = (LongArrayAsList)object;
                int n2 = this.size();
                if (longArrayAsList.size() != n2) {
                    return false;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.array[this.start + i2] == longArrayAsList.array[longArrayAsList.start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int n2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                n2 = 31 * n2 + Longs.hashCode(this.array[i2]);
            }
            return n2;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.size() * 10);
            stringBuilder.append('[').append(this.array[this.start]);
            for (int i2 = this.start + 1; i2 < this.end; ++i2) {
                stringBuilder.append(", ").append(this.array[i2]);
            }
            return stringBuilder.append(']').toString();
        }

        long[] toLongArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }
    }

    private static enum LexicographicalComparator implements Comparator<long[]>
    {
        INSTANCE;


        @Override
        public int compare(long[] lArray, long[] lArray2) {
            int n2 = Math.min(lArray.length, lArray2.length);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = Longs.compare(lArray[i2], lArray2[i2]);
                if (n3 == 0) continue;
                return n3;
            }
            return lArray.length - lArray2.length;
        }

        public String toString() {
            return "Longs.lexicographicalComparator()";
        }
    }

    private static final class LongConverter
    extends Converter<String, Long>
    implements Serializable {
        static final LongConverter INSTANCE = new LongConverter();
        private static final long serialVersionUID = 1L;

        private LongConverter() {
        }

        @Override
        protected Long doForward(String string) {
            return Long.decode(string);
        }

        @Override
        protected String doBackward(Long l2) {
            return l2.toString();
        }

        public String toString() {
            return "Longs.stringConverter()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    static final class AsciiDigits {
        private static final byte[] asciiDigits;

        private AsciiDigits() {
        }

        static int digit(char c2) {
            return c2 < '\u0080' ? asciiDigits[c2] : -1;
        }

        static {
            int n2;
            byte[] byArray = new byte[128];
            Arrays.fill(byArray, (byte)-1);
            for (n2 = 0; n2 <= 9; ++n2) {
                byArray[48 + n2] = (byte)n2;
            }
            for (n2 = 0; n2 <= 26; ++n2) {
                byArray[65 + n2] = (byte)(10 + n2);
                byArray[97 + n2] = (byte)(10 + n2);
            }
            asciiDigits = byArray;
        }
    }
}

