/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
public final class Ints {
    public static final int BYTES = 4;
    public static final int MAX_POWER_OF_TWO = 0x40000000;

    private Ints() {
    }

    public static int hashCode(int n2) {
        return n2;
    }

    public static int checkedCast(long l2) {
        int n2 = (int)l2;
        Preconditions.checkArgument((long)n2 == l2, "Out of range: %s", l2);
        return n2;
    }

    public static int saturatedCast(long l2) {
        if (l2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (l2 < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)l2;
    }

    public static int compare(int n2, int n3) {
        return n2 < n3 ? -1 : (n2 > n3 ? 1 : 0);
    }

    public static boolean contains(int[] nArray, int n2) {
        for (int n3 : nArray) {
            if (n3 != n2) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(int[] nArray, int n2) {
        return Ints.indexOf(nArray, n2, 0, nArray.length);
    }

    private static int indexOf(int[] nArray, int n2, int n3, int n4) {
        for (int i2 = n3; i2 < n4; ++i2) {
            if (nArray[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(int[] nArray, int[] nArray2) {
        Preconditions.checkNotNull(nArray, "array");
        Preconditions.checkNotNull(nArray2, "target");
        if (nArray2.length == 0) {
            return 0;
        }
        block0: for (int i2 = 0; i2 < nArray.length - nArray2.length + 1; ++i2) {
            for (int i3 = 0; i3 < nArray2.length; ++i3) {
                if (nArray[i2 + i3] != nArray2[i3]) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(int[] nArray, int n2) {
        return Ints.lastIndexOf(nArray, n2, 0, nArray.length);
    }

    private static int lastIndexOf(int[] nArray, int n2, int n3, int n4) {
        for (int i2 = n4 - 1; i2 >= n3; --i2) {
            if (nArray[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    public static int min(int ... nArray) {
        Preconditions.checkArgument(nArray.length > 0);
        int n2 = nArray[0];
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            if (nArray[i2] >= n2) continue;
            n2 = nArray[i2];
        }
        return n2;
    }

    public static int max(int ... nArray) {
        Preconditions.checkArgument(nArray.length > 0);
        int n2 = nArray[0];
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            if (nArray[i2] <= n2) continue;
            n2 = nArray[i2];
        }
        return n2;
    }

    @Beta
    public static int constrainToRange(int n2, int n3, int n4) {
        Preconditions.checkArgument(n3 <= n4, "min (%s) must be less than or equal to max (%s)", n3, n4);
        return Math.min(Math.max(n2, n3), n4);
    }

    public static int[] concat(int[] ... nArray) {
        int n2 = 0;
        for (int[] nArray2 : nArray) {
            n2 += nArray2.length;
        }
        int[] nArray3 = new int[n2];
        int n3 = 0;
        for (int[] nArray4 : nArray) {
            System.arraycopy(nArray4, 0, nArray3, n3, nArray4.length);
            n3 += nArray4.length;
        }
        return nArray3;
    }

    public static byte[] toByteArray(int n2) {
        return new byte[]{(byte)(n2 >> 24), (byte)(n2 >> 16), (byte)(n2 >> 8), (byte)n2};
    }

    public static int fromByteArray(byte[] byArray) {
        Preconditions.checkArgument(byArray.length >= 4, "array too small: %s < %s", byArray.length, 4);
        return Ints.fromBytes(byArray[0], byArray[1], byArray[2], byArray[3]);
    }

    public static int fromBytes(byte by2, byte by3, byte by4, byte by5) {
        return by2 << 24 | (by3 & 0xFF) << 16 | (by4 & 0xFF) << 8 | by5 & 0xFF;
    }

    @Beta
    public static Converter<String, Integer> stringConverter() {
        return IntConverter.INSTANCE;
    }

    public static int[] ensureCapacity(int[] nArray, int n2, int n3) {
        Preconditions.checkArgument(n2 >= 0, "Invalid minLength: %s", n2);
        Preconditions.checkArgument(n3 >= 0, "Invalid padding: %s", n3);
        return nArray.length < n2 ? Arrays.copyOf(nArray, n2 + n3) : nArray;
    }

    public static String join(String string, int ... nArray) {
        Preconditions.checkNotNull(string);
        if (nArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(nArray.length * 5);
        stringBuilder.append(nArray[0]);
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            stringBuilder.append(string).append(nArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static Comparator<int[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sortDescending(int[] nArray) {
        Preconditions.checkNotNull(nArray);
        Ints.sortDescending(nArray, 0, nArray.length);
    }

    public static void sortDescending(int[] nArray, int n2, int n3) {
        Preconditions.checkNotNull(nArray);
        Preconditions.checkPositionIndexes(n2, n3, nArray.length);
        Arrays.sort(nArray, n2, n3);
        Ints.reverse(nArray, n2, n3);
    }

    public static void reverse(int[] nArray) {
        Preconditions.checkNotNull(nArray);
        Ints.reverse(nArray, 0, nArray.length);
    }

    public static void reverse(int[] nArray, int n2, int n3) {
        Preconditions.checkNotNull(nArray);
        Preconditions.checkPositionIndexes(n2, n3, nArray.length);
        int n4 = n2;
        for (int i2 = n3 - 1; n4 < i2; ++n4, --i2) {
            int n5 = nArray[n4];
            nArray[n4] = nArray[i2];
            nArray[i2] = n5;
        }
    }

    public static int[] toArray(Collection<? extends Number> collection) {
        if (collection instanceof IntArrayAsList) {
            return ((IntArrayAsList)collection).toIntArray();
        }
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = ((Number)Preconditions.checkNotNull(objectArray[i2])).intValue();
        }
        return nArray;
    }

    public static List<Integer> asList(int ... nArray) {
        if (nArray.length == 0) {
            return Collections.emptyList();
        }
        return new IntArrayAsList(nArray);
    }

    @Beta
    public static @Nullable Integer tryParse(String string) {
        return Ints.tryParse(string, 10);
    }

    @Beta
    public static @Nullable Integer tryParse(String string, int n2) {
        Long l2 = Longs.tryParse(string, n2);
        if (l2 == null || l2 != (long)l2.intValue()) {
            return null;
        }
        return l2.intValue();
    }

    @GwtCompatible
    private static class IntArrayAsList
    extends AbstractList<Integer>
    implements Serializable,
    RandomAccess {
        final int[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        IntArrayAsList(int[] nArray) {
            this(nArray, 0, nArray.length);
        }

        IntArrayAsList(int[] nArray, int n2, int n3) {
            this.array = nArray;
            this.start = n2;
            this.end = n3;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Integer get(int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            return this.array[this.start + n2];
        }

        public Spliterator.OfInt spliterator() {
            return Spliterators.spliterator(this.array, this.start, this.end, 0);
        }

        @Override
        public boolean contains(Object object) {
            return object instanceof Integer && Ints.indexOf(this.array, (Integer)object, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object object) {
            int n2;
            if (object instanceof Integer && (n2 = Ints.indexOf(this.array, (Integer)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            int n2;
            if (object instanceof Integer && (n2 = Ints.lastIndexOf(this.array, (Integer)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public Integer set(int n2, Integer n3) {
            Preconditions.checkElementIndex(n2, this.size());
            int n4 = this.array[this.start + n2];
            this.array[this.start + n2] = Preconditions.checkNotNull(n3);
            return n4;
        }

        @Override
        public List<Integer> subList(int n2, int n3) {
            int n4 = this.size();
            Preconditions.checkPositionIndexes(n2, n3, n4);
            if (n2 == n3) {
                return Collections.emptyList();
            }
            return new IntArrayAsList(this.array, this.start + n2, this.start + n3);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof IntArrayAsList) {
                IntArrayAsList intArrayAsList = (IntArrayAsList)object;
                int n2 = this.size();
                if (intArrayAsList.size() != n2) {
                    return false;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.array[this.start + i2] == intArrayAsList.array[intArrayAsList.start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int n2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                n2 = 31 * n2 + Ints.hashCode(this.array[i2]);
            }
            return n2;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.size() * 5);
            stringBuilder.append('[').append(this.array[this.start]);
            for (int i2 = this.start + 1; i2 < this.end; ++i2) {
                stringBuilder.append(", ").append(this.array[i2]);
            }
            return stringBuilder.append(']').toString();
        }

        int[] toIntArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }
    }

    private static enum LexicographicalComparator implements Comparator<int[]>
    {
        INSTANCE;


        @Override
        public int compare(int[] nArray, int[] nArray2) {
            int n2 = Math.min(nArray.length, nArray2.length);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = Ints.compare(nArray[i2], nArray2[i2]);
                if (n3 == 0) continue;
                return n3;
            }
            return nArray.length - nArray2.length;
        }

        public String toString() {
            return "Ints.lexicographicalComparator()";
        }
    }

    private static final class IntConverter
    extends Converter<String, Integer>
    implements Serializable {
        static final IntConverter INSTANCE = new IntConverter();
        private static final long serialVersionUID = 1L;

        private IntConverter() {
        }

        @Override
        protected Integer doForward(String string) {
            return Integer.decode(string);
        }

        @Override
        protected String doBackward(Integer n2) {
            return n2.toString();
        }

        public String toString() {
            return "Ints.stringConverter()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

