/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.LongConsumer;
import java.util.stream.LongStream;
import org.checkerframework.checker.nullness.qual.Nullable;

@Immutable
@Beta
@GwtCompatible
public final class ImmutableLongArray
implements Serializable {
    private static final ImmutableLongArray EMPTY = new ImmutableLongArray(new long[0]);
    private final long[] array;
    private final transient int start;
    private final int end;

    public static ImmutableLongArray of() {
        return EMPTY;
    }

    public static ImmutableLongArray of(long l2) {
        return new ImmutableLongArray(new long[]{l2});
    }

    public static ImmutableLongArray of(long l2, long l3) {
        return new ImmutableLongArray(new long[]{l2, l3});
    }

    public static ImmutableLongArray of(long l2, long l3, long l4) {
        return new ImmutableLongArray(new long[]{l2, l3, l4});
    }

    public static ImmutableLongArray of(long l2, long l3, long l4, long l5) {
        return new ImmutableLongArray(new long[]{l2, l3, l4, l5});
    }

    public static ImmutableLongArray of(long l2, long l3, long l4, long l5, long l6) {
        return new ImmutableLongArray(new long[]{l2, l3, l4, l5, l6});
    }

    public static ImmutableLongArray of(long l2, long l3, long l4, long l5, long l6, long l7) {
        return new ImmutableLongArray(new long[]{l2, l3, l4, l5, l6, l7});
    }

    public static ImmutableLongArray of(long l2, long ... lArray) {
        Preconditions.checkArgument(lArray.length <= 0x7FFFFFFE, "the total number of elements must fit in an int");
        long[] lArray2 = new long[lArray.length + 1];
        lArray2[0] = l2;
        System.arraycopy(lArray, 0, lArray2, 1, lArray.length);
        return new ImmutableLongArray(lArray2);
    }

    public static ImmutableLongArray copyOf(long[] lArray) {
        return lArray.length == 0 ? EMPTY : new ImmutableLongArray(Arrays.copyOf(lArray, lArray.length));
    }

    public static ImmutableLongArray copyOf(Collection<Long> collection) {
        return collection.isEmpty() ? EMPTY : new ImmutableLongArray(Longs.toArray(collection));
    }

    public static ImmutableLongArray copyOf(Iterable<Long> iterable) {
        if (iterable instanceof Collection) {
            return ImmutableLongArray.copyOf((Collection)iterable);
        }
        return ImmutableLongArray.builder().addAll(iterable).build();
    }

    public static ImmutableLongArray copyOf(LongStream longStream) {
        long[] lArray = longStream.toArray();
        return lArray.length == 0 ? EMPTY : new ImmutableLongArray(lArray);
    }

    public static Builder builder(int n2) {
        Preconditions.checkArgument(n2 >= 0, "Invalid initialCapacity: %s", n2);
        return new Builder(n2);
    }

    public static Builder builder() {
        return new Builder(10);
    }

    private ImmutableLongArray(long[] lArray) {
        this(lArray, 0, lArray.length);
    }

    private ImmutableLongArray(long[] lArray, int n2, int n3) {
        this.array = lArray;
        this.start = n2;
        this.end = n3;
    }

    public int length() {
        return this.end - this.start;
    }

    public boolean isEmpty() {
        return this.end == this.start;
    }

    public long get(int n2) {
        Preconditions.checkElementIndex(n2, this.length());
        return this.array[this.start + n2];
    }

    public int indexOf(long l2) {
        for (int i2 = this.start; i2 < this.end; ++i2) {
            if (this.array[i2] != l2) continue;
            return i2 - this.start;
        }
        return -1;
    }

    public int lastIndexOf(long l2) {
        for (int i2 = this.end - 1; i2 >= this.start; --i2) {
            if (this.array[i2] != l2) continue;
            return i2 - this.start;
        }
        return -1;
    }

    public boolean contains(long l2) {
        return this.indexOf(l2) >= 0;
    }

    public void forEach(LongConsumer longConsumer) {
        Preconditions.checkNotNull(longConsumer);
        for (int i2 = this.start; i2 < this.end; ++i2) {
            longConsumer.accept(this.array[i2]);
        }
    }

    public LongStream stream() {
        return Arrays.stream(this.array, this.start, this.end);
    }

    public long[] toArray() {
        return Arrays.copyOfRange(this.array, this.start, this.end);
    }

    public ImmutableLongArray subArray(int n2, int n3) {
        Preconditions.checkPositionIndexes(n2, n3, this.length());
        return n2 == n3 ? EMPTY : new ImmutableLongArray(this.array, this.start + n2, this.start + n3);
    }

    private Spliterator.OfLong spliterator() {
        return Spliterators.spliterator(this.array, this.start, this.end, 1040);
    }

    public List<Long> asList() {
        return new AsList(this);
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ImmutableLongArray)) {
            return false;
        }
        ImmutableLongArray immutableLongArray = (ImmutableLongArray)object;
        if (this.length() != immutableLongArray.length()) {
            return false;
        }
        for (int i2 = 0; i2 < this.length(); ++i2) {
            if (this.get(i2) == immutableLongArray.get(i2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 1;
        for (int i2 = this.start; i2 < this.end; ++i2) {
            n2 *= 31;
            n2 += Longs.hashCode(this.array[i2]);
        }
        return n2;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(this.length() * 5);
        stringBuilder.append('[').append(this.array[this.start]);
        for (int i2 = this.start + 1; i2 < this.end; ++i2) {
            stringBuilder.append(", ").append(this.array[i2]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public ImmutableLongArray trimmed() {
        return this.isPartialView() ? new ImmutableLongArray(this.toArray()) : this;
    }

    private boolean isPartialView() {
        return this.start > 0 || this.end < this.array.length;
    }

    Object writeReplace() {
        return this.trimmed();
    }

    Object readResolve() {
        return this.isEmpty() ? EMPTY : this;
    }

    static class AsList
    extends AbstractList<Long>
    implements Serializable,
    RandomAccess {
        private final ImmutableLongArray parent;

        private AsList(ImmutableLongArray immutableLongArray) {
            this.parent = immutableLongArray;
        }

        @Override
        public int size() {
            return this.parent.length();
        }

        @Override
        public Long get(int n2) {
            return this.parent.get(n2);
        }

        @Override
        public boolean contains(Object object) {
            return this.indexOf(object) >= 0;
        }

        @Override
        public int indexOf(Object object) {
            return object instanceof Long ? this.parent.indexOf((Long)object) : -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            return object instanceof Long ? this.parent.lastIndexOf((Long)object) : -1;
        }

        @Override
        public List<Long> subList(int n2, int n3) {
            return this.parent.subArray(n2, n3).asList();
        }

        @Override
        public Spliterator<Long> spliterator() {
            return this.parent.spliterator();
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof AsList) {
                AsList asList = (AsList)object;
                return this.parent.equals(asList.parent);
            }
            if (!(object instanceof List)) {
                return false;
            }
            List list = (List)object;
            if (this.size() != list.size()) {
                return false;
            }
            int n2 = this.parent.start;
            for (Object e2 : list) {
                if (e2 instanceof Long && this.parent.array[n2++] == (Long)e2) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return this.parent.hashCode();
        }

        @Override
        public String toString() {
            return this.parent.toString();
        }
    }

    @CanIgnoreReturnValue
    public static final class Builder {
        private long[] array;
        private int count = 0;

        Builder(int n2) {
            this.array = new long[n2];
        }

        public Builder add(long l2) {
            this.ensureRoomFor(1);
            this.array[this.count] = l2;
            ++this.count;
            return this;
        }

        public Builder addAll(long[] lArray) {
            this.ensureRoomFor(lArray.length);
            System.arraycopy(lArray, 0, this.array, this.count, lArray.length);
            this.count += lArray.length;
            return this;
        }

        public Builder addAll(Iterable<Long> iterable) {
            if (iterable instanceof Collection) {
                return this.addAll((Collection)iterable);
            }
            for (Long l2 : iterable) {
                this.add(l2);
            }
            return this;
        }

        public Builder addAll(Collection<Long> collection) {
            this.ensureRoomFor(collection.size());
            for (Long l2 : collection) {
                this.array[this.count++] = l2;
            }
            return this;
        }

        public Builder addAll(LongStream longStream) {
            Spliterator.OfLong ofLong = longStream.spliterator();
            long l2 = ofLong.getExactSizeIfKnown();
            if (l2 > 0L) {
                this.ensureRoomFor(Ints.saturatedCast(l2));
            }
            ofLong.forEachRemaining(this::add);
            return this;
        }

        public Builder addAll(ImmutableLongArray immutableLongArray) {
            this.ensureRoomFor(immutableLongArray.length());
            System.arraycopy(immutableLongArray.array, immutableLongArray.start, this.array, this.count, immutableLongArray.length());
            this.count += immutableLongArray.length();
            return this;
        }

        private void ensureRoomFor(int n2) {
            int n3 = this.count + n2;
            if (n3 > this.array.length) {
                long[] lArray = new long[Builder.expandedCapacity(this.array.length, n3)];
                System.arraycopy(this.array, 0, lArray, 0, this.count);
                this.array = lArray;
            }
        }

        private static int expandedCapacity(int n2, int n3) {
            if (n3 < 0) {
                throw new AssertionError((Object)"cannot store more than MAX_VALUE elements");
            }
            int n4 = n2 + (n2 >> 1) + 1;
            if (n4 < n3) {
                n4 = Integer.highestOneBit(n3 - 1) << 1;
            }
            if (n4 < 0) {
                n4 = Integer.MAX_VALUE;
            }
            return n4;
        }

        @CheckReturnValue
        public ImmutableLongArray build() {
            return this.count == 0 ? EMPTY : new ImmutableLongArray(this.array, 0, this.count);
        }
    }
}

