/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import org.checkerframework.checker.nullness.qual.Nullable;

@Immutable
@Beta
@GwtCompatible
public final class ImmutableIntArray
implements Serializable {
    private static final ImmutableIntArray EMPTY = new ImmutableIntArray(new int[0]);
    private final int[] array;
    private final transient int start;
    private final int end;

    public static ImmutableIntArray of() {
        return EMPTY;
    }

    public static ImmutableIntArray of(int n2) {
        return new ImmutableIntArray(new int[]{n2});
    }

    public static ImmutableIntArray of(int n2, int n3) {
        return new ImmutableIntArray(new int[]{n2, n3});
    }

    public static ImmutableIntArray of(int n2, int n3, int n4) {
        return new ImmutableIntArray(new int[]{n2, n3, n4});
    }

    public static ImmutableIntArray of(int n2, int n3, int n4, int n5) {
        return new ImmutableIntArray(new int[]{n2, n3, n4, n5});
    }

    public static ImmutableIntArray of(int n2, int n3, int n4, int n5, int n6) {
        return new ImmutableIntArray(new int[]{n2, n3, n4, n5, n6});
    }

    public static ImmutableIntArray of(int n2, int n3, int n4, int n5, int n6, int n7) {
        return new ImmutableIntArray(new int[]{n2, n3, n4, n5, n6, n7});
    }

    public static ImmutableIntArray of(int n2, int ... nArray) {
        Preconditions.checkArgument(nArray.length <= 0x7FFFFFFE, "the total number of elements must fit in an int");
        int[] nArray2 = new int[nArray.length + 1];
        nArray2[0] = n2;
        System.arraycopy(nArray, 0, nArray2, 1, nArray.length);
        return new ImmutableIntArray(nArray2);
    }

    public static ImmutableIntArray copyOf(int[] nArray) {
        return nArray.length == 0 ? EMPTY : new ImmutableIntArray(Arrays.copyOf(nArray, nArray.length));
    }

    public static ImmutableIntArray copyOf(Collection<Integer> collection) {
        return collection.isEmpty() ? EMPTY : new ImmutableIntArray(Ints.toArray(collection));
    }

    public static ImmutableIntArray copyOf(Iterable<Integer> iterable) {
        if (iterable instanceof Collection) {
            return ImmutableIntArray.copyOf((Collection)iterable);
        }
        return ImmutableIntArray.builder().addAll(iterable).build();
    }

    public static ImmutableIntArray copyOf(IntStream intStream) {
        int[] nArray = intStream.toArray();
        return nArray.length == 0 ? EMPTY : new ImmutableIntArray(nArray);
    }

    public static Builder builder(int n2) {
        Preconditions.checkArgument(n2 >= 0, "Invalid initialCapacity: %s", n2);
        return new Builder(n2);
    }

    public static Builder builder() {
        return new Builder(10);
    }

    private ImmutableIntArray(int[] nArray) {
        this(nArray, 0, nArray.length);
    }

    private ImmutableIntArray(int[] nArray, int n2, int n3) {
        this.array = nArray;
        this.start = n2;
        this.end = n3;
    }

    public int length() {
        return this.end - this.start;
    }

    public boolean isEmpty() {
        return this.end == this.start;
    }

    public int get(int n2) {
        Preconditions.checkElementIndex(n2, this.length());
        return this.array[this.start + n2];
    }

    public int indexOf(int n2) {
        for (int i2 = this.start; i2 < this.end; ++i2) {
            if (this.array[i2] != n2) continue;
            return i2 - this.start;
        }
        return -1;
    }

    public int lastIndexOf(int n2) {
        for (int i2 = this.end - 1; i2 >= this.start; --i2) {
            if (this.array[i2] != n2) continue;
            return i2 - this.start;
        }
        return -1;
    }

    public boolean contains(int n2) {
        return this.indexOf(n2) >= 0;
    }

    public void forEach(IntConsumer intConsumer) {
        Preconditions.checkNotNull(intConsumer);
        for (int i2 = this.start; i2 < this.end; ++i2) {
            intConsumer.accept(this.array[i2]);
        }
    }

    public IntStream stream() {
        return Arrays.stream(this.array, this.start, this.end);
    }

    public int[] toArray() {
        return Arrays.copyOfRange(this.array, this.start, this.end);
    }

    public ImmutableIntArray subArray(int n2, int n3) {
        Preconditions.checkPositionIndexes(n2, n3, this.length());
        return n2 == n3 ? EMPTY : new ImmutableIntArray(this.array, this.start + n2, this.start + n3);
    }

    private Spliterator.OfInt spliterator() {
        return Spliterators.spliterator(this.array, this.start, this.end, 1040);
    }

    public List<Integer> asList() {
        return new AsList(this);
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ImmutableIntArray)) {
            return false;
        }
        ImmutableIntArray immutableIntArray = (ImmutableIntArray)object;
        if (this.length() != immutableIntArray.length()) {
            return false;
        }
        for (int i2 = 0; i2 < this.length(); ++i2) {
            if (this.get(i2) == immutableIntArray.get(i2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 1;
        for (int i2 = this.start; i2 < this.end; ++i2) {
            n2 *= 31;
            n2 += Ints.hashCode(this.array[i2]);
        }
        return n2;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(this.length() * 5);
        stringBuilder.append('[').append(this.array[this.start]);
        for (int i2 = this.start + 1; i2 < this.end; ++i2) {
            stringBuilder.append(", ").append(this.array[i2]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public ImmutableIntArray trimmed() {
        return this.isPartialView() ? new ImmutableIntArray(this.toArray()) : this;
    }

    private boolean isPartialView() {
        return this.start > 0 || this.end < this.array.length;
    }

    Object writeReplace() {
        return this.trimmed();
    }

    Object readResolve() {
        return this.isEmpty() ? EMPTY : this;
    }

    static class AsList
    extends AbstractList<Integer>
    implements Serializable,
    RandomAccess {
        private final ImmutableIntArray parent;

        private AsList(ImmutableIntArray immutableIntArray) {
            this.parent = immutableIntArray;
        }

        @Override
        public int size() {
            return this.parent.length();
        }

        @Override
        public Integer get(int n2) {
            return this.parent.get(n2);
        }

        @Override
        public boolean contains(Object object) {
            return this.indexOf(object) >= 0;
        }

        @Override
        public int indexOf(Object object) {
            return object instanceof Integer ? this.parent.indexOf((Integer)object) : -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            return object instanceof Integer ? this.parent.lastIndexOf((Integer)object) : -1;
        }

        @Override
        public List<Integer> subList(int n2, int n3) {
            return this.parent.subArray(n2, n3).asList();
        }

        @Override
        public Spliterator<Integer> spliterator() {
            return this.parent.spliterator();
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof AsList) {
                AsList asList = (AsList)object;
                return this.parent.equals(asList.parent);
            }
            if (!(object instanceof List)) {
                return false;
            }
            List list = (List)object;
            if (this.size() != list.size()) {
                return false;
            }
            int n2 = this.parent.start;
            for (Object e2 : list) {
                if (e2 instanceof Integer && this.parent.array[n2++] == (Integer)e2) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return this.parent.hashCode();
        }

        @Override
        public String toString() {
            return this.parent.toString();
        }
    }

    @CanIgnoreReturnValue
    public static final class Builder {
        private int[] array;
        private int count = 0;

        Builder(int n2) {
            this.array = new int[n2];
        }

        public Builder add(int n2) {
            this.ensureRoomFor(1);
            this.array[this.count] = n2;
            ++this.count;
            return this;
        }

        public Builder addAll(int[] nArray) {
            this.ensureRoomFor(nArray.length);
            System.arraycopy(nArray, 0, this.array, this.count, nArray.length);
            this.count += nArray.length;
            return this;
        }

        public Builder addAll(Iterable<Integer> iterable) {
            if (iterable instanceof Collection) {
                return this.addAll((Collection)iterable);
            }
            for (Integer n2 : iterable) {
                this.add(n2);
            }
            return this;
        }

        public Builder addAll(Collection<Integer> collection) {
            this.ensureRoomFor(collection.size());
            for (Integer n2 : collection) {
                this.array[this.count++] = n2;
            }
            return this;
        }

        public Builder addAll(IntStream intStream) {
            Spliterator.OfInt ofInt = intStream.spliterator();
            long l2 = ofInt.getExactSizeIfKnown();
            if (l2 > 0L) {
                this.ensureRoomFor(Ints.saturatedCast(l2));
            }
            ofInt.forEachRemaining(this::add);
            return this;
        }

        public Builder addAll(ImmutableIntArray immutableIntArray) {
            this.ensureRoomFor(immutableIntArray.length());
            System.arraycopy(immutableIntArray.array, immutableIntArray.start, this.array, this.count, immutableIntArray.length());
            this.count += immutableIntArray.length();
            return this;
        }

        private void ensureRoomFor(int n2) {
            int n3 = this.count + n2;
            if (n3 > this.array.length) {
                int[] nArray = new int[Builder.expandedCapacity(this.array.length, n3)];
                System.arraycopy(this.array, 0, nArray, 0, this.count);
                this.array = nArray;
            }
        }

        private static int expandedCapacity(int n2, int n3) {
            if (n3 < 0) {
                throw new AssertionError((Object)"cannot store more than MAX_VALUE elements");
            }
            int n4 = n2 + (n2 >> 1) + 1;
            if (n4 < n3) {
                n4 = Integer.highestOneBit(n3 - 1) << 1;
            }
            if (n4 < 0) {
                n4 = Integer.MAX_VALUE;
            }
            return n4;
        }

        @CheckReturnValue
        public ImmutableIntArray build() {
            return this.count == 0 ? EMPTY : new ImmutableIntArray(this.array, 0, this.count);
        }
    }
}

