/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.DoubleConsumer;
import java.util.stream.DoubleStream;
import org.checkerframework.checker.nullness.qual.Nullable;

@Immutable
@Beta
@GwtCompatible
public final class ImmutableDoubleArray
implements Serializable {
    private static final ImmutableDoubleArray EMPTY = new ImmutableDoubleArray(new double[0]);
    private final double[] array;
    private final transient int start;
    private final int end;

    public static ImmutableDoubleArray of() {
        return EMPTY;
    }

    public static ImmutableDoubleArray of(double d2) {
        return new ImmutableDoubleArray(new double[]{d2});
    }

    public static ImmutableDoubleArray of(double d2, double d3) {
        return new ImmutableDoubleArray(new double[]{d2, d3});
    }

    public static ImmutableDoubleArray of(double d2, double d3, double d4) {
        return new ImmutableDoubleArray(new double[]{d2, d3, d4});
    }

    public static ImmutableDoubleArray of(double d2, double d3, double d4, double d5) {
        return new ImmutableDoubleArray(new double[]{d2, d3, d4, d5});
    }

    public static ImmutableDoubleArray of(double d2, double d3, double d4, double d5, double d6) {
        return new ImmutableDoubleArray(new double[]{d2, d3, d4, d5, d6});
    }

    public static ImmutableDoubleArray of(double d2, double d3, double d4, double d5, double d6, double d7) {
        return new ImmutableDoubleArray(new double[]{d2, d3, d4, d5, d6, d7});
    }

    public static ImmutableDoubleArray of(double d2, double ... dArray) {
        Preconditions.checkArgument(dArray.length <= 0x7FFFFFFE, "the total number of elements must fit in an int");
        double[] dArray2 = new double[dArray.length + 1];
        dArray2[0] = d2;
        System.arraycopy(dArray, 0, dArray2, 1, dArray.length);
        return new ImmutableDoubleArray(dArray2);
    }

    public static ImmutableDoubleArray copyOf(double[] dArray) {
        return dArray.length == 0 ? EMPTY : new ImmutableDoubleArray(Arrays.copyOf(dArray, dArray.length));
    }

    public static ImmutableDoubleArray copyOf(Collection<Double> collection) {
        return collection.isEmpty() ? EMPTY : new ImmutableDoubleArray(Doubles.toArray(collection));
    }

    public static ImmutableDoubleArray copyOf(Iterable<Double> iterable) {
        if (iterable instanceof Collection) {
            return ImmutableDoubleArray.copyOf((Collection)iterable);
        }
        return ImmutableDoubleArray.builder().addAll(iterable).build();
    }

    public static ImmutableDoubleArray copyOf(DoubleStream doubleStream) {
        double[] dArray = doubleStream.toArray();
        return dArray.length == 0 ? EMPTY : new ImmutableDoubleArray(dArray);
    }

    public static Builder builder(int n2) {
        Preconditions.checkArgument(n2 >= 0, "Invalid initialCapacity: %s", n2);
        return new Builder(n2);
    }

    public static Builder builder() {
        return new Builder(10);
    }

    private ImmutableDoubleArray(double[] dArray) {
        this(dArray, 0, dArray.length);
    }

    private ImmutableDoubleArray(double[] dArray, int n2, int n3) {
        this.array = dArray;
        this.start = n2;
        this.end = n3;
    }

    public int length() {
        return this.end - this.start;
    }

    public boolean isEmpty() {
        return this.end == this.start;
    }

    public double get(int n2) {
        Preconditions.checkElementIndex(n2, this.length());
        return this.array[this.start + n2];
    }

    public int indexOf(double d2) {
        for (int i2 = this.start; i2 < this.end; ++i2) {
            if (!ImmutableDoubleArray.areEqual(this.array[i2], d2)) continue;
            return i2 - this.start;
        }
        return -1;
    }

    public int lastIndexOf(double d2) {
        for (int i2 = this.end - 1; i2 >= this.start; --i2) {
            if (!ImmutableDoubleArray.areEqual(this.array[i2], d2)) continue;
            return i2 - this.start;
        }
        return -1;
    }

    public boolean contains(double d2) {
        return this.indexOf(d2) >= 0;
    }

    public void forEach(DoubleConsumer doubleConsumer) {
        Preconditions.checkNotNull(doubleConsumer);
        for (int i2 = this.start; i2 < this.end; ++i2) {
            doubleConsumer.accept(this.array[i2]);
        }
    }

    public DoubleStream stream() {
        return Arrays.stream(this.array, this.start, this.end);
    }

    public double[] toArray() {
        return Arrays.copyOfRange(this.array, this.start, this.end);
    }

    public ImmutableDoubleArray subArray(int n2, int n3) {
        Preconditions.checkPositionIndexes(n2, n3, this.length());
        return n2 == n3 ? EMPTY : new ImmutableDoubleArray(this.array, this.start + n2, this.start + n3);
    }

    private Spliterator.OfDouble spliterator() {
        return Spliterators.spliterator(this.array, this.start, this.end, 1040);
    }

    public List<Double> asList() {
        return new AsList(this);
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ImmutableDoubleArray)) {
            return false;
        }
        ImmutableDoubleArray immutableDoubleArray = (ImmutableDoubleArray)object;
        if (this.length() != immutableDoubleArray.length()) {
            return false;
        }
        for (int i2 = 0; i2 < this.length(); ++i2) {
            if (ImmutableDoubleArray.areEqual(this.get(i2), immutableDoubleArray.get(i2))) continue;
            return false;
        }
        return true;
    }

    private static boolean areEqual(double d2, double d3) {
        return Double.doubleToLongBits(d2) == Double.doubleToLongBits(d3);
    }

    public int hashCode() {
        int n2 = 1;
        for (int i2 = this.start; i2 < this.end; ++i2) {
            n2 *= 31;
            n2 += Doubles.hashCode(this.array[i2]);
        }
        return n2;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(this.length() * 5);
        stringBuilder.append('[').append(this.array[this.start]);
        for (int i2 = this.start + 1; i2 < this.end; ++i2) {
            stringBuilder.append(", ").append(this.array[i2]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public ImmutableDoubleArray trimmed() {
        return this.isPartialView() ? new ImmutableDoubleArray(this.toArray()) : this;
    }

    private boolean isPartialView() {
        return this.start > 0 || this.end < this.array.length;
    }

    Object writeReplace() {
        return this.trimmed();
    }

    Object readResolve() {
        return this.isEmpty() ? EMPTY : this;
    }

    static class AsList
    extends AbstractList<Double>
    implements Serializable,
    RandomAccess {
        private final ImmutableDoubleArray parent;

        private AsList(ImmutableDoubleArray immutableDoubleArray) {
            this.parent = immutableDoubleArray;
        }

        @Override
        public int size() {
            return this.parent.length();
        }

        @Override
        public Double get(int n2) {
            return this.parent.get(n2);
        }

        @Override
        public boolean contains(Object object) {
            return this.indexOf(object) >= 0;
        }

        @Override
        public int indexOf(Object object) {
            return object instanceof Double ? this.parent.indexOf((Double)object) : -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            return object instanceof Double ? this.parent.lastIndexOf((Double)object) : -1;
        }

        @Override
        public List<Double> subList(int n2, int n3) {
            return this.parent.subArray(n2, n3).asList();
        }

        @Override
        public Spliterator<Double> spliterator() {
            return this.parent.spliterator();
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof AsList) {
                AsList asList = (AsList)object;
                return this.parent.equals(asList.parent);
            }
            if (!(object instanceof List)) {
                return false;
            }
            List list = (List)object;
            if (this.size() != list.size()) {
                return false;
            }
            int n2 = this.parent.start;
            for (Object e2 : list) {
                if (e2 instanceof Double && ImmutableDoubleArray.areEqual(this.parent.array[n2++], (Double)e2)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return this.parent.hashCode();
        }

        @Override
        public String toString() {
            return this.parent.toString();
        }
    }

    @CanIgnoreReturnValue
    public static final class Builder {
        private double[] array;
        private int count = 0;

        Builder(int n2) {
            this.array = new double[n2];
        }

        public Builder add(double d2) {
            this.ensureRoomFor(1);
            this.array[this.count] = d2;
            ++this.count;
            return this;
        }

        public Builder addAll(double[] dArray) {
            this.ensureRoomFor(dArray.length);
            System.arraycopy(dArray, 0, this.array, this.count, dArray.length);
            this.count += dArray.length;
            return this;
        }

        public Builder addAll(Iterable<Double> iterable) {
            if (iterable instanceof Collection) {
                return this.addAll((Collection)iterable);
            }
            for (Double d2 : iterable) {
                this.add(d2);
            }
            return this;
        }

        public Builder addAll(Collection<Double> collection) {
            this.ensureRoomFor(collection.size());
            for (Double d2 : collection) {
                this.array[this.count++] = d2;
            }
            return this;
        }

        public Builder addAll(DoubleStream doubleStream) {
            Spliterator.OfDouble ofDouble = doubleStream.spliterator();
            long l2 = ofDouble.getExactSizeIfKnown();
            if (l2 > 0L) {
                this.ensureRoomFor(Ints.saturatedCast(l2));
            }
            ofDouble.forEachRemaining(this::add);
            return this;
        }

        public Builder addAll(ImmutableDoubleArray immutableDoubleArray) {
            this.ensureRoomFor(immutableDoubleArray.length());
            System.arraycopy(immutableDoubleArray.array, immutableDoubleArray.start, this.array, this.count, immutableDoubleArray.length());
            this.count += immutableDoubleArray.length();
            return this;
        }

        private void ensureRoomFor(int n2) {
            int n3 = this.count + n2;
            if (n3 > this.array.length) {
                double[] dArray = new double[Builder.expandedCapacity(this.array.length, n3)];
                System.arraycopy(this.array, 0, dArray, 0, this.count);
                this.array = dArray;
            }
        }

        private static int expandedCapacity(int n2, int n3) {
            if (n3 < 0) {
                throw new AssertionError((Object)"cannot store more than MAX_VALUE elements");
            }
            int n4 = n2 + (n2 >> 1) + 1;
            if (n4 < n3) {
                n4 = Integer.highestOneBit(n3 - 1) << 1;
            }
            if (n4 < 0) {
                n4 = Integer.MAX_VALUE;
            }
            return n4;
        }

        @CheckReturnValue
        public ImmutableDoubleArray build() {
            return this.count == 0 ? EMPTY : new ImmutableDoubleArray(this.array, 0, this.count);
        }
    }
}

