/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(emulated=true)
public final class Floats {
    public static final int BYTES = 4;

    private Floats() {
    }

    public static int hashCode(float f2) {
        return Float.valueOf(f2).hashCode();
    }

    public static int compare(float f2, float f3) {
        return Float.compare(f2, f3);
    }

    public static boolean isFinite(float f2) {
        return Float.NEGATIVE_INFINITY < f2 && f2 < Float.POSITIVE_INFINITY;
    }

    public static boolean contains(float[] fArray, float f2) {
        for (float f3 : fArray) {
            if (f3 != f2) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(float[] fArray, float f2) {
        return Floats.indexOf(fArray, f2, 0, fArray.length);
    }

    private static int indexOf(float[] fArray, float f2, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            if (fArray[i2] != f2) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(float[] fArray, float[] fArray2) {
        Preconditions.checkNotNull(fArray, "array");
        Preconditions.checkNotNull(fArray2, "target");
        if (fArray2.length == 0) {
            return 0;
        }
        block0: for (int i2 = 0; i2 < fArray.length - fArray2.length + 1; ++i2) {
            for (int i3 = 0; i3 < fArray2.length; ++i3) {
                if (fArray[i2 + i3] != fArray2[i3]) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(float[] fArray, float f2) {
        return Floats.lastIndexOf(fArray, f2, 0, fArray.length);
    }

    private static int lastIndexOf(float[] fArray, float f2, int n2, int n3) {
        for (int i2 = n3 - 1; i2 >= n2; --i2) {
            if (fArray[i2] != f2) continue;
            return i2;
        }
        return -1;
    }

    public static float min(float ... fArray) {
        Preconditions.checkArgument(fArray.length > 0);
        float f2 = fArray[0];
        for (int i2 = 1; i2 < fArray.length; ++i2) {
            f2 = Math.min(f2, fArray[i2]);
        }
        return f2;
    }

    public static float max(float ... fArray) {
        Preconditions.checkArgument(fArray.length > 0);
        float f2 = fArray[0];
        for (int i2 = 1; i2 < fArray.length; ++i2) {
            f2 = Math.max(f2, fArray[i2]);
        }
        return f2;
    }

    @Beta
    public static float constrainToRange(float f2, float f3, float f4) {
        Preconditions.checkArgument(f3 <= f4, "min (%s) must be less than or equal to max (%s)", (Object)Float.valueOf(f3), (Object)Float.valueOf(f4));
        return Math.min(Math.max(f2, f3), f4);
    }

    public static float[] concat(float[] ... fArray) {
        int n2 = 0;
        for (float[] fArray2 : fArray) {
            n2 += fArray2.length;
        }
        float[] fArray3 = new float[n2];
        int n3 = 0;
        for (float[] fArray4 : fArray) {
            System.arraycopy(fArray4, 0, fArray3, n3, fArray4.length);
            n3 += fArray4.length;
        }
        return fArray3;
    }

    @Beta
    public static Converter<String, Float> stringConverter() {
        return FloatConverter.INSTANCE;
    }

    public static float[] ensureCapacity(float[] fArray, int n2, int n3) {
        Preconditions.checkArgument(n2 >= 0, "Invalid minLength: %s", n2);
        Preconditions.checkArgument(n3 >= 0, "Invalid padding: %s", n3);
        return fArray.length < n2 ? Arrays.copyOf(fArray, n2 + n3) : fArray;
    }

    public static String join(String string, float ... fArray) {
        Preconditions.checkNotNull(string);
        if (fArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(fArray.length * 12);
        stringBuilder.append(fArray[0]);
        for (int i2 = 1; i2 < fArray.length; ++i2) {
            stringBuilder.append(string).append(fArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static Comparator<float[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sortDescending(float[] fArray) {
        Preconditions.checkNotNull(fArray);
        Floats.sortDescending(fArray, 0, fArray.length);
    }

    public static void sortDescending(float[] fArray, int n2, int n3) {
        Preconditions.checkNotNull(fArray);
        Preconditions.checkPositionIndexes(n2, n3, fArray.length);
        Arrays.sort(fArray, n2, n3);
        Floats.reverse(fArray, n2, n3);
    }

    public static void reverse(float[] fArray) {
        Preconditions.checkNotNull(fArray);
        Floats.reverse(fArray, 0, fArray.length);
    }

    public static void reverse(float[] fArray, int n2, int n3) {
        Preconditions.checkNotNull(fArray);
        Preconditions.checkPositionIndexes(n2, n3, fArray.length);
        int n4 = n2;
        for (int i2 = n3 - 1; n4 < i2; ++n4, --i2) {
            float f2 = fArray[n4];
            fArray[n4] = fArray[i2];
            fArray[i2] = f2;
        }
    }

    public static float[] toArray(Collection<? extends Number> collection) {
        if (collection instanceof FloatArrayAsList) {
            return ((FloatArrayAsList)collection).toFloatArray();
        }
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        float[] fArray = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray[i2] = ((Number)Preconditions.checkNotNull(objectArray[i2])).floatValue();
        }
        return fArray;
    }

    public static List<Float> asList(float ... fArray) {
        if (fArray.length == 0) {
            return Collections.emptyList();
        }
        return new FloatArrayAsList(fArray);
    }

    @Beta
    @GwtIncompatible
    public static @Nullable Float tryParse(String string) {
        if (Doubles.FLOATING_POINT_PATTERN.matcher(string).matches()) {
            try {
                return Float.valueOf(Float.parseFloat(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @GwtCompatible
    private static class FloatArrayAsList
    extends AbstractList<Float>
    implements Serializable,
    RandomAccess {
        final float[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        FloatArrayAsList(float[] fArray) {
            this(fArray, 0, fArray.length);
        }

        FloatArrayAsList(float[] fArray, int n2, int n3) {
            this.array = fArray;
            this.start = n2;
            this.end = n3;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Float get(int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            return Float.valueOf(this.array[this.start + n2]);
        }

        @Override
        public boolean contains(Object object) {
            return object instanceof Float && Floats.indexOf(this.array, ((Float)object).floatValue(), this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object object) {
            int n2;
            if (object instanceof Float && (n2 = Floats.indexOf(this.array, ((Float)object).floatValue(), this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            int n2;
            if (object instanceof Float && (n2 = Floats.lastIndexOf(this.array, ((Float)object).floatValue(), this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public Float set(int n2, Float f2) {
            Preconditions.checkElementIndex(n2, this.size());
            float f3 = this.array[this.start + n2];
            this.array[this.start + n2] = Preconditions.checkNotNull(f2).floatValue();
            return Float.valueOf(f3);
        }

        @Override
        public List<Float> subList(int n2, int n3) {
            int n4 = this.size();
            Preconditions.checkPositionIndexes(n2, n3, n4);
            if (n2 == n3) {
                return Collections.emptyList();
            }
            return new FloatArrayAsList(this.array, this.start + n2, this.start + n3);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof FloatArrayAsList) {
                FloatArrayAsList floatArrayAsList = (FloatArrayAsList)object;
                int n2 = this.size();
                if (floatArrayAsList.size() != n2) {
                    return false;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.array[this.start + i2] == floatArrayAsList.array[floatArrayAsList.start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int n2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                n2 = 31 * n2 + Floats.hashCode(this.array[i2]);
            }
            return n2;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.size() * 12);
            stringBuilder.append('[').append(this.array[this.start]);
            for (int i2 = this.start + 1; i2 < this.end; ++i2) {
                stringBuilder.append(", ").append(this.array[i2]);
            }
            return stringBuilder.append(']').toString();
        }

        float[] toFloatArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }
    }

    private static enum LexicographicalComparator implements Comparator<float[]>
    {
        INSTANCE;


        @Override
        public int compare(float[] fArray, float[] fArray2) {
            int n2 = Math.min(fArray.length, fArray2.length);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = Float.compare(fArray[i2], fArray2[i2]);
                if (n3 == 0) continue;
                return n3;
            }
            return fArray.length - fArray2.length;
        }

        public String toString() {
            return "Floats.lexicographicalComparator()";
        }
    }

    private static final class FloatConverter
    extends Converter<String, Float>
    implements Serializable {
        static final FloatConverter INSTANCE = new FloatConverter();
        private static final long serialVersionUID = 1L;

        private FloatConverter() {
        }

        @Override
        protected Float doForward(String string) {
            return Float.valueOf(string);
        }

        @Override
        protected String doBackward(Float f2) {
            return f2.toString();
        }

        public String toString() {
            return "Floats.stringConverter()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

