/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(emulated=true)
public final class Doubles {
    public static final int BYTES = 8;
    @GwtIncompatible
    static final Pattern FLOATING_POINT_PATTERN = Doubles.fpPattern();

    private Doubles() {
    }

    public static int hashCode(double d2) {
        return Double.valueOf(d2).hashCode();
    }

    public static int compare(double d2, double d3) {
        return Double.compare(d2, d3);
    }

    public static boolean isFinite(double d2) {
        return Double.NEGATIVE_INFINITY < d2 && d2 < Double.POSITIVE_INFINITY;
    }

    public static boolean contains(double[] dArray, double d2) {
        for (double d3 : dArray) {
            if (d3 != d2) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(double[] dArray, double d2) {
        return Doubles.indexOf(dArray, d2, 0, dArray.length);
    }

    private static int indexOf(double[] dArray, double d2, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            if (dArray[i2] != d2) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(double[] dArray, double[] dArray2) {
        Preconditions.checkNotNull(dArray, "array");
        Preconditions.checkNotNull(dArray2, "target");
        if (dArray2.length == 0) {
            return 0;
        }
        block0: for (int i2 = 0; i2 < dArray.length - dArray2.length + 1; ++i2) {
            for (int i3 = 0; i3 < dArray2.length; ++i3) {
                if (dArray[i2 + i3] != dArray2[i3]) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(double[] dArray, double d2) {
        return Doubles.lastIndexOf(dArray, d2, 0, dArray.length);
    }

    private static int lastIndexOf(double[] dArray, double d2, int n2, int n3) {
        for (int i2 = n3 - 1; i2 >= n2; --i2) {
            if (dArray[i2] != d2) continue;
            return i2;
        }
        return -1;
    }

    public static double min(double ... dArray) {
        Preconditions.checkArgument(dArray.length > 0);
        double d2 = dArray[0];
        for (int i2 = 1; i2 < dArray.length; ++i2) {
            d2 = Math.min(d2, dArray[i2]);
        }
        return d2;
    }

    public static double max(double ... dArray) {
        Preconditions.checkArgument(dArray.length > 0);
        double d2 = dArray[0];
        for (int i2 = 1; i2 < dArray.length; ++i2) {
            d2 = Math.max(d2, dArray[i2]);
        }
        return d2;
    }

    @Beta
    public static double constrainToRange(double d2, double d3, double d4) {
        Preconditions.checkArgument(d3 <= d4, "min (%s) must be less than or equal to max (%s)", (Object)d3, (Object)d4);
        return Math.min(Math.max(d2, d3), d4);
    }

    public static double[] concat(double[] ... dArray) {
        int n2 = 0;
        for (double[] dArray2 : dArray) {
            n2 += dArray2.length;
        }
        double[] dArray3 = new double[n2];
        int n3 = 0;
        for (double[] dArray4 : dArray) {
            System.arraycopy(dArray4, 0, dArray3, n3, dArray4.length);
            n3 += dArray4.length;
        }
        return dArray3;
    }

    @Beta
    public static Converter<String, Double> stringConverter() {
        return DoubleConverter.INSTANCE;
    }

    public static double[] ensureCapacity(double[] dArray, int n2, int n3) {
        Preconditions.checkArgument(n2 >= 0, "Invalid minLength: %s", n2);
        Preconditions.checkArgument(n3 >= 0, "Invalid padding: %s", n3);
        return dArray.length < n2 ? Arrays.copyOf(dArray, n2 + n3) : dArray;
    }

    public static String join(String string, double ... dArray) {
        Preconditions.checkNotNull(string);
        if (dArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(dArray.length * 12);
        stringBuilder.append(dArray[0]);
        for (int i2 = 1; i2 < dArray.length; ++i2) {
            stringBuilder.append(string).append(dArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static Comparator<double[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sortDescending(double[] dArray) {
        Preconditions.checkNotNull(dArray);
        Doubles.sortDescending(dArray, 0, dArray.length);
    }

    public static void sortDescending(double[] dArray, int n2, int n3) {
        Preconditions.checkNotNull(dArray);
        Preconditions.checkPositionIndexes(n2, n3, dArray.length);
        Arrays.sort(dArray, n2, n3);
        Doubles.reverse(dArray, n2, n3);
    }

    public static void reverse(double[] dArray) {
        Preconditions.checkNotNull(dArray);
        Doubles.reverse(dArray, 0, dArray.length);
    }

    public static void reverse(double[] dArray, int n2, int n3) {
        Preconditions.checkNotNull(dArray);
        Preconditions.checkPositionIndexes(n2, n3, dArray.length);
        int n4 = n2;
        for (int i2 = n3 - 1; n4 < i2; ++n4, --i2) {
            double d2 = dArray[n4];
            dArray[n4] = dArray[i2];
            dArray[i2] = d2;
        }
    }

    public static double[] toArray(Collection<? extends Number> collection) {
        if (collection instanceof DoubleArrayAsList) {
            return ((DoubleArrayAsList)collection).toDoubleArray();
        }
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        double[] dArray = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = ((Number)Preconditions.checkNotNull(objectArray[i2])).doubleValue();
        }
        return dArray;
    }

    public static List<Double> asList(double ... dArray) {
        if (dArray.length == 0) {
            return Collections.emptyList();
        }
        return new DoubleArrayAsList(dArray);
    }

    @GwtIncompatible
    private static Pattern fpPattern() {
        String string = "(?:\\d+#(?:\\.\\d*#)?|\\.\\d+#)";
        String string2 = string + "(?:[eE][+-]?\\d+#)?[fFdD]?";
        String string3 = "(?:[0-9a-fA-F]+#(?:\\.[0-9a-fA-F]*#)?|\\.[0-9a-fA-F]+#)";
        String string4 = "0[xX]" + string3 + "[pP][+-]?\\d+#[fFdD]?";
        String string5 = "[+-]?(?:NaN|Infinity|" + string2 + "|" + string4 + ")";
        string5 = string5.replace("#", "+");
        return Pattern.compile(string5);
    }

    @Beta
    @GwtIncompatible
    public static @Nullable Double tryParse(String string) {
        if (FLOATING_POINT_PATTERN.matcher(string).matches()) {
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @GwtCompatible
    private static class DoubleArrayAsList
    extends AbstractList<Double>
    implements Serializable,
    RandomAccess {
        final double[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        DoubleArrayAsList(double[] dArray) {
            this(dArray, 0, dArray.length);
        }

        DoubleArrayAsList(double[] dArray, int n2, int n3) {
            this.array = dArray;
            this.start = n2;
            this.end = n3;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Double get(int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            return this.array[this.start + n2];
        }

        public Spliterator.OfDouble spliterator() {
            return Spliterators.spliterator(this.array, this.start, this.end, 0);
        }

        @Override
        public boolean contains(Object object) {
            return object instanceof Double && Doubles.indexOf(this.array, (Double)object, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object object) {
            int n2;
            if (object instanceof Double && (n2 = Doubles.indexOf(this.array, (Double)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            int n2;
            if (object instanceof Double && (n2 = Doubles.lastIndexOf(this.array, (Double)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public Double set(int n2, Double d2) {
            Preconditions.checkElementIndex(n2, this.size());
            double d3 = this.array[this.start + n2];
            this.array[this.start + n2] = Preconditions.checkNotNull(d2);
            return d3;
        }

        @Override
        public List<Double> subList(int n2, int n3) {
            int n4 = this.size();
            Preconditions.checkPositionIndexes(n2, n3, n4);
            if (n2 == n3) {
                return Collections.emptyList();
            }
            return new DoubleArrayAsList(this.array, this.start + n2, this.start + n3);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof DoubleArrayAsList) {
                DoubleArrayAsList doubleArrayAsList = (DoubleArrayAsList)object;
                int n2 = this.size();
                if (doubleArrayAsList.size() != n2) {
                    return false;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.array[this.start + i2] == doubleArrayAsList.array[doubleArrayAsList.start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int n2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                n2 = 31 * n2 + Doubles.hashCode(this.array[i2]);
            }
            return n2;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.size() * 12);
            stringBuilder.append('[').append(this.array[this.start]);
            for (int i2 = this.start + 1; i2 < this.end; ++i2) {
                stringBuilder.append(", ").append(this.array[i2]);
            }
            return stringBuilder.append(']').toString();
        }

        double[] toDoubleArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }
    }

    private static enum LexicographicalComparator implements Comparator<double[]>
    {
        INSTANCE;


        @Override
        public int compare(double[] dArray, double[] dArray2) {
            int n2 = Math.min(dArray.length, dArray2.length);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = Double.compare(dArray[i2], dArray2[i2]);
                if (n3 == 0) continue;
                return n3;
            }
            return dArray.length - dArray2.length;
        }

        public String toString() {
            return "Doubles.lexicographicalComparator()";
        }
    }

    private static final class DoubleConverter
    extends Converter<String, Double>
    implements Serializable {
        static final DoubleConverter INSTANCE = new DoubleConverter();
        private static final long serialVersionUID = 1L;

        private DoubleConverter() {
        }

        @Override
        protected Double doForward(String string) {
            return Double.valueOf(string);
        }

        @Override
        protected String doBackward(Double d2) {
            return d2.toString();
        }

        public String toString() {
            return "Doubles.stringConverter()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

