/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(emulated=true)
public final class Chars {
    public static final int BYTES = 2;

    private Chars() {
    }

    public static int hashCode(char c2) {
        return c2;
    }

    public static char checkedCast(long l2) {
        char c2 = (char)l2;
        Preconditions.checkArgument((long)c2 == l2, "Out of range: %s", l2);
        return c2;
    }

    public static char saturatedCast(long l2) {
        if (l2 > 65535L) {
            return '\uffff';
        }
        if (l2 < 0L) {
            return '\u0000';
        }
        return (char)l2;
    }

    public static int compare(char c2, char c3) {
        return c2 - c3;
    }

    public static boolean contains(char[] cArray, char c2) {
        for (char c3 : cArray) {
            if (c3 != c2) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(char[] cArray, char c2) {
        return Chars.indexOf(cArray, c2, 0, cArray.length);
    }

    private static int indexOf(char[] cArray, char c2, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            if (cArray[i2] != c2) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(char[] cArray, char[] cArray2) {
        Preconditions.checkNotNull(cArray, "array");
        Preconditions.checkNotNull(cArray2, "target");
        if (cArray2.length == 0) {
            return 0;
        }
        block0: for (int i2 = 0; i2 < cArray.length - cArray2.length + 1; ++i2) {
            for (int i3 = 0; i3 < cArray2.length; ++i3) {
                if (cArray[i2 + i3] != cArray2[i3]) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(char[] cArray, char c2) {
        return Chars.lastIndexOf(cArray, c2, 0, cArray.length);
    }

    private static int lastIndexOf(char[] cArray, char c2, int n2, int n3) {
        for (int i2 = n3 - 1; i2 >= n2; --i2) {
            if (cArray[i2] != c2) continue;
            return i2;
        }
        return -1;
    }

    public static char min(char ... cArray) {
        Preconditions.checkArgument(cArray.length > 0);
        char c2 = cArray[0];
        for (int i2 = 1; i2 < cArray.length; ++i2) {
            if (cArray[i2] >= c2) continue;
            c2 = cArray[i2];
        }
        return c2;
    }

    public static char max(char ... cArray) {
        Preconditions.checkArgument(cArray.length > 0);
        char c2 = cArray[0];
        for (int i2 = 1; i2 < cArray.length; ++i2) {
            if (cArray[i2] <= c2) continue;
            c2 = cArray[i2];
        }
        return c2;
    }

    @Beta
    public static char constrainToRange(char c2, char c3, char c4) {
        Preconditions.checkArgument(c3 <= c4, "min (%s) must be less than or equal to max (%s)", c3, c4);
        return c2 < c3 ? c3 : (c2 < c4 ? c2 : c4);
    }

    public static char[] concat(char[] ... cArray) {
        int n2 = 0;
        for (char[] cArray2 : cArray) {
            n2 += cArray2.length;
        }
        char[] cArray3 = new char[n2];
        int n3 = 0;
        for (char[] cArray4 : cArray) {
            System.arraycopy(cArray4, 0, cArray3, n3, cArray4.length);
            n3 += cArray4.length;
        }
        return cArray3;
    }

    @GwtIncompatible
    public static byte[] toByteArray(char c2) {
        return new byte[]{(byte)(c2 >> 8), (byte)c2};
    }

    @GwtIncompatible
    public static char fromByteArray(byte[] byArray) {
        Preconditions.checkArgument(byArray.length >= 2, "array too small: %s < %s", byArray.length, 2);
        return Chars.fromBytes(byArray[0], byArray[1]);
    }

    @GwtIncompatible
    public static char fromBytes(byte by2, byte by3) {
        return (char)(by2 << 8 | by3 & 0xFF);
    }

    public static char[] ensureCapacity(char[] cArray, int n2, int n3) {
        Preconditions.checkArgument(n2 >= 0, "Invalid minLength: %s", n2);
        Preconditions.checkArgument(n3 >= 0, "Invalid padding: %s", n3);
        return cArray.length < n2 ? Arrays.copyOf(cArray, n2 + n3) : cArray;
    }

    public static String join(String string, char ... cArray) {
        Preconditions.checkNotNull(string);
        int n2 = cArray.length;
        if (n2 == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(n2 + string.length() * (n2 - 1));
        stringBuilder.append(cArray[0]);
        for (int i2 = 1; i2 < n2; ++i2) {
            stringBuilder.append(string).append(cArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static Comparator<char[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static char[] toArray(Collection<Character> collection) {
        if (collection instanceof CharArrayAsList) {
            return ((CharArrayAsList)collection).toCharArray();
        }
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = ((Character)Preconditions.checkNotNull(objectArray[i2])).charValue();
        }
        return cArray;
    }

    public static void sortDescending(char[] cArray) {
        Preconditions.checkNotNull(cArray);
        Chars.sortDescending(cArray, 0, cArray.length);
    }

    public static void sortDescending(char[] cArray, int n2, int n3) {
        Preconditions.checkNotNull(cArray);
        Preconditions.checkPositionIndexes(n2, n3, cArray.length);
        Arrays.sort(cArray, n2, n3);
        Chars.reverse(cArray, n2, n3);
    }

    public static void reverse(char[] cArray) {
        Preconditions.checkNotNull(cArray);
        Chars.reverse(cArray, 0, cArray.length);
    }

    public static void reverse(char[] cArray, int n2, int n3) {
        Preconditions.checkNotNull(cArray);
        Preconditions.checkPositionIndexes(n2, n3, cArray.length);
        int n4 = n2;
        for (int i2 = n3 - 1; n4 < i2; ++n4, --i2) {
            char c2 = cArray[n4];
            cArray[n4] = cArray[i2];
            cArray[i2] = c2;
        }
    }

    public static List<Character> asList(char ... cArray) {
        if (cArray.length == 0) {
            return Collections.emptyList();
        }
        return new CharArrayAsList(cArray);
    }

    @GwtCompatible
    private static class CharArrayAsList
    extends AbstractList<Character>
    implements Serializable,
    RandomAccess {
        final char[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        CharArrayAsList(char[] cArray) {
            this(cArray, 0, cArray.length);
        }

        CharArrayAsList(char[] cArray, int n2, int n3) {
            this.array = cArray;
            this.start = n2;
            this.end = n3;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Character get(int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            return Character.valueOf(this.array[this.start + n2]);
        }

        @Override
        public boolean contains(Object object) {
            return object instanceof Character && Chars.indexOf(this.array, ((Character)object).charValue(), this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object object) {
            int n2;
            if (object instanceof Character && (n2 = Chars.indexOf(this.array, ((Character)object).charValue(), this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            int n2;
            if (object instanceof Character && (n2 = Chars.lastIndexOf(this.array, ((Character)object).charValue(), this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public Character set(int n2, Character c2) {
            Preconditions.checkElementIndex(n2, this.size());
            char c3 = this.array[this.start + n2];
            this.array[this.start + n2] = Preconditions.checkNotNull(c2).charValue();
            return Character.valueOf(c3);
        }

        @Override
        public List<Character> subList(int n2, int n3) {
            int n4 = this.size();
            Preconditions.checkPositionIndexes(n2, n3, n4);
            if (n2 == n3) {
                return Collections.emptyList();
            }
            return new CharArrayAsList(this.array, this.start + n2, this.start + n3);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof CharArrayAsList) {
                CharArrayAsList charArrayAsList = (CharArrayAsList)object;
                int n2 = this.size();
                if (charArrayAsList.size() != n2) {
                    return false;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.array[this.start + i2] == charArrayAsList.array[charArrayAsList.start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int n2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                n2 = 31 * n2 + Chars.hashCode(this.array[i2]);
            }
            return n2;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.size() * 3);
            stringBuilder.append('[').append(this.array[this.start]);
            for (int i2 = this.start + 1; i2 < this.end; ++i2) {
                stringBuilder.append(", ").append(this.array[i2]);
            }
            return stringBuilder.append(']').toString();
        }

        char[] toCharArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }
    }

    private static enum LexicographicalComparator implements Comparator<char[]>
    {
        INSTANCE;


        @Override
        public int compare(char[] cArray, char[] cArray2) {
            int n2 = Math.min(cArray.length, cArray2.length);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = Chars.compare(cArray[i2], cArray2[i2]);
                if (n3 == 0) continue;
                return n3;
            }
            return cArray.length - cArray2.length;
        }

        public String toString() {
            return "Chars.lexicographicalComparator()";
        }
    }
}

