/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
public final class Booleans {
    private Booleans() {
    }

    @Beta
    public static Comparator<Boolean> trueFirst() {
        return BooleanComparator.TRUE_FIRST;
    }

    @Beta
    public static Comparator<Boolean> falseFirst() {
        return BooleanComparator.FALSE_FIRST;
    }

    public static int hashCode(boolean bl2) {
        return bl2 ? 1231 : 1237;
    }

    public static int compare(boolean bl2, boolean bl3) {
        return bl2 == bl3 ? 0 : (bl2 ? 1 : -1);
    }

    public static boolean contains(boolean[] blArray, boolean bl2) {
        for (boolean bl3 : blArray) {
            if (bl3 != bl2) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(boolean[] blArray, boolean bl2) {
        return Booleans.indexOf(blArray, bl2, 0, blArray.length);
    }

    private static int indexOf(boolean[] blArray, boolean bl2, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            if (blArray[i2] != bl2) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(boolean[] blArray, boolean[] blArray2) {
        Preconditions.checkNotNull(blArray, "array");
        Preconditions.checkNotNull(blArray2, "target");
        if (blArray2.length == 0) {
            return 0;
        }
        block0: for (int i2 = 0; i2 < blArray.length - blArray2.length + 1; ++i2) {
            for (int i3 = 0; i3 < blArray2.length; ++i3) {
                if (blArray[i2 + i3] != blArray2[i3]) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(boolean[] blArray, boolean bl2) {
        return Booleans.lastIndexOf(blArray, bl2, 0, blArray.length);
    }

    private static int lastIndexOf(boolean[] blArray, boolean bl2, int n2, int n3) {
        for (int i2 = n3 - 1; i2 >= n2; --i2) {
            if (blArray[i2] != bl2) continue;
            return i2;
        }
        return -1;
    }

    public static boolean[] concat(boolean[] ... blArray) {
        int n2 = 0;
        for (boolean[] blArray2 : blArray) {
            n2 += blArray2.length;
        }
        boolean[] blArray3 = new boolean[n2];
        int n3 = 0;
        for (boolean[] blArray4 : blArray) {
            System.arraycopy(blArray4, 0, blArray3, n3, blArray4.length);
            n3 += blArray4.length;
        }
        return blArray3;
    }

    public static boolean[] ensureCapacity(boolean[] blArray, int n2, int n3) {
        Preconditions.checkArgument(n2 >= 0, "Invalid minLength: %s", n2);
        Preconditions.checkArgument(n3 >= 0, "Invalid padding: %s", n3);
        return blArray.length < n2 ? Arrays.copyOf(blArray, n2 + n3) : blArray;
    }

    public static String join(String string, boolean ... blArray) {
        Preconditions.checkNotNull(string);
        if (blArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(blArray.length * 7);
        stringBuilder.append(blArray[0]);
        for (int i2 = 1; i2 < blArray.length; ++i2) {
            stringBuilder.append(string).append(blArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static Comparator<boolean[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static boolean[] toArray(Collection<Boolean> collection) {
        if (collection instanceof BooleanArrayAsList) {
            return ((BooleanArrayAsList)collection).toBooleanArray();
        }
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        boolean[] blArray = new boolean[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            blArray[i2] = (Boolean)Preconditions.checkNotNull(objectArray[i2]);
        }
        return blArray;
    }

    public static List<Boolean> asList(boolean ... blArray) {
        if (blArray.length == 0) {
            return Collections.emptyList();
        }
        return new BooleanArrayAsList(blArray);
    }

    @Beta
    public static int countTrue(boolean ... blArray) {
        int n2 = 0;
        for (boolean bl2 : blArray) {
            if (!bl2) continue;
            ++n2;
        }
        return n2;
    }

    public static void reverse(boolean[] blArray) {
        Preconditions.checkNotNull(blArray);
        Booleans.reverse(blArray, 0, blArray.length);
    }

    public static void reverse(boolean[] blArray, int n2, int n3) {
        Preconditions.checkNotNull(blArray);
        Preconditions.checkPositionIndexes(n2, n3, blArray.length);
        int n4 = n2;
        for (int i2 = n3 - 1; n4 < i2; ++n4, --i2) {
            boolean bl2 = blArray[n4];
            blArray[n4] = blArray[i2];
            blArray[i2] = bl2;
        }
    }

    @GwtCompatible
    private static class BooleanArrayAsList
    extends AbstractList<Boolean>
    implements Serializable,
    RandomAccess {
        final boolean[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        BooleanArrayAsList(boolean[] blArray) {
            this(blArray, 0, blArray.length);
        }

        BooleanArrayAsList(boolean[] blArray, int n2, int n3) {
            this.array = blArray;
            this.start = n2;
            this.end = n3;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Boolean get(int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            return this.array[this.start + n2];
        }

        @Override
        public boolean contains(Object object) {
            return object instanceof Boolean && Booleans.indexOf(this.array, (Boolean)object, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object object) {
            int n2;
            if (object instanceof Boolean && (n2 = Booleans.indexOf(this.array, (Boolean)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            int n2;
            if (object instanceof Boolean && (n2 = Booleans.lastIndexOf(this.array, (Boolean)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public Boolean set(int n2, Boolean bl2) {
            Preconditions.checkElementIndex(n2, this.size());
            boolean bl3 = this.array[this.start + n2];
            this.array[this.start + n2] = Preconditions.checkNotNull(bl2);
            return bl3;
        }

        @Override
        public List<Boolean> subList(int n2, int n3) {
            int n4 = this.size();
            Preconditions.checkPositionIndexes(n2, n3, n4);
            if (n2 == n3) {
                return Collections.emptyList();
            }
            return new BooleanArrayAsList(this.array, this.start + n2, this.start + n3);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof BooleanArrayAsList) {
                BooleanArrayAsList booleanArrayAsList = (BooleanArrayAsList)object;
                int n2 = this.size();
                if (booleanArrayAsList.size() != n2) {
                    return false;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.array[this.start + i2] == booleanArrayAsList.array[booleanArrayAsList.start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int n2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                n2 = 31 * n2 + Booleans.hashCode(this.array[i2]);
            }
            return n2;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.size() * 7);
            stringBuilder.append(this.array[this.start] ? "[true" : "[false");
            for (int i2 = this.start + 1; i2 < this.end; ++i2) {
                stringBuilder.append(this.array[i2] ? ", true" : ", false");
            }
            return stringBuilder.append(']').toString();
        }

        boolean[] toBooleanArray() {
            return Arrays.copyOfRange(this.array, this.start, this.end);
        }
    }

    private static enum LexicographicalComparator implements Comparator<boolean[]>
    {
        INSTANCE;


        @Override
        public int compare(boolean[] blArray, boolean[] blArray2) {
            int n2 = Math.min(blArray.length, blArray2.length);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = Booleans.compare(blArray[i2], blArray2[i2]);
                if (n3 == 0) continue;
                return n3;
            }
            return blArray.length - blArray2.length;
        }

        public String toString() {
            return "Booleans.lexicographicalComparator()";
        }
    }

    private static enum BooleanComparator implements Comparator<Boolean>
    {
        TRUE_FIRST(1, "Booleans.trueFirst()"),
        FALSE_FIRST(-1, "Booleans.falseFirst()");

        private final int trueValue;
        private final String toString;

        private BooleanComparator(int n3, String string2) {
            this.trueValue = n3;
            this.toString = string2;
        }

        @Override
        public int compare(Boolean bl2, Boolean bl3) {
            int n2 = bl2 != false ? this.trueValue : 0;
            int n3 = bl3 != false ? this.trueValue : 0;
            return n3 - n2;
        }

        public String toString() {
            return this.toString;
        }
    }
}

