/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.escape.UnicodeEscaper;

@Beta
@GwtCompatible
public final class PercentEscaper
extends UnicodeEscaper {
    private static final char[] PLUS_SIGN = new char[]{'+'};
    private static final char[] UPPER_HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    private final boolean plusForSpace;
    private final boolean[] safeOctets;

    public PercentEscaper(String string, boolean bl2) {
        Preconditions.checkNotNull(string);
        if (string.matches(".*[0-9A-Za-z].*")) {
            throw new IllegalArgumentException("Alphanumeric characters are always 'safe' and should not be explicitly specified");
        }
        string = string + "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        if (bl2 && string.contains(" ")) {
            throw new IllegalArgumentException("plusForSpace cannot be specified when space is a 'safe' character");
        }
        this.plusForSpace = bl2;
        this.safeOctets = PercentEscaper.createSafeOctets(string);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean[] createSafeOctets(String string) {
        void var6_10;
        char[] cArray;
        int n2 = -1;
        for (char c2 : cArray = string.toCharArray()) {
            n2 = Math.max(c2, n2);
        }
        boolean[] blArray = new boolean[n2 + 1];
        char[] cArray2 = cArray;
        int n3 = cArray2.length;
        boolean bl2 = false;
        while (var6_10 < n3) {
            char c3 = cArray2[var6_10];
            blArray[c3] = true;
            ++var6_10;
        }
        return blArray;
    }

    @Override
    protected int nextEscapeIndex(CharSequence charSequence, int n2, int n3) {
        char c2;
        Preconditions.checkNotNull(charSequence);
        while (n2 < n3 && (c2 = charSequence.charAt(n2)) < this.safeOctets.length && this.safeOctets[c2]) {
            ++n2;
        }
        return n2;
    }

    @Override
    public String escape(String string) {
        Preconditions.checkNotNull(string);
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < this.safeOctets.length && this.safeOctets[c2]) continue;
            return this.escapeSlow(string, i2);
        }
        return string;
    }

    @Override
    protected char[] escape(int n2) {
        if (n2 < this.safeOctets.length && this.safeOctets[n2]) {
            return null;
        }
        if (n2 == 32 && this.plusForSpace) {
            return PLUS_SIGN;
        }
        if (n2 <= 127) {
            char[] cArray = new char[3];
            cArray[0] = 37;
            cArray[2] = UPPER_HEX_DIGITS[n2 & 0xF];
            cArray[1] = UPPER_HEX_DIGITS[n2 >>> 4];
            return cArray;
        }
        if (n2 <= 2047) {
            char[] cArray = new char[6];
            cArray[0] = 37;
            cArray[3] = 37;
            cArray[5] = UPPER_HEX_DIGITS[n2 & 0xF];
            cArray[4] = UPPER_HEX_DIGITS[8 | (n2 >>>= 4) & 3];
            cArray[2] = UPPER_HEX_DIGITS[(n2 >>>= 2) & 0xF];
            cArray[1] = UPPER_HEX_DIGITS[0xC | (n2 >>>= 4)];
            return cArray;
        }
        if (n2 <= 65535) {
            char[] cArray = new char[9];
            cArray[0] = 37;
            cArray[1] = 69;
            cArray[3] = 37;
            cArray[6] = 37;
            cArray[8] = UPPER_HEX_DIGITS[n2 & 0xF];
            cArray[7] = UPPER_HEX_DIGITS[8 | (n2 >>>= 4) & 3];
            cArray[5] = UPPER_HEX_DIGITS[(n2 >>>= 2) & 0xF];
            cArray[4] = UPPER_HEX_DIGITS[8 | (n2 >>>= 4) & 3];
            cArray[2] = UPPER_HEX_DIGITS[n2 >>>= 2];
            return cArray;
        }
        if (n2 <= 0x10FFFF) {
            char[] cArray = new char[12];
            cArray[0] = 37;
            cArray[1] = 70;
            cArray[3] = 37;
            cArray[6] = 37;
            cArray[9] = 37;
            cArray[11] = UPPER_HEX_DIGITS[n2 & 0xF];
            cArray[10] = UPPER_HEX_DIGITS[8 | (n2 >>>= 4) & 3];
            cArray[8] = UPPER_HEX_DIGITS[(n2 >>>= 2) & 0xF];
            cArray[7] = UPPER_HEX_DIGITS[8 | (n2 >>>= 4) & 3];
            cArray[5] = UPPER_HEX_DIGITS[(n2 >>>= 2) & 0xF];
            cArray[4] = UPPER_HEX_DIGITS[8 | (n2 >>>= 4) & 3];
            cArray[2] = UPPER_HEX_DIGITS[(n2 >>>= 2) & 7];
            return cArray;
        }
        throw new IllegalArgumentException("Invalid unicode character value " + n2);
    }
}

