/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.thirdparty.publicsuffix.PublicSuffixPatterns;
import com.google.thirdparty.publicsuffix.PublicSuffixType;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

@Immutable
@Beta
@GwtCompatible
public final class InternetDomainName {
    private static final CharMatcher DOTS_MATCHER = CharMatcher.anyOf(".\u3002\uff0e\uff61");
    private static final Splitter DOT_SPLITTER = Splitter.on('.');
    private static final Joiner DOT_JOINER = Joiner.on('.');
    private static final int NO_SUFFIX_FOUND = -1;
    private static final int MAX_PARTS = 127;
    private static final int MAX_LENGTH = 253;
    private static final int MAX_DOMAIN_PART_LENGTH = 63;
    private final String name;
    private final ImmutableList<String> parts;
    private final int publicSuffixIndex;
    private final int registrySuffixIndex;
    private static final CharMatcher DASH_MATCHER = CharMatcher.anyOf("-_");
    private static final CharMatcher PART_CHAR_MATCHER = CharMatcher.javaLetterOrDigit().or(DASH_MATCHER);

    InternetDomainName(String string) {
        string = Ascii.toLowerCase(DOTS_MATCHER.replaceFrom((CharSequence)string, '.'));
        if (string.endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        Preconditions.checkArgument(string.length() <= 253, "Domain name too long: '%s':", (Object)string);
        this.name = string;
        this.parts = ImmutableList.copyOf(DOT_SPLITTER.split(string));
        Preconditions.checkArgument(this.parts.size() <= 127, "Domain has too many parts: '%s'", (Object)string);
        Preconditions.checkArgument(InternetDomainName.validateSyntax(this.parts), "Not a valid domain name: '%s'", (Object)string);
        this.publicSuffixIndex = this.findSuffixOfType(Optional.absent());
        this.registrySuffixIndex = this.findSuffixOfType(Optional.of(PublicSuffixType.REGISTRY));
    }

    private int findSuffixOfType(Optional<PublicSuffixType> optional) {
        int n2 = this.parts.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = DOT_JOINER.join(this.parts.subList(i2, n2));
            if (InternetDomainName.matchesType(optional, Optional.fromNullable(PublicSuffixPatterns.EXACT.get(string)))) {
                return i2;
            }
            if (PublicSuffixPatterns.EXCLUDED.containsKey(string)) {
                return i2 + 1;
            }
            if (!InternetDomainName.matchesWildcardSuffixType(optional, string)) continue;
            return i2;
        }
        return -1;
    }

    public static InternetDomainName from(String string) {
        return new InternetDomainName(Preconditions.checkNotNull(string));
    }

    private static boolean validateSyntax(List<String> list) {
        int n2 = list.size() - 1;
        if (!InternetDomainName.validatePart(list.get(n2), true)) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = list.get(i2);
            if (InternetDomainName.validatePart(string, false)) continue;
            return false;
        }
        return true;
    }

    private static boolean validatePart(String string, boolean bl2) {
        if (string.length() < 1 || string.length() > 63) {
            return false;
        }
        String string2 = CharMatcher.ascii().retainFrom(string);
        if (!PART_CHAR_MATCHER.matchesAllOf(string2)) {
            return false;
        }
        if (DASH_MATCHER.matches(string.charAt(0)) || DASH_MATCHER.matches(string.charAt(string.length() - 1))) {
            return false;
        }
        return !bl2 || !CharMatcher.digit().matches(string.charAt(0));
    }

    public ImmutableList<String> parts() {
        return this.parts;
    }

    public boolean isPublicSuffix() {
        return this.publicSuffixIndex == 0;
    }

    public boolean hasPublicSuffix() {
        return this.publicSuffixIndex != -1;
    }

    public InternetDomainName publicSuffix() {
        return this.hasPublicSuffix() ? this.ancestor(this.publicSuffixIndex) : null;
    }

    public boolean isUnderPublicSuffix() {
        return this.publicSuffixIndex > 0;
    }

    public boolean isTopPrivateDomain() {
        return this.publicSuffixIndex == 1;
    }

    public InternetDomainName topPrivateDomain() {
        if (this.isTopPrivateDomain()) {
            return this;
        }
        Preconditions.checkState(this.isUnderPublicSuffix(), "Not under a public suffix: %s", (Object)this.name);
        return this.ancestor(this.publicSuffixIndex - 1);
    }

    public boolean isRegistrySuffix() {
        return this.registrySuffixIndex == 0;
    }

    public boolean hasRegistrySuffix() {
        return this.registrySuffixIndex != -1;
    }

    public InternetDomainName registrySuffix() {
        return this.hasRegistrySuffix() ? this.ancestor(this.registrySuffixIndex) : null;
    }

    public boolean isUnderRegistrySuffix() {
        return this.registrySuffixIndex > 0;
    }

    public boolean isTopDomainUnderRegistrySuffix() {
        return this.registrySuffixIndex == 1;
    }

    public InternetDomainName topDomainUnderRegistrySuffix() {
        if (this.isTopDomainUnderRegistrySuffix()) {
            return this;
        }
        Preconditions.checkState(this.isUnderRegistrySuffix(), "Not under a registry suffix: %s", (Object)this.name);
        return this.ancestor(this.registrySuffixIndex - 1);
    }

    public boolean hasParent() {
        return this.parts.size() > 1;
    }

    public InternetDomainName parent() {
        Preconditions.checkState(this.hasParent(), "Domain '%s' has no parent", (Object)this.name);
        return this.ancestor(1);
    }

    private InternetDomainName ancestor(int n2) {
        return InternetDomainName.from(DOT_JOINER.join(this.parts.subList(n2, this.parts.size())));
    }

    public InternetDomainName child(String string) {
        return InternetDomainName.from(Preconditions.checkNotNull(string) + "." + this.name);
    }

    public static boolean isValid(String string) {
        try {
            InternetDomainName.from(string);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    private static boolean matchesWildcardSuffixType(Optional<PublicSuffixType> optional, String string) {
        List<String> list = DOT_SPLITTER.limit(2).splitToList(string);
        return list.size() == 2 && InternetDomainName.matchesType(optional, Optional.fromNullable(PublicSuffixPatterns.UNDER.get(list.get(1))));
    }

    private static boolean matchesType(Optional<PublicSuffixType> optional, Optional<PublicSuffixType> optional2) {
        return optional.isPresent() ? optional.equals(optional2) : optional2.isPresent();
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof InternetDomainName) {
            InternetDomainName internetDomainName = (InternetDomainName)object;
            return this.name.equals(internetDomainName.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

