/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.Nullable;

@Immutable
@Beta
@GwtCompatible
public final class HostAndPort
implements Serializable {
    private static final int NO_PORT = -1;
    private final String host;
    private final int port;
    private final boolean hasBracketlessColons;
    private static final long serialVersionUID = 0L;

    private HostAndPort(String string, int n2, boolean bl2) {
        this.host = string;
        this.port = n2;
        this.hasBracketlessColons = bl2;
    }

    public String getHost() {
        return this.host;
    }

    public boolean hasPort() {
        return this.port >= 0;
    }

    public int getPort() {
        Preconditions.checkState(this.hasPort());
        return this.port;
    }

    public int getPortOrDefault(int n2) {
        return this.hasPort() ? this.port : n2;
    }

    public static HostAndPort fromParts(String string, int n2) {
        Preconditions.checkArgument(HostAndPort.isValidPort(n2), "Port out of range: %s", n2);
        HostAndPort hostAndPort = HostAndPort.fromString(string);
        Preconditions.checkArgument(!hostAndPort.hasPort(), "Host has a port: %s", (Object)string);
        return new HostAndPort(hostAndPort.host, n2, hostAndPort.hasBracketlessColons);
    }

    public static HostAndPort fromHost(String string) {
        HostAndPort hostAndPort = HostAndPort.fromString(string);
        Preconditions.checkArgument(!hostAndPort.hasPort(), "Host has a port: %s", (Object)string);
        return hostAndPort;
    }

    public static HostAndPort fromString(String string) {
        String string2;
        Preconditions.checkNotNull(string);
        String string3 = null;
        boolean bl2 = false;
        if (string.startsWith("[")) {
            String[] stringArray = HostAndPort.getHostAndPortFromBracketedHost(string);
            string2 = stringArray[0];
            string3 = stringArray[1];
        } else {
            int n2 = string.indexOf(58);
            if (n2 >= 0 && string.indexOf(58, n2 + 1) == -1) {
                string2 = string.substring(0, n2);
                string3 = string.substring(n2 + 1);
            } else {
                string2 = string;
                bl2 = n2 >= 0;
            }
        }
        int n3 = -1;
        if (!Strings.isNullOrEmpty(string3)) {
            Preconditions.checkArgument(!string3.startsWith("+"), "Unparseable port number: %s", (Object)string);
            try {
                n3 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Unparseable port number: " + string);
            }
            Preconditions.checkArgument(HostAndPort.isValidPort(n3), "Port number out of range: %s", (Object)string);
        }
        return new HostAndPort(string2, n3, bl2);
    }

    private static String[] getHostAndPortFromBracketedHost(String string) {
        int n2 = 0;
        int n3 = 0;
        Preconditions.checkArgument(string.charAt(0) == '[', "Bracketed host-port string must start with a bracket: %s", (Object)string);
        n2 = string.indexOf(58);
        n3 = string.lastIndexOf(93);
        Preconditions.checkArgument(n2 > -1 && n3 > n2, "Invalid bracketed host/port: %s", (Object)string);
        String string2 = string.substring(1, n3);
        if (n3 + 1 == string.length()) {
            return new String[]{string2, ""};
        }
        Preconditions.checkArgument(string.charAt(n3 + 1) == ':', "Only a colon may follow a close bracket: %s", (Object)string);
        for (int i2 = n3 + 2; i2 < string.length(); ++i2) {
            Preconditions.checkArgument(Character.isDigit(string.charAt(i2)), "Port must be numeric: %s", (Object)string);
        }
        return new String[]{string2, string.substring(n3 + 2)};
    }

    public HostAndPort withDefaultPort(int n2) {
        Preconditions.checkArgument(HostAndPort.isValidPort(n2));
        if (this.hasPort()) {
            return this;
        }
        return new HostAndPort(this.host, n2, this.hasBracketlessColons);
    }

    public HostAndPort requireBracketsForIPv6() {
        Preconditions.checkArgument(!this.hasBracketlessColons, "Possible bracketless IPv6 literal: %s", (Object)this.host);
        return this;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HostAndPort) {
            HostAndPort hostAndPort = (HostAndPort)object;
            return Objects.equal(this.host, hostAndPort.host) && this.port == hostAndPort.port;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.host, this.port);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.host.length() + 8);
        if (this.host.indexOf(58) >= 0) {
            stringBuilder.append('[').append(this.host).append(']');
        } else {
            stringBuilder.append(this.host);
        }
        if (this.hasPort()) {
            stringBuilder.append(':').append(this.port);
        }
        return stringBuilder.toString();
    }

    private static boolean isValidPort(int n2) {
        return n2 >= 0 && n2 <= 65535;
    }
}

