/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.math.DoubleUtils;
import com.google.common.math.Stats;
import com.google.common.primitives.Doubles;
import java.util.Iterator;

@Beta
@GwtIncompatible
public final class StatsAccumulator {
    private long count = 0L;
    private double mean = 0.0;
    private double sumOfSquaresOfDeltas = 0.0;
    private double min = Double.NaN;
    private double max = Double.NaN;

    public void add(double d2) {
        if (this.count == 0L) {
            this.count = 1L;
            this.mean = d2;
            this.min = d2;
            this.max = d2;
            if (!Doubles.isFinite(d2)) {
                this.sumOfSquaresOfDeltas = Double.NaN;
            }
        } else {
            ++this.count;
            if (Doubles.isFinite(d2) && Doubles.isFinite(this.mean)) {
                double d3 = d2 - this.mean;
                this.mean += d3 / (double)this.count;
                this.sumOfSquaresOfDeltas += d3 * (d2 - this.mean);
            } else {
                this.mean = StatsAccumulator.calculateNewMeanNonFinite(this.mean, d2);
                this.sumOfSquaresOfDeltas = Double.NaN;
            }
            this.min = Math.min(this.min, d2);
            this.max = Math.max(this.max, d2);
        }
    }

    public void addAll(Iterable<? extends Number> iterable) {
        for (Number number : iterable) {
            this.add(number.doubleValue());
        }
    }

    public void addAll(Iterator<? extends Number> iterator) {
        while (iterator.hasNext()) {
            this.add(iterator.next().doubleValue());
        }
    }

    public void addAll(double ... dArray) {
        for (double d2 : dArray) {
            this.add(d2);
        }
    }

    public void addAll(int ... nArray) {
        for (int n2 : nArray) {
            this.add(n2);
        }
    }

    public void addAll(long ... lArray) {
        for (long l2 : lArray) {
            this.add(l2);
        }
    }

    public void addAll(Stats stats) {
        if (stats.count() == 0L) {
            return;
        }
        if (this.count == 0L) {
            this.count = stats.count();
            this.mean = stats.mean();
            this.sumOfSquaresOfDeltas = stats.sumOfSquaresOfDeltas();
            this.min = stats.min();
            this.max = stats.max();
        } else {
            this.count += stats.count();
            if (Doubles.isFinite(this.mean) && Doubles.isFinite(stats.mean())) {
                double d2 = stats.mean() - this.mean;
                this.mean += d2 * (double)stats.count() / (double)this.count;
                this.sumOfSquaresOfDeltas += stats.sumOfSquaresOfDeltas() + d2 * (stats.mean() - this.mean) * (double)stats.count();
            } else {
                this.mean = StatsAccumulator.calculateNewMeanNonFinite(this.mean, stats.mean());
                this.sumOfSquaresOfDeltas = Double.NaN;
            }
            this.min = Math.min(this.min, stats.min());
            this.max = Math.max(this.max, stats.max());
        }
    }

    public Stats snapshot() {
        return new Stats(this.count, this.mean, this.sumOfSquaresOfDeltas, this.min, this.max);
    }

    public long count() {
        return this.count;
    }

    public double mean() {
        Preconditions.checkState(this.count != 0L);
        return this.mean;
    }

    public final double sum() {
        return this.mean * (double)this.count;
    }

    public final double populationVariance() {
        Preconditions.checkState(this.count != 0L);
        if (Double.isNaN(this.sumOfSquaresOfDeltas)) {
            return Double.NaN;
        }
        if (this.count == 1L) {
            return 0.0;
        }
        return DoubleUtils.ensureNonNegative(this.sumOfSquaresOfDeltas) / (double)this.count;
    }

    public final double populationStandardDeviation() {
        return Math.sqrt(this.populationVariance());
    }

    public final double sampleVariance() {
        Preconditions.checkState(this.count > 1L);
        if (Double.isNaN(this.sumOfSquaresOfDeltas)) {
            return Double.NaN;
        }
        return DoubleUtils.ensureNonNegative(this.sumOfSquaresOfDeltas) / (double)(this.count - 1L);
    }

    public final double sampleStandardDeviation() {
        return Math.sqrt(this.sampleVariance());
    }

    public double min() {
        Preconditions.checkState(this.count != 0L);
        return this.min;
    }

    public double max() {
        Preconditions.checkState(this.count != 0L);
        return this.max;
    }

    double sumOfSquaresOfDeltas() {
        return this.sumOfSquaresOfDeltas;
    }

    static double calculateNewMeanNonFinite(double d2, double d3) {
        if (Doubles.isFinite(d2)) {
            return d3;
        }
        if (Doubles.isFinite(d3) || d2 == d3) {
            return d2;
        }
        return Double.NaN;
    }
}

