/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.math.LongMath;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@Beta
@GwtIncompatible
public final class Quantiles {
    public static ScaleAndIndex median() {
        return Quantiles.scale(2).index(1);
    }

    public static Scale quartiles() {
        return Quantiles.scale(4);
    }

    public static Scale percentiles() {
        return Quantiles.scale(100);
    }

    public static Scale scale(int n2) {
        return new Scale(n2);
    }

    private static boolean containsNaN(double ... dArray) {
        for (double d2 : dArray) {
            if (!Double.isNaN(d2)) continue;
            return true;
        }
        return false;
    }

    private static double interpolate(double d2, double d3, double d4, double d5) {
        if (d2 == Double.NEGATIVE_INFINITY) {
            if (d3 == Double.POSITIVE_INFINITY) {
                return Double.NaN;
            }
            return Double.NEGATIVE_INFINITY;
        }
        if (d3 == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        return d2 + (d3 - d2) * d4 / d5;
    }

    private static void checkIndex(int n2, int n3) {
        if (n2 < 0 || n2 > n3) {
            throw new IllegalArgumentException("Quantile indexes must be between 0 and the scale, which is " + n3);
        }
    }

    private static double[] longsToDoubles(long[] lArray) {
        int n2 = lArray.length;
        double[] dArray = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = lArray[i2];
        }
        return dArray;
    }

    private static double[] intsToDoubles(int[] nArray) {
        int n2 = nArray.length;
        double[] dArray = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = nArray[i2];
        }
        return dArray;
    }

    private static void selectInPlace(int n2, double[] dArray, int n3, int n4) {
        if (n2 == n3) {
            int n5 = n3;
            for (int i2 = n3 + 1; i2 <= n4; ++i2) {
                if (!(dArray[n5] > dArray[i2])) continue;
                n5 = i2;
            }
            if (n5 != n3) {
                Quantiles.swap(dArray, n5, n3);
            }
            return;
        }
        while (n4 > n3) {
            int n6 = Quantiles.partition(dArray, n3, n4);
            if (n6 >= n2) {
                n4 = n6 - 1;
            }
            if (n6 > n2) continue;
            n3 = n6 + 1;
        }
    }

    private static int partition(double[] dArray, int n2, int n3) {
        Quantiles.movePivotToStartOfSlice(dArray, n2, n3);
        double d2 = dArray[n2];
        int n4 = n3;
        for (int i2 = n3; i2 > n2; --i2) {
            if (!(dArray[i2] > d2)) continue;
            Quantiles.swap(dArray, n4, i2);
            --n4;
        }
        Quantiles.swap(dArray, n2, n4);
        return n4;
    }

    private static void movePivotToStartOfSlice(double[] dArray, int n2, int n3) {
        boolean bl2;
        int n4 = n2 + n3 >>> 1;
        boolean bl3 = dArray[n3] < dArray[n4];
        boolean bl4 = dArray[n4] < dArray[n2];
        boolean bl5 = bl2 = dArray[n3] < dArray[n2];
        if (bl3 == bl4) {
            Quantiles.swap(dArray, n4, n2);
        } else if (bl3 != bl2) {
            Quantiles.swap(dArray, n2, n3);
        }
    }

    private static void selectAllInPlace(int[] nArray, int n2, int n3, double[] dArray, int n4, int n5) {
        int n6;
        int n7;
        int n8 = Quantiles.chooseNextSelection(nArray, n2, n3, n4, n5);
        int n9 = nArray[n8];
        Quantiles.selectInPlace(n9, dArray, n4, n5);
        for (n7 = n8 - 1; n7 >= n2 && nArray[n7] == n9; --n7) {
        }
        if (n7 >= n2) {
            Quantiles.selectAllInPlace(nArray, n2, n7, dArray, n4, n9 - 1);
        }
        for (n6 = n8 + 1; n6 <= n3 && nArray[n6] == n9; ++n6) {
        }
        if (n6 <= n3) {
            Quantiles.selectAllInPlace(nArray, n6, n3, dArray, n9 + 1, n5);
        }
    }

    private static int chooseNextSelection(int[] nArray, int n2, int n3, int n4, int n5) {
        if (n2 == n3) {
            return n2;
        }
        int n6 = n4 + n5 >>> 1;
        int n7 = n2;
        int n8 = n3;
        while (n8 > n7 + 1) {
            int n9 = n7 + n8 >>> 1;
            if (nArray[n9] > n6) {
                n8 = n9;
                continue;
            }
            if (nArray[n9] < n6) {
                n7 = n9;
                continue;
            }
            return n9;
        }
        if (n4 + n5 - nArray[n7] - nArray[n8] > 0) {
            return n8;
        }
        return n7;
    }

    private static void swap(double[] dArray, int n2, int n3) {
        double d2 = dArray[n2];
        dArray[n2] = dArray[n3];
        dArray[n3] = d2;
    }

    public static final class ScaleAndIndexes {
        private final int scale;
        private final int[] indexes;

        private ScaleAndIndexes(int n2, int[] nArray) {
            for (int n3 : nArray) {
                Quantiles.checkIndex(n3, n2);
            }
            this.scale = n2;
            this.indexes = nArray;
        }

        public Map<Integer, Double> compute(Collection<? extends Number> collection) {
            return this.computeInPlace(Doubles.toArray(collection));
        }

        public Map<Integer, Double> compute(double ... dArray) {
            return this.computeInPlace((double[])dArray.clone());
        }

        public Map<Integer, Double> compute(long ... lArray) {
            return this.computeInPlace(Quantiles.longsToDoubles(lArray));
        }

        public Map<Integer, Double> compute(int ... nArray) {
            return this.computeInPlace(Quantiles.intsToDoubles(nArray));
        }

        public Map<Integer, Double> computeInPlace(double ... dArray) {
            int n2;
            Preconditions.checkArgument(dArray.length > 0, "Cannot calculate quantiles of an empty dataset");
            if (Quantiles.containsNaN(dArray)) {
                HashMap<Integer, Double> hashMap = new HashMap<Integer, Double>();
                for (int n3 : this.indexes) {
                    hashMap.put(n3, Double.NaN);
                }
                return Collections.unmodifiableMap(hashMap);
            }
            int[] nArray = new int[this.indexes.length];
            int[] nArray2 = new int[this.indexes.length];
            int[] nArray3 = new int[this.indexes.length * 2];
            int n4 = 0;
            for (int i2 = 0; i2 < this.indexes.length; ++i2) {
                long l2 = (long)this.indexes[i2] * (long)(dArray.length - 1);
                n2 = (int)LongMath.divide(l2, this.scale, RoundingMode.DOWN);
                int n5 = (int)(l2 - (long)n2 * (long)this.scale);
                nArray[i2] = n2;
                nArray2[i2] = n5;
                nArray3[n4] = n2;
                ++n4;
                if (n5 == 0) continue;
                nArray3[n4] = n2 + 1;
                ++n4;
            }
            Arrays.sort(nArray3, 0, n4);
            Quantiles.selectAllInPlace(nArray3, 0, n4 - 1, dArray, 0, dArray.length - 1);
            HashMap<Integer, Double> hashMap = new HashMap<Integer, Double>();
            for (int i3 = 0; i3 < this.indexes.length; ++i3) {
                int n6 = nArray[i3];
                n2 = nArray2[i3];
                if (n2 == 0) {
                    hashMap.put(this.indexes[i3], dArray[n6]);
                    continue;
                }
                hashMap.put(this.indexes[i3], Quantiles.interpolate(dArray[n6], dArray[n6 + 1], n2, this.scale));
            }
            return Collections.unmodifiableMap(hashMap);
        }
    }

    public static final class ScaleAndIndex {
        private final int scale;
        private final int index;

        private ScaleAndIndex(int n2, int n3) {
            Quantiles.checkIndex(n3, n2);
            this.scale = n2;
            this.index = n3;
        }

        public double compute(Collection<? extends Number> collection) {
            return this.computeInPlace(Doubles.toArray(collection));
        }

        public double compute(double ... dArray) {
            return this.computeInPlace((double[])dArray.clone());
        }

        public double compute(long ... lArray) {
            return this.computeInPlace(Quantiles.longsToDoubles(lArray));
        }

        public double compute(int ... nArray) {
            return this.computeInPlace(Quantiles.intsToDoubles(nArray));
        }

        public double computeInPlace(double ... dArray) {
            Preconditions.checkArgument(dArray.length > 0, "Cannot calculate quantiles of an empty dataset");
            if (Quantiles.containsNaN(dArray)) {
                return Double.NaN;
            }
            long l2 = (long)this.index * (long)(dArray.length - 1);
            int n2 = (int)LongMath.divide(l2, this.scale, RoundingMode.DOWN);
            int n3 = (int)(l2 - (long)n2 * (long)this.scale);
            Quantiles.selectInPlace(n2, dArray, 0, dArray.length - 1);
            if (n3 == 0) {
                return dArray[n2];
            }
            Quantiles.selectInPlace(n2 + 1, dArray, n2 + 1, dArray.length - 1);
            return Quantiles.interpolate(dArray[n2], dArray[n2 + 1], n3, this.scale);
        }
    }

    public static final class Scale {
        private final int scale;

        private Scale(int n2) {
            Preconditions.checkArgument(n2 > 0, "Quantile scale must be positive");
            this.scale = n2;
        }

        public ScaleAndIndex index(int n2) {
            return new ScaleAndIndex(this.scale, n2);
        }

        public ScaleAndIndexes indexes(int ... nArray) {
            return new ScaleAndIndexes(this.scale, (int[])nArray.clone());
        }

        public ScaleAndIndexes indexes(Collection<Integer> collection) {
            return new ScaleAndIndexes(this.scale, Ints.toArray(collection));
        }
    }
}

