/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.math.LinearTransformation;
import com.google.common.math.PairedStats;
import com.google.common.math.Stats;
import com.google.common.math.StatsAccumulator;
import com.google.common.primitives.Doubles;

@Beta
@GwtIncompatible
public final class PairedStatsAccumulator {
    private final StatsAccumulator xStats = new StatsAccumulator();
    private final StatsAccumulator yStats = new StatsAccumulator();
    private double sumOfProductsOfDeltas = 0.0;

    public void add(double d2, double d3) {
        this.xStats.add(d2);
        if (Doubles.isFinite(d2) && Doubles.isFinite(d3)) {
            if (this.xStats.count() > 1L) {
                this.sumOfProductsOfDeltas += (d2 - this.xStats.mean()) * (d3 - this.yStats.mean());
            }
        } else {
            this.sumOfProductsOfDeltas = Double.NaN;
        }
        this.yStats.add(d3);
    }

    public void addAll(PairedStats pairedStats) {
        if (pairedStats.count() == 0L) {
            return;
        }
        this.xStats.addAll(pairedStats.xStats());
        this.sumOfProductsOfDeltas = this.yStats.count() == 0L ? pairedStats.sumOfProductsOfDeltas() : (this.sumOfProductsOfDeltas += pairedStats.sumOfProductsOfDeltas() + (pairedStats.xStats().mean() - this.xStats.mean()) * (pairedStats.yStats().mean() - this.yStats.mean()) * (double)pairedStats.count());
        this.yStats.addAll(pairedStats.yStats());
    }

    public PairedStats snapshot() {
        return new PairedStats(this.xStats.snapshot(), this.yStats.snapshot(), this.sumOfProductsOfDeltas);
    }

    public long count() {
        return this.xStats.count();
    }

    public Stats xStats() {
        return this.xStats.snapshot();
    }

    public Stats yStats() {
        return this.yStats.snapshot();
    }

    public double populationCovariance() {
        Preconditions.checkState(this.count() != 0L);
        return this.sumOfProductsOfDeltas / (double)this.count();
    }

    public final double sampleCovariance() {
        Preconditions.checkState(this.count() > 1L);
        return this.sumOfProductsOfDeltas / (double)(this.count() - 1L);
    }

    public final double pearsonsCorrelationCoefficient() {
        Preconditions.checkState(this.count() > 1L);
        if (Double.isNaN(this.sumOfProductsOfDeltas)) {
            return Double.NaN;
        }
        double d2 = this.xStats.sumOfSquaresOfDeltas();
        double d3 = this.yStats.sumOfSquaresOfDeltas();
        Preconditions.checkState(d2 > 0.0);
        Preconditions.checkState(d3 > 0.0);
        double d4 = this.ensurePositive(d2 * d3);
        return PairedStatsAccumulator.ensureInUnitRange(this.sumOfProductsOfDeltas / Math.sqrt(d4));
    }

    public final LinearTransformation leastSquaresFit() {
        Preconditions.checkState(this.count() > 1L);
        if (Double.isNaN(this.sumOfProductsOfDeltas)) {
            return LinearTransformation.forNaN();
        }
        double d2 = this.xStats.sumOfSquaresOfDeltas();
        if (d2 > 0.0) {
            if (this.yStats.sumOfSquaresOfDeltas() > 0.0) {
                return LinearTransformation.mapping(this.xStats.mean(), this.yStats.mean()).withSlope(this.sumOfProductsOfDeltas / d2);
            }
            return LinearTransformation.horizontal(this.yStats.mean());
        }
        Preconditions.checkState(this.yStats.sumOfSquaresOfDeltas() > 0.0);
        return LinearTransformation.vertical(this.xStats.mean());
    }

    private double ensurePositive(double d2) {
        if (d2 > 0.0) {
            return d2;
        }
        return Double.MIN_VALUE;
    }

    private static double ensureInUnitRange(double d2) {
        if (d2 >= 1.0) {
            return 1.0;
        }
        if (d2 <= -1.0) {
            return -1.0;
        }
        return d2;
    }
}

