/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtCompatible;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
@CanIgnoreReturnValue
final class MathPreconditions {
    static int checkPositive(@Nullable String string, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException(string + " (" + n2 + ") must be > 0");
        }
        return n2;
    }

    static long checkPositive(@Nullable String string, long l2) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException(string + " (" + l2 + ") must be > 0");
        }
        return l2;
    }

    static BigInteger checkPositive(@Nullable String string, BigInteger bigInteger) {
        if (bigInteger.signum() <= 0) {
            throw new IllegalArgumentException(string + " (" + bigInteger + ") must be > 0");
        }
        return bigInteger;
    }

    static int checkNonNegative(@Nullable String string, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(string + " (" + n2 + ") must be >= 0");
        }
        return n2;
    }

    static long checkNonNegative(@Nullable String string, long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException(string + " (" + l2 + ") must be >= 0");
        }
        return l2;
    }

    static BigInteger checkNonNegative(@Nullable String string, BigInteger bigInteger) {
        if (bigInteger.signum() < 0) {
            throw new IllegalArgumentException(string + " (" + bigInteger + ") must be >= 0");
        }
        return bigInteger;
    }

    static double checkNonNegative(@Nullable String string, double d2) {
        if (!(d2 >= 0.0)) {
            throw new IllegalArgumentException(string + " (" + d2 + ") must be >= 0");
        }
        return d2;
    }

    static void checkRoundingUnnecessary(boolean bl2) {
        if (!bl2) {
            throw new ArithmeticException("mode was UNNECESSARY, but rounding was necessary");
        }
    }

    static void checkInRangeForRoundingInputs(boolean bl2, double d2, RoundingMode roundingMode) {
        if (!bl2) {
            throw new ArithmeticException("rounded value is out of range for input " + d2 + " and rounding mode " + (Object)((Object)roundingMode));
        }
    }

    static void checkNoOverflow(boolean bl2, String string, int n2, int n3) {
        if (!bl2) {
            throw new ArithmeticException("overflow: " + string + "(" + n2 + ", " + n3 + ")");
        }
    }

    static void checkNoOverflow(boolean bl2, String string, long l2, long l3) {
        if (!bl2) {
            throw new ArithmeticException("overflow: " + string + "(" + l2 + ", " + l3 + ")");
        }
    }

    private MathPreconditions() {
    }
}

