/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.io.CharSource;
import java.io.Reader;
import java.util.Iterator;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtIncompatible
class MultiReader
extends Reader {
    private final Iterator<? extends CharSource> it;
    private @Nullable Reader current;

    MultiReader(Iterator<? extends CharSource> iterator) {
        this.it = iterator;
        this.advance();
    }

    private void advance() {
        this.close();
        if (this.it.hasNext()) {
            this.current = this.it.next().openStream();
        }
    }

    @Override
    public int read(char @Nullable [] cArray, int n2, int n3) {
        if (this.current == null) {
            return -1;
        }
        int n4 = this.current.read(cArray, n2, n3);
        if (n4 == -1) {
            this.advance();
            return this.read(cArray, n2, n3);
        }
        return n4;
    }

    @Override
    public long skip(long l2) {
        Preconditions.checkArgument(l2 >= 0L, "n is negative");
        if (l2 > 0L) {
            while (this.current != null) {
                long l3 = this.current.skip(l2);
                if (l3 > 0L) {
                    return l3;
                }
                this.advance();
            }
        }
        return 0L;
    }

    @Override
    public boolean ready() {
        return this.current != null && this.current.ready();
    }

    @Override
    public void close() {
        if (this.current != null) {
            try {
                this.current.close();
            }
            finally {
                this.current = null;
            }
        }
    }
}

