/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import java.io.InputStream;
import java.util.Iterator;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtIncompatible
final class MultiInputStream
extends InputStream {
    private Iterator<? extends ByteSource> it;
    private @Nullable InputStream in;

    public MultiInputStream(Iterator<? extends ByteSource> iterator) {
        this.it = Preconditions.checkNotNull(iterator);
        this.advance();
    }

    @Override
    public void close() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            finally {
                this.in = null;
            }
        }
    }

    private void advance() {
        this.close();
        if (this.it.hasNext()) {
            this.in = this.it.next().openStream();
        }
    }

    @Override
    public int available() {
        if (this.in == null) {
            return 0;
        }
        return this.in.available();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() {
        while (this.in != null) {
            int n2 = this.in.read();
            if (n2 != -1) {
                return n2;
            }
            this.advance();
        }
        return -1;
    }

    @Override
    public int read(byte @Nullable [] byArray, int n2, int n3) {
        while (this.in != null) {
            int n4 = this.in.read(byArray, n2, n3);
            if (n4 != -1) {
                return n4;
            }
            this.advance();
        }
        return -1;
    }

    @Override
    public long skip(long l2) {
        if (this.in == null || l2 <= 0L) {
            return 0L;
        }
        long l3 = this.in.skip(l2);
        if (l3 != 0L) {
            return l3;
        }
        if (this.read() == -1) {
            return 0L;
        }
        return 1L + this.in.skip(l2 - 1L);
    }
}

