/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;

@Beta
@GwtIncompatible
public final class LittleEndianDataOutputStream
extends FilterOutputStream
implements DataOutput {
    public LittleEndianDataOutputStream(OutputStream outputStream) {
        super(new DataOutputStream(Preconditions.checkNotNull(outputStream)));
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        this.out.write(byArray, n2, n3);
    }

    @Override
    public void writeBoolean(boolean bl2) {
        ((DataOutputStream)this.out).writeBoolean(bl2);
    }

    @Override
    public void writeByte(int n2) {
        ((DataOutputStream)this.out).writeByte(n2);
    }

    @Override
    @Deprecated
    public void writeBytes(String string) {
        ((DataOutputStream)this.out).writeBytes(string);
    }

    @Override
    public void writeChar(int n2) {
        this.writeShort(n2);
    }

    @Override
    public void writeChars(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            this.writeChar(string.charAt(i2));
        }
    }

    @Override
    public void writeDouble(double d2) {
        this.writeLong(Double.doubleToLongBits(d2));
    }

    @Override
    public void writeFloat(float f2) {
        this.writeInt(Float.floatToIntBits(f2));
    }

    @Override
    public void writeInt(int n2) {
        this.out.write(0xFF & n2);
        this.out.write(0xFF & n2 >> 8);
        this.out.write(0xFF & n2 >> 16);
        this.out.write(0xFF & n2 >> 24);
    }

    @Override
    public void writeLong(long l2) {
        byte[] byArray = Longs.toByteArray(Long.reverseBytes(l2));
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void writeShort(int n2) {
        this.out.write(0xFF & n2);
        this.out.write(0xFF & n2 >> 8);
    }

    @Override
    public void writeUTF(String string) {
        ((DataOutputStream)this.out).writeUTF(string);
    }

    @Override
    public void close() {
        this.out.close();
    }
}

