/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.InputStream;

@Beta
@GwtIncompatible
public final class LittleEndianDataInputStream
extends FilterInputStream
implements DataInput {
    public LittleEndianDataInputStream(InputStream inputStream) {
        super(Preconditions.checkNotNull(inputStream));
    }

    @Override
    @CanIgnoreReturnValue
    public String readLine() {
        throw new UnsupportedOperationException("readLine is not supported");
    }

    @Override
    public void readFully(byte[] byArray) {
        ByteStreams.readFully(this, byArray);
    }

    @Override
    public void readFully(byte[] byArray, int n2, int n3) {
        ByteStreams.readFully(this, byArray, n2, n3);
    }

    @Override
    public int skipBytes(int n2) {
        return (int)this.in.skip(n2);
    }

    @Override
    @CanIgnoreReturnValue
    public int readUnsignedByte() {
        int n2 = this.in.read();
        if (0 > n2) {
            throw new EOFException();
        }
        return n2;
    }

    @Override
    @CanIgnoreReturnValue
    public int readUnsignedShort() {
        byte by2 = this.readAndCheckByte();
        byte by3 = this.readAndCheckByte();
        return Ints.fromBytes((byte)0, (byte)0, by3, by2);
    }

    @Override
    @CanIgnoreReturnValue
    public int readInt() {
        byte by2 = this.readAndCheckByte();
        byte by3 = this.readAndCheckByte();
        byte by4 = this.readAndCheckByte();
        byte by5 = this.readAndCheckByte();
        return Ints.fromBytes(by5, by4, by3, by2);
    }

    @Override
    @CanIgnoreReturnValue
    public long readLong() {
        byte by2 = this.readAndCheckByte();
        byte by3 = this.readAndCheckByte();
        byte by4 = this.readAndCheckByte();
        byte by5 = this.readAndCheckByte();
        byte by6 = this.readAndCheckByte();
        byte by7 = this.readAndCheckByte();
        byte by8 = this.readAndCheckByte();
        byte by9 = this.readAndCheckByte();
        return Longs.fromBytes(by9, by8, by7, by6, by5, by4, by3, by2);
    }

    @Override
    @CanIgnoreReturnValue
    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    @CanIgnoreReturnValue
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    @CanIgnoreReturnValue
    public String readUTF() {
        return new DataInputStream(this.in).readUTF();
    }

    @Override
    @CanIgnoreReturnValue
    public short readShort() {
        return (short)this.readUnsignedShort();
    }

    @Override
    @CanIgnoreReturnValue
    public char readChar() {
        return (char)this.readUnsignedShort();
    }

    @Override
    @CanIgnoreReturnValue
    public byte readByte() {
        return (byte)this.readUnsignedByte();
    }

    @Override
    @CanIgnoreReturnValue
    public boolean readBoolean() {
        return this.readUnsignedByte() != 0;
    }

    private byte readAndCheckByte() {
        int n2 = this.in.read();
        if (-1 == n2) {
            throw new EOFException();
        }
        return (byte)n2;
    }
}

