/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.GwtIncompatible;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

@GwtIncompatible
abstract class LineBuffer {
    private StringBuilder line = new StringBuilder();
    private boolean sawReturn;

    LineBuffer() {
    }

    protected void add(char[] cArray, int n2, int n3) {
        int n4 = n2;
        if (this.sawReturn && n3 > 0 && this.finishLine(cArray[n4] == '\n')) {
            ++n4;
        }
        int n5 = n4;
        int n6 = n2 + n3;
        while (n4 < n6) {
            switch (cArray[n4]) {
                case '\r': {
                    this.line.append(cArray, n5, n4 - n5);
                    this.sawReturn = true;
                    if (n4 + 1 < n6 && this.finishLine(cArray[n4 + 1] == '\n')) {
                        ++n4;
                    }
                    n5 = n4 + 1;
                    break;
                }
                case '\n': {
                    this.line.append(cArray, n5, n4 - n5);
                    this.finishLine(true);
                    n5 = n4 + 1;
                    break;
                }
            }
            ++n4;
        }
        this.line.append(cArray, n5, n2 + n3 - n5);
    }

    @CanIgnoreReturnValue
    private boolean finishLine(boolean bl2) {
        String string = this.sawReturn ? (bl2 ? "\r\n" : "\r") : (bl2 ? "\n" : "");
        this.handleLine(this.line.toString(), string);
        this.line = new StringBuilder();
        this.sawReturn = false;
        return bl2;
    }

    protected void finish() {
        if (this.sawReturn || this.line.length() > 0) {
            this.finishLine(false);
        }
    }

    protected abstract void handleLine(String var1, String var2);
}

