/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.TreeTraverser;
import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.common.io.Closer;
import com.google.common.io.FileWriteMode;
import com.google.common.io.LineProcessor;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@GwtIncompatible
public final class Files {
    private static final int TEMP_DIR_ATTEMPTS = 10000;
    private static final TreeTraverser<File> FILE_TREE_TRAVERSER = new TreeTraverser<File>(){

        @Override
        public Iterable<File> children(File file) {
            return Files.fileTreeChildren(file);
        }

        public String toString() {
            return "Files.fileTreeTraverser()";
        }
    };
    private static final SuccessorsFunction<File> FILE_TREE = new SuccessorsFunction<File>(){

        @Override
        public Iterable<File> successors(File file) {
            return Files.fileTreeChildren(file);
        }
    };

    private Files() {
    }

    @Beta
    public static BufferedReader newReader(File file, Charset charset) {
        Preconditions.checkNotNull(file);
        Preconditions.checkNotNull(charset);
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
    }

    @Beta
    public static BufferedWriter newWriter(File file, Charset charset) {
        Preconditions.checkNotNull(file);
        Preconditions.checkNotNull(charset);
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset));
    }

    public static ByteSource asByteSource(File file) {
        return new FileByteSource(file);
    }

    public static ByteSink asByteSink(File file, FileWriteMode ... fileWriteModeArray) {
        return new FileByteSink(file, fileWriteModeArray);
    }

    public static CharSource asCharSource(File file, Charset charset) {
        return Files.asByteSource(file).asCharSource(charset);
    }

    public static CharSink asCharSink(File file, Charset charset, FileWriteMode ... fileWriteModeArray) {
        return Files.asByteSink(file, fileWriteModeArray).asCharSink(charset);
    }

    @Beta
    public static byte[] toByteArray(File file) {
        return Files.asByteSource(file).read();
    }

    @Deprecated
    @Beta
    public static String toString(File file, Charset charset) {
        return Files.asCharSource(file, charset).read();
    }

    @Beta
    public static void write(byte[] byArray, File file) {
        Files.asByteSink(file, new FileWriteMode[0]).write(byArray);
    }

    @Deprecated
    @Beta
    public static void write(CharSequence charSequence, File file, Charset charset) {
        Files.asCharSink(file, charset, new FileWriteMode[0]).write(charSequence);
    }

    @Beta
    public static void copy(File file, OutputStream outputStream) {
        Files.asByteSource(file).copyTo(outputStream);
    }

    @Beta
    public static void copy(File file, File file2) {
        Preconditions.checkArgument(!file.equals(file2), "Source %s and destination %s must be different", (Object)file, (Object)file2);
        Files.asByteSource(file).copyTo(Files.asByteSink(file2, new FileWriteMode[0]));
    }

    @Deprecated
    @Beta
    public static void copy(File file, Charset charset, Appendable appendable) {
        Files.asCharSource(file, charset).copyTo(appendable);
    }

    @Deprecated
    @Beta
    public static void append(CharSequence charSequence, File file, Charset charset) {
        Files.asCharSink(file, charset, FileWriteMode.APPEND).write(charSequence);
    }

    @Beta
    public static boolean equal(File file, File file2) {
        Preconditions.checkNotNull(file);
        Preconditions.checkNotNull(file2);
        if (file == file2 || file.equals(file2)) {
            return true;
        }
        long l2 = file.length();
        long l3 = file2.length();
        if (l2 != 0L && l3 != 0L && l2 != l3) {
            return false;
        }
        return Files.asByteSource(file).contentEquals(Files.asByteSource(file2));
    }

    @Beta
    public static File createTempDir() {
        File file = new File(System.getProperty("java.io.tmpdir"));
        String string = System.currentTimeMillis() + "-";
        for (int i2 = 0; i2 < 10000; ++i2) {
            File file2 = new File(file, string + i2);
            if (!file2.mkdir()) continue;
            return file2;
        }
        throw new IllegalStateException("Failed to create directory within 10000 attempts (tried " + string + "0 to " + string + 9999 + ')');
    }

    @Beta
    public static void touch(File file) {
        Preconditions.checkNotNull(file);
        if (!file.createNewFile() && !file.setLastModified(System.currentTimeMillis())) {
            throw new IOException("Unable to update modification time of " + file);
        }
    }

    @Beta
    public static void createParentDirs(File file) {
        Preconditions.checkNotNull(file);
        File file2 = file.getCanonicalFile().getParentFile();
        if (file2 == null) {
            return;
        }
        file2.mkdirs();
        if (!file2.isDirectory()) {
            throw new IOException("Unable to create parent directories of " + file);
        }
    }

    @Beta
    public static void move(File file, File file2) {
        Preconditions.checkNotNull(file);
        Preconditions.checkNotNull(file2);
        Preconditions.checkArgument(!file.equals(file2), "Source %s and destination %s must be different", (Object)file, (Object)file2);
        if (!file.renameTo(file2)) {
            Files.copy(file, file2);
            if (!file.delete()) {
                if (!file2.delete()) {
                    throw new IOException("Unable to delete " + file2);
                }
                throw new IOException("Unable to delete " + file);
            }
        }
    }

    @Deprecated
    @Beta
    public static String readFirstLine(File file, Charset charset) {
        return Files.asCharSource(file, charset).readFirstLine();
    }

    @Beta
    public static List<String> readLines(File file, Charset charset) {
        return Files.asCharSource(file, charset).readLines(new LineProcessor<List<String>>(){
            final List<String> result = Lists.newArrayList();

            @Override
            public boolean processLine(String string) {
                this.result.add(string);
                return true;
            }

            @Override
            public List<String> getResult() {
                return this.result;
            }
        });
    }

    @Deprecated
    @Beta
    @CanIgnoreReturnValue
    public static <T> T readLines(File file, Charset charset, LineProcessor<T> lineProcessor) {
        return Files.asCharSource(file, charset).readLines(lineProcessor);
    }

    @Deprecated
    @Beta
    @CanIgnoreReturnValue
    public static <T> T readBytes(File file, ByteProcessor<T> byteProcessor) {
        return Files.asByteSource(file).read(byteProcessor);
    }

    @Deprecated
    @Beta
    public static HashCode hash(File file, HashFunction hashFunction) {
        return Files.asByteSource(file).hash(hashFunction);
    }

    @Beta
    public static MappedByteBuffer map(File file) {
        Preconditions.checkNotNull(file);
        return Files.map(file, FileChannel.MapMode.READ_ONLY);
    }

    @Beta
    public static MappedByteBuffer map(File file, FileChannel.MapMode mapMode) {
        return Files.mapInternal(file, mapMode, -1L);
    }

    @Beta
    public static MappedByteBuffer map(File file, FileChannel.MapMode mapMode, long l2) {
        Preconditions.checkArgument(l2 >= 0L, "size (%s) may not be negative", l2);
        return Files.mapInternal(file, mapMode, l2);
    }

    private static MappedByteBuffer mapInternal(File file, FileChannel.MapMode mapMode, long l2) {
        Preconditions.checkNotNull(file);
        Preconditions.checkNotNull(mapMode);
        try (Closer closer = Closer.create();){
            RandomAccessFile randomAccessFile = closer.register(new RandomAccessFile(file, mapMode == FileChannel.MapMode.READ_ONLY ? "r" : "rw"));
            FileChannel fileChannel = closer.register(randomAccessFile.getChannel());
            MappedByteBuffer mappedByteBuffer = fileChannel.map(mapMode, 0L, l2 == -1L ? fileChannel.size() : l2);
            return mappedByteBuffer;
        }
    }

    @Beta
    public static String simplifyPath(String string) {
        Preconditions.checkNotNull(string);
        if (string.length() == 0) {
            return ".";
        }
        Iterable<String> iterable = Splitter.on('/').omitEmptyStrings().split(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = iterable.iterator();
        block8: while (object.hasNext()) {
            String string2;
            switch (string2 = object.next()) {
                case ".": {
                    continue block8;
                }
                case "..": {
                    if (arrayList.size() > 0 && !((String)arrayList.get(arrayList.size() - 1)).equals("..")) {
                        arrayList.remove(arrayList.size() - 1);
                        continue block8;
                    }
                    arrayList.add("..");
                    continue block8;
                }
            }
            arrayList.add(string2);
        }
        object = Joiner.on('/').join(arrayList);
        if (string.charAt(0) == '/') {
            object = "/" + (String)object;
        }
        while (((String)object).startsWith("/../")) {
            object = ((String)object).substring(3);
        }
        if (((String)object).equals("/..")) {
            object = "/";
        } else if ("".equals(object)) {
            object = ".";
        }
        return object;
    }

    @Beta
    public static String getFileExtension(String string) {
        Preconditions.checkNotNull(string);
        String string2 = new File(string).getName();
        int n2 = string2.lastIndexOf(46);
        return n2 == -1 ? "" : string2.substring(n2 + 1);
    }

    @Beta
    public static String getNameWithoutExtension(String string) {
        Preconditions.checkNotNull(string);
        String string2 = new File(string).getName();
        int n2 = string2.lastIndexOf(46);
        return n2 == -1 ? string2 : string2.substring(0, n2);
    }

    @Deprecated
    static TreeTraverser<File> fileTreeTraverser() {
        return FILE_TREE_TRAVERSER;
    }

    @Beta
    public static Traverser<File> fileTraverser() {
        return Traverser.forTree(FILE_TREE);
    }

    private static Iterable<File> fileTreeChildren(File file) {
        File[] fileArray;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            return Collections.unmodifiableList(Arrays.asList(fileArray));
        }
        return Collections.emptyList();
    }

    @Beta
    public static Predicate<File> isDirectory() {
        return FilePredicate.IS_DIRECTORY;
    }

    @Beta
    public static Predicate<File> isFile() {
        return FilePredicate.IS_FILE;
    }

    private static enum FilePredicate implements Predicate<File>
    {
        IS_DIRECTORY{

            @Override
            public boolean apply(File file) {
                return file.isDirectory();
            }

            public String toString() {
                return "Files.isDirectory()";
            }
        }
        ,
        IS_FILE{

            @Override
            public boolean apply(File file) {
                return file.isFile();
            }

            public String toString() {
                return "Files.isFile()";
            }
        };

    }

    private static final class FileByteSink
    extends ByteSink {
        private final File file;
        private final ImmutableSet<FileWriteMode> modes;

        private FileByteSink(File file, FileWriteMode ... fileWriteModeArray) {
            this.file = Preconditions.checkNotNull(file);
            this.modes = ImmutableSet.copyOf(fileWriteModeArray);
        }

        @Override
        public FileOutputStream openStream() {
            return new FileOutputStream(this.file, this.modes.contains((Object)FileWriteMode.APPEND));
        }

        public String toString() {
            return "Files.asByteSink(" + this.file + ", " + this.modes + ")";
        }
    }

    private static final class FileByteSource
    extends ByteSource {
        private final File file;

        private FileByteSource(File file) {
            this.file = Preconditions.checkNotNull(file);
        }

        @Override
        public FileInputStream openStream() {
            return new FileInputStream(this.file);
        }

        @Override
        public Optional<Long> sizeIfKnown() {
            if (this.file.isFile()) {
                return Optional.of(this.file.length());
            }
            return Optional.absent();
        }

        @Override
        public long size() {
            if (!this.file.isFile()) {
                throw new FileNotFoundException(this.file.toString());
            }
            return this.file.length();
        }

        @Override
        public byte[] read() {
            try (Closer closer = Closer.create();){
                FileInputStream fileInputStream = closer.register(this.openStream());
                byte[] byArray = ByteStreams.toByteArray(fileInputStream, fileInputStream.getChannel().size());
                return byArray;
            }
        }

        public String toString() {
            return "Files.asByteSource(" + this.file + ")";
        }
    }
}

