/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.io.AppendableWriter;
import com.google.common.io.LineProcessor;
import com.google.common.io.LineReader;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.EOFException;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;

@GwtIncompatible
public final class CharStreams {
    private static final int DEFAULT_BUF_SIZE = 2048;

    static CharBuffer createBuffer() {
        return CharBuffer.allocate(2048);
    }

    private CharStreams() {
    }

    @CanIgnoreReturnValue
    public static long copy(Readable readable, Appendable appendable) {
        if (readable instanceof Reader) {
            if (appendable instanceof StringBuilder) {
                return CharStreams.copyReaderToBuilder((Reader)readable, (StringBuilder)appendable);
            }
            return CharStreams.copyReaderToWriter((Reader)readable, CharStreams.asWriter(appendable));
        }
        Preconditions.checkNotNull(readable);
        Preconditions.checkNotNull(appendable);
        long l2 = 0L;
        CharBuffer charBuffer = CharStreams.createBuffer();
        while (readable.read(charBuffer) != -1) {
            charBuffer.flip();
            appendable.append(charBuffer);
            l2 += (long)charBuffer.remaining();
            charBuffer.clear();
        }
        return l2;
    }

    @CanIgnoreReturnValue
    static long copyReaderToBuilder(Reader reader, StringBuilder stringBuilder) {
        int n2;
        Preconditions.checkNotNull(reader);
        Preconditions.checkNotNull(stringBuilder);
        char[] cArray = new char[2048];
        long l2 = 0L;
        while ((n2 = reader.read(cArray)) != -1) {
            stringBuilder.append(cArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    @CanIgnoreReturnValue
    static long copyReaderToWriter(Reader reader, Writer writer) {
        int n2;
        Preconditions.checkNotNull(reader);
        Preconditions.checkNotNull(writer);
        char[] cArray = new char[2048];
        long l2 = 0L;
        while ((n2 = reader.read(cArray)) != -1) {
            writer.write(cArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    public static String toString(Readable readable) {
        return CharStreams.toStringBuilder(readable).toString();
    }

    private static StringBuilder toStringBuilder(Readable readable) {
        StringBuilder stringBuilder = new StringBuilder();
        if (readable instanceof Reader) {
            CharStreams.copyReaderToBuilder((Reader)readable, stringBuilder);
        } else {
            CharStreams.copy(readable, stringBuilder);
        }
        return stringBuilder;
    }

    @Beta
    public static List<String> readLines(Readable readable) {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        LineReader lineReader = new LineReader(readable);
        while ((string = lineReader.readLine()) != null) {
            arrayList.add(string);
        }
        return arrayList;
    }

    @Beta
    @CanIgnoreReturnValue
    public static <T> T readLines(Readable readable, LineProcessor<T> lineProcessor) {
        String string;
        Preconditions.checkNotNull(readable);
        Preconditions.checkNotNull(lineProcessor);
        LineReader lineReader = new LineReader(readable);
        while ((string = lineReader.readLine()) != null && lineProcessor.processLine(string)) {
        }
        return lineProcessor.getResult();
    }

    @Beta
    @CanIgnoreReturnValue
    public static long exhaust(Readable readable) {
        long l2;
        long l3 = 0L;
        CharBuffer charBuffer = CharStreams.createBuffer();
        while ((l2 = (long)readable.read(charBuffer)) != -1L) {
            l3 += l2;
            charBuffer.clear();
        }
        return l3;
    }

    @Beta
    public static void skipFully(Reader reader, long l2) {
        Preconditions.checkNotNull(reader);
        while (l2 > 0L) {
            long l3 = reader.skip(l2);
            if (l3 == 0L) {
                throw new EOFException();
            }
            l2 -= l3;
        }
    }

    @Beta
    public static Writer nullWriter() {
        return NullWriter.INSTANCE;
    }

    @Beta
    public static Writer asWriter(Appendable appendable) {
        if (appendable instanceof Writer) {
            return (Writer)appendable;
        }
        return new AppendableWriter(appendable);
    }

    private static final class NullWriter
    extends Writer {
        private static final NullWriter INSTANCE = new NullWriter();

        private NullWriter() {
        }

        @Override
        public void write(int n2) {
        }

        @Override
        public void write(char[] cArray) {
            Preconditions.checkNotNull(cArray);
        }

        @Override
        public void write(char[] cArray, int n2, int n3) {
            Preconditions.checkPositionIndexes(n2, n2 + n3, cArray.length);
        }

        @Override
        public void write(String string) {
            Preconditions.checkNotNull(string);
        }

        @Override
        public void write(String string, int n2, int n3) {
            Preconditions.checkPositionIndexes(n2, n2 + n3, string.length());
        }

        @Override
        public Writer append(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return this;
        }

        @Override
        public Writer append(CharSequence charSequence, int n2, int n3) {
            Preconditions.checkPositionIndexes(n2, n3, charSequence.length());
            return this;
        }

        @Override
        public Writer append(char c2) {
            return this;
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        public String toString() {
            return "CharStreams.nullWriter()";
        }
    }
}

