/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import com.google.common.io.Closer;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.BufferedWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.stream.Stream;

@GwtIncompatible
public abstract class CharSink {
    protected CharSink() {
    }

    public abstract Writer openStream();

    public Writer openBufferedStream() {
        Writer writer = this.openStream();
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
    }

    public void write(CharSequence charSequence) {
        Preconditions.checkNotNull(charSequence);
        try (Closer closer = Closer.create();){
            Writer writer = closer.register(this.openStream());
            writer.append(charSequence);
            writer.flush();
        }
    }

    public void writeLines(Iterable<? extends CharSequence> iterable) {
        this.writeLines(iterable, System.getProperty("line.separator"));
    }

    public void writeLines(Iterable<? extends CharSequence> iterable, String string) {
        this.writeLines(iterable.iterator(), string);
    }

    @Beta
    public void writeLines(Stream<? extends CharSequence> stream) {
        this.writeLines(stream, System.getProperty("line.separator"));
    }

    @Beta
    public void writeLines(Stream<? extends CharSequence> stream, String string) {
        this.writeLines(stream.iterator(), string);
    }

    private void writeLines(Iterator<? extends CharSequence> iterator, String string) {
        Preconditions.checkNotNull(string);
        try (Writer writer = this.openBufferedStream();){
            while (iterator.hasNext()) {
                writer.append(iterator.next()).append(string);
            }
        }
    }

    @CanIgnoreReturnValue
    public long writeFrom(Readable readable) {
        Preconditions.checkNotNull(readable);
        try (Closer closer = Closer.create();){
            Writer writer = closer.register(this.openStream());
            long l2 = CharStreams.copy(readable, writer);
            writer.flush();
            long l3 = l2;
            return l3;
        }
    }
}

