/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteProcessor;
import com.google.common.math.IntMath;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;

@GwtIncompatible
public final class ByteStreams {
    private static final int BUFFER_SIZE = 8192;
    private static final int ZERO_COPY_CHUNK_SIZE = 524288;
    private static final int MAX_ARRAY_LEN = 0x7FFFFFF7;
    private static final int TO_BYTE_ARRAY_DEQUE_SIZE = 20;
    private static final OutputStream NULL_OUTPUT_STREAM = new OutputStream(){

        @Override
        public void write(int n2) {
        }

        @Override
        public void write(byte[] byArray) {
            Preconditions.checkNotNull(byArray);
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) {
            Preconditions.checkNotNull(byArray);
        }

        public String toString() {
            return "ByteStreams.nullOutputStream()";
        }
    };

    static byte[] createBuffer() {
        return new byte[8192];
    }

    private ByteStreams() {
    }

    @CanIgnoreReturnValue
    public static long copy(InputStream inputStream, OutputStream outputStream) {
        int n2;
        Preconditions.checkNotNull(inputStream);
        Preconditions.checkNotNull(outputStream);
        byte[] byArray = ByteStreams.createBuffer();
        long l2 = 0L;
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    @CanIgnoreReturnValue
    public static long copy(ReadableByteChannel readableByteChannel, WritableByteChannel writableByteChannel) {
        Preconditions.checkNotNull(readableByteChannel);
        Preconditions.checkNotNull(writableByteChannel);
        if (readableByteChannel instanceof FileChannel) {
            long l2;
            long l3;
            FileChannel fileChannel = (FileChannel)readableByteChannel;
            long l4 = l3 = fileChannel.position();
            do {
                l2 = fileChannel.transferTo(l4, 524288L, writableByteChannel);
                fileChannel.position(l4 += l2);
            } while (l2 > 0L || l4 < fileChannel.size());
            return l4 - l3;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(ByteStreams.createBuffer());
        long l5 = 0L;
        while (readableByteChannel.read(byteBuffer) != -1) {
            byteBuffer.flip();
            while (byteBuffer.hasRemaining()) {
                l5 += (long)writableByteChannel.write(byteBuffer);
            }
            byteBuffer.clear();
        }
        return l5;
    }

    private static byte[] toByteArrayInternal(InputStream inputStream, Deque<byte[]> deque, int n2) {
        int n3 = 8192;
        while (n2 < 0x7FFFFFF7) {
            byte[] byArray = new byte[Math.min(n3, 0x7FFFFFF7 - n2)];
            deque.add(byArray);
            int n4 = 0;
            while (n4 < byArray.length) {
                int n5 = inputStream.read(byArray, n4, byArray.length - n4);
                if (n5 == -1) {
                    return ByteStreams.combineBuffers(deque, n2);
                }
                n4 += n5;
                n2 += n5;
            }
            n3 = IntMath.saturatedMultiply(n3, 2);
        }
        if (inputStream.read() == -1) {
            return ByteStreams.combineBuffers(deque, 0x7FFFFFF7);
        }
        throw new OutOfMemoryError("input is too large to fit in a byte array");
    }

    private static byte[] combineBuffers(Deque<byte[]> deque, int n2) {
        int n3;
        byte[] byArray = new byte[n2];
        for (int i2 = n2; i2 > 0; i2 -= n3) {
            byte[] byArray2 = deque.removeFirst();
            n3 = Math.min(i2, byArray2.length);
            int n4 = n2 - i2;
            System.arraycopy(byArray2, 0, byArray, n4, n3);
        }
        return byArray;
    }

    public static byte[] toByteArray(InputStream inputStream) {
        Preconditions.checkNotNull(inputStream);
        return ByteStreams.toByteArrayInternal(inputStream, new ArrayDeque<byte[]>(20), 0);
    }

    static byte[] toByteArray(InputStream inputStream, long l2) {
        int n2;
        int n3;
        Preconditions.checkArgument(l2 >= 0L, "expectedSize (%s) must be non-negative", l2);
        if (l2 > 0x7FFFFFF7L) {
            throw new OutOfMemoryError(l2 + " bytes is too large to fit in a byte array");
        }
        byte[] byArray = new byte[(int)l2];
        for (int i2 = (int)l2; i2 > 0; i2 -= n3) {
            n2 = (int)l2 - i2;
            n3 = inputStream.read(byArray, n2, i2);
            if (n3 != -1) continue;
            return Arrays.copyOf(byArray, n2);
        }
        n2 = inputStream.read();
        if (n2 == -1) {
            return byArray;
        }
        ArrayDeque<byte[]> arrayDeque = new ArrayDeque<byte[]>(22);
        arrayDeque.add(byArray);
        arrayDeque.add(new byte[]{(byte)n2});
        return ByteStreams.toByteArrayInternal(inputStream, arrayDeque, byArray.length + 1);
    }

    @CanIgnoreReturnValue
    @Beta
    public static long exhaust(InputStream inputStream) {
        long l2;
        long l3 = 0L;
        byte[] byArray = ByteStreams.createBuffer();
        while ((l2 = (long)inputStream.read(byArray)) != -1L) {
            l3 += l2;
        }
        return l3;
    }

    @Beta
    public static ByteArrayDataInput newDataInput(byte[] byArray) {
        return ByteStreams.newDataInput(new ByteArrayInputStream(byArray));
    }

    @Beta
    public static ByteArrayDataInput newDataInput(byte[] byArray, int n2) {
        Preconditions.checkPositionIndex(n2, byArray.length);
        return ByteStreams.newDataInput(new ByteArrayInputStream(byArray, n2, byArray.length - n2));
    }

    @Beta
    public static ByteArrayDataInput newDataInput(ByteArrayInputStream byteArrayInputStream) {
        return new ByteArrayDataInputStream(Preconditions.checkNotNull(byteArrayInputStream));
    }

    @Beta
    public static ByteArrayDataOutput newDataOutput() {
        return ByteStreams.newDataOutput(new ByteArrayOutputStream());
    }

    @Beta
    public static ByteArrayDataOutput newDataOutput(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(String.format("Invalid size: %s", n2));
        }
        return ByteStreams.newDataOutput(new ByteArrayOutputStream(n2));
    }

    @Beta
    public static ByteArrayDataOutput newDataOutput(ByteArrayOutputStream byteArrayOutputStream) {
        return new ByteArrayDataOutputStream(Preconditions.checkNotNull(byteArrayOutputStream));
    }

    @Beta
    public static OutputStream nullOutputStream() {
        return NULL_OUTPUT_STREAM;
    }

    @Beta
    public static InputStream limit(InputStream inputStream, long l2) {
        return new LimitedInputStream(inputStream, l2);
    }

    @Beta
    public static void readFully(InputStream inputStream, byte[] byArray) {
        ByteStreams.readFully(inputStream, byArray, 0, byArray.length);
    }

    @Beta
    public static void readFully(InputStream inputStream, byte[] byArray, int n2, int n3) {
        int n4 = ByteStreams.read(inputStream, byArray, n2, n3);
        if (n4 != n3) {
            throw new EOFException("reached end of stream after reading " + n4 + " bytes; " + n3 + " bytes expected");
        }
    }

    @Beta
    public static void skipFully(InputStream inputStream, long l2) {
        long l3 = ByteStreams.skipUpTo(inputStream, l2);
        if (l3 < l2) {
            throw new EOFException("reached end of stream after skipping " + l3 + " bytes; " + l2 + " bytes expected");
        }
    }

    static long skipUpTo(InputStream inputStream, long l2) {
        int n2;
        long l3;
        long l4;
        long l5;
        byte[] byArray = ByteStreams.createBuffer();
        for (l4 = 0L; l4 < l2 && ((l5 = ByteStreams.skipSafely(inputStream, l3 = l2 - l4)) != 0L || (l5 = (long)inputStream.read(byArray, 0, n2 = (int)Math.min(l3, (long)byArray.length))) != -1L); l4 += l5) {
        }
        return l4;
    }

    private static long skipSafely(InputStream inputStream, long l2) {
        int n2 = inputStream.available();
        return n2 == 0 ? 0L : inputStream.skip(Math.min((long)n2, l2));
    }

    @Beta
    @CanIgnoreReturnValue
    public static <T> T readBytes(InputStream inputStream, ByteProcessor<T> byteProcessor) {
        int n2;
        Preconditions.checkNotNull(inputStream);
        Preconditions.checkNotNull(byteProcessor);
        byte[] byArray = ByteStreams.createBuffer();
        while ((n2 = inputStream.read(byArray)) != -1 && byteProcessor.processBytes(byArray, 0, n2)) {
        }
        return byteProcessor.getResult();
    }

    @Beta
    @CanIgnoreReturnValue
    public static int read(InputStream inputStream, byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        Preconditions.checkNotNull(inputStream);
        Preconditions.checkNotNull(byArray);
        if (n3 < 0) {
            throw new IndexOutOfBoundsException("len is negative");
        }
        for (n4 = 0; n4 < n3 && (n5 = inputStream.read(byArray, n2 + n4, n3 - n4)) != -1; n4 += n5) {
        }
        return n4;
    }

    private static final class LimitedInputStream
    extends FilterInputStream {
        private long left;
        private long mark = -1L;

        LimitedInputStream(InputStream inputStream, long l2) {
            super(inputStream);
            Preconditions.checkNotNull(inputStream);
            Preconditions.checkArgument(l2 >= 0L, "limit must be non-negative");
            this.left = l2;
        }

        @Override
        public int available() {
            return (int)Math.min((long)this.in.available(), this.left);
        }

        @Override
        public synchronized void mark(int n2) {
            this.in.mark(n2);
            this.mark = this.left;
        }

        @Override
        public int read() {
            if (this.left == 0L) {
                return -1;
            }
            int n2 = this.in.read();
            if (n2 != -1) {
                --this.left;
            }
            return n2;
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) {
            if (this.left == 0L) {
                return -1;
            }
            int n4 = this.in.read(byArray, n2, n3 = (int)Math.min((long)n3, this.left));
            if (n4 != -1) {
                this.left -= (long)n4;
            }
            return n4;
        }

        @Override
        public synchronized void reset() {
            if (!this.in.markSupported()) {
                throw new IOException("Mark not supported");
            }
            if (this.mark == -1L) {
                throw new IOException("Mark not set");
            }
            this.in.reset();
            this.left = this.mark;
        }

        @Override
        public long skip(long l2) {
            l2 = Math.min(l2, this.left);
            long l3 = this.in.skip(l2);
            this.left -= l3;
            return l3;
        }
    }

    private static class ByteArrayDataOutputStream
    implements ByteArrayDataOutput {
        final DataOutput output;
        final ByteArrayOutputStream byteArrayOutputSteam;

        ByteArrayDataOutputStream(ByteArrayOutputStream byteArrayOutputStream) {
            this.byteArrayOutputSteam = byteArrayOutputStream;
            this.output = new DataOutputStream(byteArrayOutputStream);
        }

        @Override
        public void write(int n2) {
            try {
                this.output.write(n2);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void write(byte[] byArray) {
            try {
                this.output.write(byArray);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) {
            try {
                this.output.write(byArray, n2, n3);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeBoolean(boolean bl2) {
            try {
                this.output.writeBoolean(bl2);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeByte(int n2) {
            try {
                this.output.writeByte(n2);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeBytes(String string) {
            try {
                this.output.writeBytes(string);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeChar(int n2) {
            try {
                this.output.writeChar(n2);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeChars(String string) {
            try {
                this.output.writeChars(string);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeDouble(double d2) {
            try {
                this.output.writeDouble(d2);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeFloat(float f2) {
            try {
                this.output.writeFloat(f2);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeInt(int n2) {
            try {
                this.output.writeInt(n2);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeLong(long l2) {
            try {
                this.output.writeLong(l2);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeShort(int n2) {
            try {
                this.output.writeShort(n2);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public void writeUTF(String string) {
            try {
                this.output.writeUTF(string);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public byte[] toByteArray() {
            return this.byteArrayOutputSteam.toByteArray();
        }
    }

    private static class ByteArrayDataInputStream
    implements ByteArrayDataInput {
        final DataInput input;

        ByteArrayDataInputStream(ByteArrayInputStream byteArrayInputStream) {
            this.input = new DataInputStream(byteArrayInputStream);
        }

        @Override
        public void readFully(byte[] byArray) {
            try {
                this.input.readFully(byArray);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public void readFully(byte[] byArray, int n2, int n3) {
            try {
                this.input.readFully(byArray, n2, n3);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public int skipBytes(int n2) {
            try {
                return this.input.skipBytes(n2);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public boolean readBoolean() {
            try {
                return this.input.readBoolean();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public byte readByte() {
            try {
                return this.input.readByte();
            }
            catch (EOFException eOFException) {
                throw new IllegalStateException(eOFException);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }

        @Override
        public int readUnsignedByte() {
            try {
                return this.input.readUnsignedByte();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public short readShort() {
            try {
                return this.input.readShort();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public int readUnsignedShort() {
            try {
                return this.input.readUnsignedShort();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public char readChar() {
            try {
                return this.input.readChar();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public int readInt() {
            try {
                return this.input.readInt();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public long readLong() {
            try {
                return this.input.readLong();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public float readFloat() {
            try {
                return this.input.readFloat();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public double readDouble() {
            try {
                return this.input.readDouble();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public String readLine() {
            try {
                return this.input.readLine();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        @Override
        public String readUTF() {
            try {
                return this.input.readUTF();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
    }
}

