/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Ascii;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.common.math.IntMath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.RoundingMode;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(emulated=true)
public abstract class BaseEncoding {
    private static final BaseEncoding BASE64 = new Base64Encoding("base64()", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/", Character.valueOf('='));
    private static final BaseEncoding BASE64_URL = new Base64Encoding("base64Url()", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_", Character.valueOf('='));
    private static final BaseEncoding BASE32 = new StandardBaseEncoding("base32()", "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567", Character.valueOf('='));
    private static final BaseEncoding BASE32_HEX = new StandardBaseEncoding("base32Hex()", "0123456789ABCDEFGHIJKLMNOPQRSTUV", Character.valueOf('='));
    private static final BaseEncoding BASE16 = new Base16Encoding("base16()", "0123456789ABCDEF");

    BaseEncoding() {
    }

    public String encode(byte[] byArray) {
        return this.encode(byArray, 0, byArray.length);
    }

    public final String encode(byte[] byArray, int n2, int n3) {
        Preconditions.checkPositionIndexes(n2, n2 + n3, byArray.length);
        StringBuilder stringBuilder = new StringBuilder(this.maxEncodedSize(n3));
        try {
            this.encodeTo(stringBuilder, byArray, n2, n3);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        return stringBuilder.toString();
    }

    @GwtIncompatible
    public abstract OutputStream encodingStream(Writer var1);

    @GwtIncompatible
    public final ByteSink encodingSink(final CharSink charSink) {
        Preconditions.checkNotNull(charSink);
        return new ByteSink(){

            @Override
            public OutputStream openStream() {
                return BaseEncoding.this.encodingStream(charSink.openStream());
            }
        };
    }

    private static byte[] extract(byte[] byArray, int n2) {
        if (n2 == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public abstract boolean canDecode(CharSequence var1);

    public final byte[] decode(CharSequence charSequence) {
        try {
            return this.decodeChecked(charSequence);
        }
        catch (DecodingException decodingException) {
            throw new IllegalArgumentException(decodingException);
        }
    }

    final byte[] decodeChecked(CharSequence charSequence) {
        charSequence = this.trimTrailingPadding(charSequence);
        byte[] byArray = new byte[this.maxDecodedSize(charSequence.length())];
        int n2 = this.decodeTo(byArray, charSequence);
        return BaseEncoding.extract(byArray, n2);
    }

    @GwtIncompatible
    public abstract InputStream decodingStream(Reader var1);

    @GwtIncompatible
    public final ByteSource decodingSource(final CharSource charSource) {
        Preconditions.checkNotNull(charSource);
        return new ByteSource(){

            @Override
            public InputStream openStream() {
                return BaseEncoding.this.decodingStream(charSource.openStream());
            }
        };
    }

    abstract int maxEncodedSize(int var1);

    abstract void encodeTo(Appendable var1, byte[] var2, int var3, int var4);

    abstract int maxDecodedSize(int var1);

    abstract int decodeTo(byte[] var1, CharSequence var2);

    CharSequence trimTrailingPadding(CharSequence charSequence) {
        return Preconditions.checkNotNull(charSequence);
    }

    public abstract BaseEncoding omitPadding();

    public abstract BaseEncoding withPadChar(char var1);

    public abstract BaseEncoding withSeparator(String var1, int var2);

    public abstract BaseEncoding upperCase();

    public abstract BaseEncoding lowerCase();

    public static BaseEncoding base64() {
        return BASE64;
    }

    public static BaseEncoding base64Url() {
        return BASE64_URL;
    }

    public static BaseEncoding base32() {
        return BASE32;
    }

    public static BaseEncoding base32Hex() {
        return BASE32_HEX;
    }

    public static BaseEncoding base16() {
        return BASE16;
    }

    @GwtIncompatible
    static Reader ignoringReader(final Reader reader, final String string) {
        Preconditions.checkNotNull(reader);
        Preconditions.checkNotNull(string);
        return new Reader(){

            @Override
            public int read() {
                int n2;
                while ((n2 = reader.read()) != -1 && string.indexOf((char)n2) >= 0) {
                }
                return n2;
            }

            @Override
            public int read(char[] cArray, int n2, int n3) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
                reader.close();
            }
        };
    }

    static Appendable separatingAppendable(final Appendable appendable, final String string, final int n2) {
        Preconditions.checkNotNull(appendable);
        Preconditions.checkNotNull(string);
        Preconditions.checkArgument(n2 > 0);
        return new Appendable(){
            int charsUntilSeparator;
            {
                this.charsUntilSeparator = n2;
            }

            @Override
            public Appendable append(char c2) {
                if (this.charsUntilSeparator == 0) {
                    appendable.append(string);
                    this.charsUntilSeparator = n2;
                }
                appendable.append(c2);
                --this.charsUntilSeparator;
                return this;
            }

            @Override
            public Appendable append(@Nullable CharSequence charSequence, int n22, int n3) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Appendable append(@Nullable CharSequence charSequence) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @GwtIncompatible
    static Writer separatingWriter(final Writer writer, String string, int n2) {
        final Appendable appendable = BaseEncoding.separatingAppendable(writer, string, n2);
        return new Writer(){

            @Override
            public void write(int n2) {
                appendable.append((char)n2);
            }

            @Override
            public void write(char[] cArray, int n2, int n3) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void flush() {
                writer.flush();
            }

            @Override
            public void close() {
                writer.close();
            }
        };
    }

    static final class SeparatedBaseEncoding
    extends BaseEncoding {
        private final BaseEncoding delegate;
        private final String separator;
        private final int afterEveryChars;

        SeparatedBaseEncoding(BaseEncoding baseEncoding, String string, int n2) {
            this.delegate = Preconditions.checkNotNull(baseEncoding);
            this.separator = Preconditions.checkNotNull(string);
            this.afterEveryChars = n2;
            Preconditions.checkArgument(n2 > 0, "Cannot add a separator after every %s chars", n2);
        }

        @Override
        CharSequence trimTrailingPadding(CharSequence charSequence) {
            return this.delegate.trimTrailingPadding(charSequence);
        }

        @Override
        int maxEncodedSize(int n2) {
            int n3 = this.delegate.maxEncodedSize(n2);
            return n3 + this.separator.length() * IntMath.divide(Math.max(0, n3 - 1), this.afterEveryChars, RoundingMode.FLOOR);
        }

        @Override
        @GwtIncompatible
        public OutputStream encodingStream(Writer writer) {
            return this.delegate.encodingStream(SeparatedBaseEncoding.separatingWriter(writer, this.separator, this.afterEveryChars));
        }

        @Override
        void encodeTo(Appendable appendable, byte[] byArray, int n2, int n3) {
            this.delegate.encodeTo(SeparatedBaseEncoding.separatingAppendable(appendable, this.separator, this.afterEveryChars), byArray, n2, n3);
        }

        @Override
        int maxDecodedSize(int n2) {
            return this.delegate.maxDecodedSize(n2);
        }

        @Override
        public boolean canDecode(CharSequence charSequence) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                char c2 = charSequence.charAt(i2);
                if (this.separator.indexOf(c2) >= 0) continue;
                stringBuilder.append(c2);
            }
            return this.delegate.canDecode(stringBuilder);
        }

        @Override
        int decodeTo(byte[] byArray, CharSequence charSequence) {
            StringBuilder stringBuilder = new StringBuilder(charSequence.length());
            for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                char c2 = charSequence.charAt(i2);
                if (this.separator.indexOf(c2) >= 0) continue;
                stringBuilder.append(c2);
            }
            return this.delegate.decodeTo(byArray, stringBuilder);
        }

        @Override
        @GwtIncompatible
        public InputStream decodingStream(Reader reader) {
            return this.delegate.decodingStream(SeparatedBaseEncoding.ignoringReader(reader, this.separator));
        }

        @Override
        public BaseEncoding omitPadding() {
            return this.delegate.omitPadding().withSeparator(this.separator, this.afterEveryChars);
        }

        @Override
        public BaseEncoding withPadChar(char c2) {
            return this.delegate.withPadChar(c2).withSeparator(this.separator, this.afterEveryChars);
        }

        @Override
        public BaseEncoding withSeparator(String string, int n2) {
            throw new UnsupportedOperationException("Already have a separator");
        }

        @Override
        public BaseEncoding upperCase() {
            return this.delegate.upperCase().withSeparator(this.separator, this.afterEveryChars);
        }

        @Override
        public BaseEncoding lowerCase() {
            return this.delegate.lowerCase().withSeparator(this.separator, this.afterEveryChars);
        }

        public String toString() {
            return this.delegate + ".withSeparator(\"" + this.separator + "\", " + this.afterEveryChars + ")";
        }
    }

    static final class Base64Encoding
    extends StandardBaseEncoding {
        Base64Encoding(String string, String string2, @Nullable Character c2) {
            this(new Alphabet(string, string2.toCharArray()), c2);
        }

        private Base64Encoding(Alphabet alphabet, @Nullable Character c2) {
            super(alphabet, c2);
            Preconditions.checkArgument(alphabet.chars.length == 64);
        }

        @Override
        void encodeTo(Appendable appendable, byte[] byArray, int n2, int n3) {
            Preconditions.checkNotNull(appendable);
            Preconditions.checkPositionIndexes(n2, n2 + n3, byArray.length);
            int n4 = n2;
            for (int i2 = n3; i2 >= 3; i2 -= 3) {
                int n5 = (byArray[n4++] & 0xFF) << 16 | (byArray[n4++] & 0xFF) << 8 | byArray[n4++] & 0xFF;
                appendable.append(this.alphabet.encode(n5 >>> 18));
                appendable.append(this.alphabet.encode(n5 >>> 12 & 0x3F));
                appendable.append(this.alphabet.encode(n5 >>> 6 & 0x3F));
                appendable.append(this.alphabet.encode(n5 & 0x3F));
            }
            if (n4 < n2 + n3) {
                this.encodeChunkTo(appendable, byArray, n4, n2 + n3 - n4);
            }
        }

        @Override
        int decodeTo(byte[] byArray, CharSequence charSequence) {
            Preconditions.checkNotNull(byArray);
            charSequence = this.trimTrailingPadding(charSequence);
            if (!this.alphabet.isValidPaddingStartPosition(charSequence.length())) {
                throw new DecodingException("Invalid input length " + charSequence.length());
            }
            int n2 = 0;
            int n3 = 0;
            while (n3 < charSequence.length()) {
                int n4 = this.alphabet.decode(charSequence.charAt(n3++)) << 18;
                byArray[n2++] = (byte)((n4 |= this.alphabet.decode(charSequence.charAt(n3++)) << 12) >>> 16);
                if (n3 >= charSequence.length()) continue;
                byArray[n2++] = (byte)((n4 |= this.alphabet.decode(charSequence.charAt(n3++)) << 6) >>> 8 & 0xFF);
                if (n3 >= charSequence.length()) continue;
                byArray[n2++] = (byte)((n4 |= this.alphabet.decode(charSequence.charAt(n3++))) & 0xFF);
            }
            return n2;
        }

        @Override
        BaseEncoding newInstance(Alphabet alphabet, @Nullable Character c2) {
            return new Base64Encoding(alphabet, c2);
        }
    }

    static final class Base16Encoding
    extends StandardBaseEncoding {
        final char[] encoding = new char[512];

        Base16Encoding(String string, String string2) {
            this(new Alphabet(string, string2.toCharArray()));
        }

        private Base16Encoding(Alphabet alphabet) {
            super(alphabet, null);
            Preconditions.checkArgument(alphabet.chars.length == 16);
            for (int i2 = 0; i2 < 256; ++i2) {
                this.encoding[i2] = alphabet.encode(i2 >>> 4);
                this.encoding[i2 | 0x100] = alphabet.encode(i2 & 0xF);
            }
        }

        @Override
        void encodeTo(Appendable appendable, byte[] byArray, int n2, int n3) {
            Preconditions.checkNotNull(appendable);
            Preconditions.checkPositionIndexes(n2, n2 + n3, byArray.length);
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = byArray[n2 + i2] & 0xFF;
                appendable.append(this.encoding[n4]);
                appendable.append(this.encoding[n4 | 0x100]);
            }
        }

        @Override
        int decodeTo(byte[] byArray, CharSequence charSequence) {
            Preconditions.checkNotNull(byArray);
            if (charSequence.length() % 2 == 1) {
                throw new DecodingException("Invalid input length " + charSequence.length());
            }
            int n2 = 0;
            for (int i2 = 0; i2 < charSequence.length(); i2 += 2) {
                int n3 = this.alphabet.decode(charSequence.charAt(i2)) << 4 | this.alphabet.decode(charSequence.charAt(i2 + 1));
                byArray[n2++] = (byte)n3;
            }
            return n2;
        }

        @Override
        BaseEncoding newInstance(Alphabet alphabet, @Nullable Character c2) {
            return new Base16Encoding(alphabet);
        }
    }

    static class StandardBaseEncoding
    extends BaseEncoding {
        final Alphabet alphabet;
        final @Nullable Character paddingChar;
        private transient @MonotonicNonNull BaseEncoding upperCase;
        private transient @MonotonicNonNull BaseEncoding lowerCase;

        StandardBaseEncoding(String string, String string2, @Nullable Character c2) {
            this(new Alphabet(string, string2.toCharArray()), c2);
        }

        StandardBaseEncoding(Alphabet alphabet, @Nullable Character c2) {
            this.alphabet = Preconditions.checkNotNull(alphabet);
            Preconditions.checkArgument(c2 == null || !alphabet.matches(c2.charValue()), "Padding character %s was already in alphabet", (Object)c2);
            this.paddingChar = c2;
        }

        @Override
        int maxEncodedSize(int n2) {
            return this.alphabet.charsPerChunk * IntMath.divide(n2, this.alphabet.bytesPerChunk, RoundingMode.CEILING);
        }

        @Override
        @GwtIncompatible
        public OutputStream encodingStream(final Writer writer) {
            Preconditions.checkNotNull(writer);
            return new OutputStream(){
                int bitBuffer = 0;
                int bitBufferLength = 0;
                int writtenChars = 0;

                @Override
                public void write(int n2) {
                    this.bitBuffer <<= 8;
                    this.bitBuffer |= n2 & 0xFF;
                    this.bitBufferLength += 8;
                    while (this.bitBufferLength >= alphabet.bitsPerChar) {
                        int n3 = this.bitBuffer >> this.bitBufferLength - alphabet.bitsPerChar & alphabet.mask;
                        writer.write(alphabet.encode(n3));
                        ++this.writtenChars;
                        this.bitBufferLength -= alphabet.bitsPerChar;
                    }
                }

                @Override
                public void flush() {
                    writer.flush();
                }

                @Override
                public void close() {
                    if (this.bitBufferLength > 0) {
                        int n2 = this.bitBuffer << alphabet.bitsPerChar - this.bitBufferLength & alphabet.mask;
                        writer.write(alphabet.encode(n2));
                        ++this.writtenChars;
                        if (paddingChar != null) {
                            while (this.writtenChars % alphabet.charsPerChunk != 0) {
                                writer.write(paddingChar.charValue());
                                ++this.writtenChars;
                            }
                        }
                    }
                    writer.close();
                }
            };
        }

        @Override
        void encodeTo(Appendable appendable, byte[] byArray, int n2, int n3) {
            Preconditions.checkNotNull(appendable);
            Preconditions.checkPositionIndexes(n2, n2 + n3, byArray.length);
            for (int i2 = 0; i2 < n3; i2 += this.alphabet.bytesPerChunk) {
                this.encodeChunkTo(appendable, byArray, n2 + i2, Math.min(this.alphabet.bytesPerChunk, n3 - i2));
            }
        }

        void encodeChunkTo(Appendable appendable, byte[] byArray, int n2, int n3) {
            int n4;
            int n5;
            Preconditions.checkNotNull(appendable);
            Preconditions.checkPositionIndexes(n2, n2 + n3, byArray.length);
            Preconditions.checkArgument(n3 <= this.alphabet.bytesPerChunk);
            long l2 = 0L;
            for (n5 = 0; n5 < n3; ++n5) {
                l2 |= (long)(byArray[n2 + n5] & 0xFF);
                l2 <<= 8;
            }
            n5 = (n3 + 1) * 8 - this.alphabet.bitsPerChar;
            for (n4 = 0; n4 < n3 * 8; n4 += this.alphabet.bitsPerChar) {
                int n6 = (int)(l2 >>> n5 - n4) & this.alphabet.mask;
                appendable.append(this.alphabet.encode(n6));
            }
            if (this.paddingChar != null) {
                while (n4 < this.alphabet.bytesPerChunk * 8) {
                    appendable.append(this.paddingChar.charValue());
                    n4 += this.alphabet.bitsPerChar;
                }
            }
        }

        @Override
        int maxDecodedSize(int n2) {
            return (int)(((long)this.alphabet.bitsPerChar * (long)n2 + 7L) / 8L);
        }

        @Override
        CharSequence trimTrailingPadding(CharSequence charSequence) {
            int n2;
            Preconditions.checkNotNull(charSequence);
            if (this.paddingChar == null) {
                return charSequence;
            }
            char c2 = this.paddingChar.charValue();
            for (n2 = charSequence.length() - 1; n2 >= 0 && charSequence.charAt(n2) == c2; --n2) {
            }
            return charSequence.subSequence(0, n2 + 1);
        }

        @Override
        public boolean canDecode(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            charSequence = this.trimTrailingPadding(charSequence);
            if (!this.alphabet.isValidPaddingStartPosition(charSequence.length())) {
                return false;
            }
            for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                if (this.alphabet.canDecode(charSequence.charAt(i2))) continue;
                return false;
            }
            return true;
        }

        @Override
        int decodeTo(byte[] byArray, CharSequence charSequence) {
            Preconditions.checkNotNull(byArray);
            charSequence = this.trimTrailingPadding(charSequence);
            if (!this.alphabet.isValidPaddingStartPosition(charSequence.length())) {
                throw new DecodingException("Invalid input length " + charSequence.length());
            }
            int n2 = 0;
            for (int i2 = 0; i2 < charSequence.length(); i2 += this.alphabet.charsPerChunk) {
                int n3;
                long l2 = 0L;
                int n4 = 0;
                for (n3 = 0; n3 < this.alphabet.charsPerChunk; ++n3) {
                    l2 <<= this.alphabet.bitsPerChar;
                    if (i2 + n3 >= charSequence.length()) continue;
                    l2 |= (long)this.alphabet.decode(charSequence.charAt(i2 + n4++));
                }
                n3 = this.alphabet.bytesPerChunk * 8 - n4 * this.alphabet.bitsPerChar;
                for (int i3 = (this.alphabet.bytesPerChunk - 1) * 8; i3 >= n3; i3 -= 8) {
                    byArray[n2++] = (byte)(l2 >>> i3 & 0xFFL);
                }
            }
            return n2;
        }

        @Override
        @GwtIncompatible
        public InputStream decodingStream(final Reader reader) {
            Preconditions.checkNotNull(reader);
            return new InputStream(){
                int bitBuffer = 0;
                int bitBufferLength = 0;
                int readChars = 0;
                boolean hitPadding = false;

                @Override
                public int read() {
                    while (true) {
                        int n2;
                        if ((n2 = reader.read()) == -1) {
                            if (!this.hitPadding && !alphabet.isValidPaddingStartPosition(this.readChars)) {
                                throw new DecodingException("Invalid input length " + this.readChars);
                            }
                            return -1;
                        }
                        ++this.readChars;
                        char c2 = (char)n2;
                        if (paddingChar != null && paddingChar.charValue() == c2) {
                            if (!(this.hitPadding || this.readChars != 1 && alphabet.isValidPaddingStartPosition(this.readChars - 1))) {
                                throw new DecodingException("Padding cannot start at index " + this.readChars);
                            }
                            this.hitPadding = true;
                            continue;
                        }
                        if (this.hitPadding) {
                            throw new DecodingException("Expected padding character but found '" + c2 + "' at index " + this.readChars);
                        }
                        this.bitBuffer <<= alphabet.bitsPerChar;
                        this.bitBuffer |= alphabet.decode(c2);
                        this.bitBufferLength += alphabet.bitsPerChar;
                        if (this.bitBufferLength >= 8) break;
                    }
                    this.bitBufferLength -= 8;
                    return this.bitBuffer >> this.bitBufferLength & 0xFF;
                }

                @Override
                public int read(byte[] byArray, int n2, int n3) {
                    int n4;
                    Preconditions.checkPositionIndexes(n2, n2 + n3, byArray.length);
                    for (n4 = n2; n4 < n2 + n3; ++n4) {
                        int n5 = this.read();
                        if (n5 == -1) {
                            int n6 = n4 - n2;
                            return n6 == 0 ? -1 : n6;
                        }
                        byArray[n4] = (byte)n5;
                    }
                    return n4 - n2;
                }

                @Override
                public void close() {
                    reader.close();
                }
            };
        }

        @Override
        public BaseEncoding omitPadding() {
            return this.paddingChar == null ? this : this.newInstance(this.alphabet, null);
        }

        @Override
        public BaseEncoding withPadChar(char c2) {
            if (8 % this.alphabet.bitsPerChar == 0 || this.paddingChar != null && this.paddingChar.charValue() == c2) {
                return this;
            }
            return this.newInstance(this.alphabet, Character.valueOf(c2));
        }

        @Override
        public BaseEncoding withSeparator(String string, int n2) {
            for (int i2 = 0; i2 < string.length(); ++i2) {
                Preconditions.checkArgument(!this.alphabet.matches(string.charAt(i2)), "Separator (%s) cannot contain alphabet characters", (Object)string);
            }
            if (this.paddingChar != null) {
                Preconditions.checkArgument(string.indexOf(this.paddingChar.charValue()) < 0, "Separator (%s) cannot contain padding character", (Object)string);
            }
            return new SeparatedBaseEncoding(this, string, n2);
        }

        @Override
        public BaseEncoding upperCase() {
            BaseEncoding baseEncoding = this.upperCase;
            if (baseEncoding == null) {
                Alphabet alphabet = this.alphabet.upperCase();
                this.upperCase = alphabet == this.alphabet ? this : this.newInstance(alphabet, this.paddingChar);
                baseEncoding = this.upperCase;
            }
            return baseEncoding;
        }

        @Override
        public BaseEncoding lowerCase() {
            BaseEncoding baseEncoding = this.lowerCase;
            if (baseEncoding == null) {
                Alphabet alphabet = this.alphabet.lowerCase();
                this.lowerCase = alphabet == this.alphabet ? this : this.newInstance(alphabet, this.paddingChar);
                baseEncoding = this.lowerCase;
            }
            return baseEncoding;
        }

        BaseEncoding newInstance(Alphabet alphabet, @Nullable Character c2) {
            return new StandardBaseEncoding(alphabet, c2);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("BaseEncoding.");
            stringBuilder.append(this.alphabet.toString());
            if (8 % this.alphabet.bitsPerChar != 0) {
                if (this.paddingChar == null) {
                    stringBuilder.append(".omitPadding()");
                } else {
                    stringBuilder.append(".withPadChar('").append(this.paddingChar).append("')");
                }
            }
            return stringBuilder.toString();
        }

        public boolean equals(@Nullable Object object) {
            if (object instanceof StandardBaseEncoding) {
                StandardBaseEncoding standardBaseEncoding = (StandardBaseEncoding)object;
                return this.alphabet.equals(standardBaseEncoding.alphabet) && Objects.equal(this.paddingChar, standardBaseEncoding.paddingChar);
            }
            return false;
        }

        public int hashCode() {
            return this.alphabet.hashCode() ^ Objects.hashCode(this.paddingChar);
        }
    }

    private static final class Alphabet {
        private final String name;
        private final char[] chars;
        final int mask;
        final int bitsPerChar;
        final int charsPerChunk;
        final int bytesPerChunk;
        private final byte[] decodabet;
        private final boolean[] validPadding;

        Alphabet(String string, char[] cArray) {
            int n2;
            this.name = Preconditions.checkNotNull(string);
            this.chars = Preconditions.checkNotNull(cArray);
            try {
                this.bitsPerChar = IntMath.log2(cArray.length, RoundingMode.UNNECESSARY);
            }
            catch (ArithmeticException arithmeticException) {
                throw new IllegalArgumentException("Illegal alphabet length " + cArray.length, arithmeticException);
            }
            int n3 = Math.min(8, Integer.lowestOneBit(this.bitsPerChar));
            try {
                this.charsPerChunk = 8 / n3;
                this.bytesPerChunk = this.bitsPerChar / n3;
            }
            catch (ArithmeticException arithmeticException) {
                throw new IllegalArgumentException("Illegal alphabet " + new String(cArray), arithmeticException);
            }
            this.mask = cArray.length - 1;
            byte[] byArray = new byte[128];
            Arrays.fill(byArray, (byte)-1);
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                n2 = cArray[i2];
                Preconditions.checkArgument(n2 < byArray.length, "Non-ASCII character: %s", (char)n2);
                Preconditions.checkArgument(byArray[n2] == -1, "Duplicate character: %s", (char)n2);
                byArray[n2] = (byte)i2;
            }
            this.decodabet = byArray;
            boolean[] blArray = new boolean[this.charsPerChunk];
            for (n2 = 0; n2 < this.bytesPerChunk; ++n2) {
                blArray[IntMath.divide((int)(n2 * 8), (int)this.bitsPerChar, (RoundingMode)RoundingMode.CEILING)] = true;
            }
            this.validPadding = blArray;
        }

        char encode(int n2) {
            return this.chars[n2];
        }

        boolean isValidPaddingStartPosition(int n2) {
            return this.validPadding[n2 % this.charsPerChunk];
        }

        boolean canDecode(char c2) {
            return c2 <= '\u007f' && this.decodabet[c2] != -1;
        }

        int decode(char c2) {
            if (c2 > '\u007f') {
                throw new DecodingException("Unrecognized character: 0x" + Integer.toHexString(c2));
            }
            byte by2 = this.decodabet[c2];
            if (by2 == -1) {
                if (c2 <= ' ' || c2 == '\u007f') {
                    throw new DecodingException("Unrecognized character: 0x" + Integer.toHexString(c2));
                }
                throw new DecodingException("Unrecognized character: " + c2);
            }
            return by2;
        }

        private boolean hasLowerCase() {
            for (char c2 : this.chars) {
                if (!Ascii.isLowerCase(c2)) continue;
                return true;
            }
            return false;
        }

        private boolean hasUpperCase() {
            for (char c2 : this.chars) {
                if (!Ascii.isUpperCase(c2)) continue;
                return true;
            }
            return false;
        }

        Alphabet upperCase() {
            if (!this.hasLowerCase()) {
                return this;
            }
            Preconditions.checkState(!this.hasUpperCase(), "Cannot call upperCase() on a mixed-case alphabet");
            char[] cArray = new char[this.chars.length];
            for (int i2 = 0; i2 < this.chars.length; ++i2) {
                cArray[i2] = Ascii.toUpperCase(this.chars[i2]);
            }
            return new Alphabet(this.name + ".upperCase()", cArray);
        }

        Alphabet lowerCase() {
            if (!this.hasUpperCase()) {
                return this;
            }
            Preconditions.checkState(!this.hasLowerCase(), "Cannot call lowerCase() on a mixed-case alphabet");
            char[] cArray = new char[this.chars.length];
            for (int i2 = 0; i2 < this.chars.length; ++i2) {
                cArray[i2] = Ascii.toLowerCase(this.chars[i2]);
            }
            return new Alphabet(this.name + ".lowerCase()", cArray);
        }

        public boolean matches(char c2) {
            return c2 < this.decodabet.length && this.decodabet[c2] != -1;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(@Nullable Object object) {
            if (object instanceof Alphabet) {
                Alphabet alphabet = (Alphabet)object;
                return Arrays.equals(this.chars, alphabet.chars);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.chars);
        }
    }

    public static final class DecodingException
    extends IOException {
        DecodingException(String string) {
            super(string);
        }

        DecodingException(Throwable throwable) {
            super(throwable);
        }
    }
}

