/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractHashFunction;
import com.google.common.hash.AbstractHasher;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedBytes;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import org.checkerframework.checker.nullness.qual.Nullable;

@Immutable
final class Murmur3_32HashFunction
extends AbstractHashFunction
implements Serializable {
    static final HashFunction MURMUR3_32 = new Murmur3_32HashFunction(0);
    static final HashFunction GOOD_FAST_HASH_32 = new Murmur3_32HashFunction(Hashing.GOOD_FAST_HASH_SEED);
    private static final int CHUNK_SIZE = 4;
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;
    private final int seed;
    private static final long serialVersionUID = 0L;

    Murmur3_32HashFunction(int n2) {
        this.seed = n2;
    }

    @Override
    public int bits() {
        return 32;
    }

    @Override
    public Hasher newHasher() {
        return new Murmur3_32Hasher(this.seed);
    }

    public String toString() {
        return "Hashing.murmur3_32(" + this.seed + ")";
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof Murmur3_32HashFunction) {
            Murmur3_32HashFunction murmur3_32HashFunction = (Murmur3_32HashFunction)object;
            return this.seed == murmur3_32HashFunction.seed;
        }
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.seed;
    }

    @Override
    public HashCode hashInt(int n2) {
        int n3 = Murmur3_32HashFunction.mixK1(n2);
        int n4 = Murmur3_32HashFunction.mixH1(this.seed, n3);
        return Murmur3_32HashFunction.fmix(n4, 4);
    }

    @Override
    public HashCode hashLong(long l2) {
        int n2 = (int)l2;
        int n3 = (int)(l2 >>> 32);
        int n4 = Murmur3_32HashFunction.mixK1(n2);
        int n5 = Murmur3_32HashFunction.mixH1(this.seed, n4);
        n4 = Murmur3_32HashFunction.mixK1(n3);
        n5 = Murmur3_32HashFunction.mixH1(n5, n4);
        return Murmur3_32HashFunction.fmix(n5, 8);
    }

    @Override
    public HashCode hashUnencodedChars(CharSequence charSequence) {
        int n2;
        int n3 = this.seed;
        for (n2 = 1; n2 < charSequence.length(); n2 += 2) {
            int n4 = charSequence.charAt(n2 - 1) | charSequence.charAt(n2) << 16;
            n4 = Murmur3_32HashFunction.mixK1(n4);
            n3 = Murmur3_32HashFunction.mixH1(n3, n4);
        }
        if ((charSequence.length() & 1) == 1) {
            n2 = charSequence.charAt(charSequence.length() - 1);
            n2 = Murmur3_32HashFunction.mixK1(n2);
            n3 ^= n2;
        }
        return Murmur3_32HashFunction.fmix(n3, 2 * charSequence.length());
    }

    @Override
    public HashCode hashString(CharSequence charSequence, Charset charset) {
        if (Charsets.UTF_8.equals(charset)) {
            int n2;
            int n3;
            int n4 = charSequence.length();
            int n5 = this.seed;
            int n6 = 0;
            int n7 = 0;
            while (n6 + 4 <= n4) {
                char c3 = charSequence.charAt(n6);
                char c4 = charSequence.charAt(n6 + 1);
                n3 = charSequence.charAt(n6 + 2);
                char c2 = charSequence.charAt(n6 + 3);
                if (c3 >= '\u0080' || c4 >= '\u0080' || n3 >= 128 || c2 >= '\u0080') break;
                n2 = c3 | c4 << 8 | n3 << 16 | c2 << 24;
                n2 = Murmur3_32HashFunction.mixK1(n2);
                n5 = Murmur3_32HashFunction.mixH1(n5, n2);
                n6 += 4;
                n7 += 4;
            }
            long l2 = 0L;
            n3 = 0;
            while (n6 < n4) {
                char c2 = charSequence.charAt(n6);
                if (c2 < '\u0080') {
                    l2 |= (long)c2 << n3;
                    n3 += 8;
                    ++n7;
                } else if (c2 < '\u0800') {
                    l2 |= Murmur3_32HashFunction.charToTwoUtf8Bytes(c2) << n3;
                    n3 += 16;
                    n7 += 2;
                } else if (c2 < '\ud800' || c2 > '\udfff') {
                    l2 |= Murmur3_32HashFunction.charToThreeUtf8Bytes(c2) << n3;
                    n3 += 24;
                    n7 += 3;
                } else {
                    n2 = Character.codePointAt(charSequence, n6);
                    if (n2 == c2) {
                        return this.hashBytes(charSequence.toString().getBytes(charset));
                    }
                    ++n6;
                    l2 |= Murmur3_32HashFunction.codePointToFourUtf8Bytes(n2) << n3;
                    n7 += 4;
                }
                if (n3 >= 32) {
                    n2 = Murmur3_32HashFunction.mixK1((int)l2);
                    n5 = Murmur3_32HashFunction.mixH1(n5, n2);
                    l2 >>>= 32;
                    n3 -= 32;
                }
                ++n6;
            }
            int n8 = Murmur3_32HashFunction.mixK1((int)l2);
            return Murmur3_32HashFunction.fmix(n5 ^= n8, n7);
        }
        return this.hashBytes(charSequence.toString().getBytes(charset));
    }

    @Override
    public HashCode hashBytes(byte[] byArray, int n2, int n3) {
        int n4;
        Preconditions.checkPositionIndexes(n2, n2 + n3, byArray.length);
        int n5 = this.seed;
        int n6 = 0;
        while (n6 + 4 <= n3) {
            n4 = Murmur3_32HashFunction.mixK1(Murmur3_32HashFunction.getIntLittleEndian(byArray, n2 + n6));
            n5 = Murmur3_32HashFunction.mixH1(n5, n4);
            n6 += 4;
        }
        n4 = 0;
        int n7 = 0;
        while (n6 < n3) {
            n4 ^= UnsignedBytes.toInt(byArray[n2 + n6]) << n7;
            ++n6;
            n7 += 8;
        }
        return Murmur3_32HashFunction.fmix(n5 ^= Murmur3_32HashFunction.mixK1(n4), n3);
    }

    private static int getIntLittleEndian(byte[] byArray, int n2) {
        return Ints.fromBytes(byArray[n2 + 3], byArray[n2 + 2], byArray[n2 + 1], byArray[n2]);
    }

    private static int mixK1(int n2) {
        n2 *= -862048943;
        n2 = Integer.rotateLeft(n2, 15);
        return n2 *= 461845907;
    }

    private static int mixH1(int n2, int n3) {
        n2 ^= n3;
        n2 = Integer.rotateLeft(n2, 13);
        n2 = n2 * 5 + -430675100;
        return n2;
    }

    private static HashCode fmix(int n2, int n3) {
        n2 ^= n3;
        n2 ^= n2 >>> 16;
        n2 *= -2048144789;
        n2 ^= n2 >>> 13;
        n2 *= -1028477387;
        n2 ^= n2 >>> 16;
        return HashCode.fromInt(n2);
    }

    private static long codePointToFourUtf8Bytes(int n2) {
        return (0xF0L | (long)(n2 >>> 18)) & 0xFFL | (0x80L | (long)(0x3F & n2 >>> 12)) << 8 | (0x80L | (long)(0x3F & n2 >>> 6)) << 16 | (0x80L | (long)(0x3F & n2)) << 24;
    }

    private static long charToThreeUtf8Bytes(char c2) {
        return (0x1E0 | c2 >>> 12) & 0xFF | (0x80 | 0x3F & c2 >>> 6) << 8 | (0x80 | 0x3F & c2) << 16;
    }

    private static long charToTwoUtf8Bytes(char c2) {
        return (0x3C0 | c2 >>> 6) & 0xFF | (0x80 | 0x3F & c2) << 8;
    }

    @CanIgnoreReturnValue
    private static final class Murmur3_32Hasher
    extends AbstractHasher {
        private int h1;
        private long buffer;
        private int shift;
        private int length;
        private boolean isDone;

        Murmur3_32Hasher(int n2) {
            this.h1 = n2;
            this.length = 0;
            this.isDone = false;
        }

        private void update(int n2, long l2) {
            this.buffer |= (l2 & 0xFFFFFFFFL) << this.shift;
            this.shift += n2 * 8;
            this.length += n2;
            if (this.shift >= 32) {
                this.h1 = Murmur3_32HashFunction.mixH1(this.h1, Murmur3_32HashFunction.mixK1((int)this.buffer));
                this.buffer >>>= 32;
                this.shift -= 32;
            }
        }

        @Override
        public Hasher putByte(byte by2) {
            this.update(1, by2 & 0xFF);
            return this;
        }

        @Override
        public Hasher putBytes(byte[] byArray, int n2, int n3) {
            Preconditions.checkPositionIndexes(n2, n2 + n3, byArray.length);
            int n4 = 0;
            while (n4 + 4 <= n3) {
                this.update(4, Murmur3_32HashFunction.getIntLittleEndian(byArray, n2 + n4));
                n4 += 4;
            }
            while (n4 < n3) {
                this.putByte(byArray[n2 + n4]);
                ++n4;
            }
            return this;
        }

        @Override
        public Hasher putBytes(ByteBuffer byteBuffer) {
            ByteOrder byteOrder = byteBuffer.order();
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            while (byteBuffer.remaining() >= 4) {
                this.putInt(byteBuffer.getInt());
            }
            while (byteBuffer.hasRemaining()) {
                this.putByte(byteBuffer.get());
            }
            byteBuffer.order(byteOrder);
            return this;
        }

        @Override
        public Hasher putInt(int n2) {
            this.update(4, n2);
            return this;
        }

        @Override
        public Hasher putLong(long l2) {
            this.update(4, (int)l2);
            this.update(4, l2 >>> 32);
            return this;
        }

        @Override
        public Hasher putChar(char c2) {
            this.update(2, c2);
            return this;
        }

        @Override
        public Hasher putString(CharSequence charSequence, Charset charset) {
            if (Charsets.UTF_8.equals(charset)) {
                int n2;
                char c2;
                int n3 = charSequence.length();
                int n4 = 0;
                while (n4 + 4 <= n3) {
                    c2 = charSequence.charAt(n4);
                    n2 = charSequence.charAt(n4 + 1);
                    char c3 = charSequence.charAt(n4 + 2);
                    char c4 = charSequence.charAt(n4 + 3);
                    if (c2 >= '\u0080' || n2 >= 128 || c3 >= '\u0080' || c4 >= '\u0080') break;
                    this.update(4, c2 | n2 << 8 | c3 << 16 | c4 << 24);
                    n4 += 4;
                }
                while (n4 < n3) {
                    c2 = charSequence.charAt(n4);
                    if (c2 < '\u0080') {
                        this.update(1, c2);
                    } else if (c2 < '\u0800') {
                        this.update(2, Murmur3_32HashFunction.charToTwoUtf8Bytes(c2));
                    } else if (c2 < '\ud800' || c2 > '\udfff') {
                        this.update(3, Murmur3_32HashFunction.charToThreeUtf8Bytes(c2));
                    } else {
                        n2 = Character.codePointAt(charSequence, n4);
                        if (n2 == c2) {
                            this.putBytes(charSequence.subSequence(n4, n3).toString().getBytes(charset));
                            return this;
                        }
                        ++n4;
                        this.update(4, Murmur3_32HashFunction.codePointToFourUtf8Bytes(n2));
                    }
                    ++n4;
                }
                return this;
            }
            return super.putString(charSequence, charset);
        }

        @Override
        public HashCode hash() {
            Preconditions.checkState(!this.isDone);
            this.isDone = true;
            this.h1 ^= Murmur3_32HashFunction.mixK1((int)this.buffer);
            return Murmur3_32HashFunction.fmix(this.h1, this.length);
        }
    }
}

