/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.primitives.Longs;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.misc.Unsafe;

final class LittleEndianByteArray {
    private static final LittleEndianBytes byteArray;

    static long load64(byte[] byArray, int n2) {
        assert (byArray.length >= n2 + 8);
        return byteArray.getLongLittleEndian(byArray, n2);
    }

    static long load64Safely(byte[] byArray, int n2, int n3) {
        long l2 = 0L;
        int n4 = Math.min(n3, 8);
        for (int i2 = 0; i2 < n4; ++i2) {
            l2 |= ((long)byArray[n2 + i2] & 0xFFL) << i2 * 8;
        }
        return l2;
    }

    static void store64(byte[] byArray, int n2, long l2) {
        assert (n2 >= 0 && n2 + 8 <= byArray.length);
        byteArray.putLongLittleEndian(byArray, n2, l2);
    }

    static int load32(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 3] & 0xFF) << 24;
    }

    static boolean usingUnsafe() {
        return byteArray instanceof UnsafeByteArray;
    }

    private LittleEndianByteArray() {
    }

    static {
        Enum enum_ = JavaLittleEndianBytes.INSTANCE;
        try {
            String string = System.getProperty("os.arch");
            if ("amd64".equals(string)) {
                enum_ = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN) ? UnsafeByteArray.UNSAFE_LITTLE_ENDIAN : UnsafeByteArray.UNSAFE_BIG_ENDIAN;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        byteArray = enum_;
    }

    private static enum JavaLittleEndianBytes implements LittleEndianBytes
    {
        INSTANCE{

            @Override
            public long getLongLittleEndian(byte[] byArray, int n2) {
                return Longs.fromBytes(byArray[n2 + 7], byArray[n2 + 6], byArray[n2 + 5], byArray[n2 + 4], byArray[n2 + 3], byArray[n2 + 2], byArray[n2 + 1], byArray[n2]);
            }

            @Override
            public void putLongLittleEndian(byte[] byArray, int n2, long l2) {
                long l3 = 255L;
                for (int i2 = 0; i2 < 8; ++i2) {
                    byArray[n2 + i2] = (byte)((l2 & l3) >> i2 * 8);
                    l3 <<= 8;
                }
            }
        };

    }

    private static enum UnsafeByteArray implements LittleEndianBytes
    {
        UNSAFE_LITTLE_ENDIAN{

            @Override
            public long getLongLittleEndian(byte[] byArray, int n2) {
                return theUnsafe.getLong(byArray, (long)n2 + (long)BYTE_ARRAY_BASE_OFFSET);
            }

            @Override
            public void putLongLittleEndian(byte[] byArray, int n2, long l2) {
                theUnsafe.putLong(byArray, (long)n2 + (long)BYTE_ARRAY_BASE_OFFSET, l2);
            }
        }
        ,
        UNSAFE_BIG_ENDIAN{

            @Override
            public long getLongLittleEndian(byte[] byArray, int n2) {
                long l2 = theUnsafe.getLong(byArray, (long)n2 + (long)BYTE_ARRAY_BASE_OFFSET);
                return Long.reverseBytes(l2);
            }

            @Override
            public void putLongLittleEndian(byte[] byArray, int n2, long l2) {
                long l3 = Long.reverseBytes(l2);
                theUnsafe.putLong(byArray, (long)n2 + (long)BYTE_ARRAY_BASE_OFFSET, l3);
            }
        };

        private static final Unsafe theUnsafe;
        private static final int BYTE_ARRAY_BASE_OFFSET;

        private static Unsafe getUnsafe() {
            try {
                return Unsafe.getUnsafe();
            }
            catch (SecurityException securityException) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                        @Override
                        public Unsafe run() {
                            Class<Unsafe> clazz = Unsafe.class;
                            for (Field field : clazz.getDeclaredFields()) {
                                field.setAccessible(true);
                                Object object = field.get(null);
                                if (!clazz.isInstance(object)) continue;
                                return (Unsafe)clazz.cast(object);
                            }
                            throw new NoSuchFieldError("the Unsafe");
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw new RuntimeException("Could not initialize intrinsics", privilegedActionException.getCause());
                }
            }
        }

        static {
            theUnsafe = UnsafeByteArray.getUnsafe();
            BYTE_ARRAY_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
            if (theUnsafe.arrayIndexScale(byte[].class) != 1) {
                throw new AssertionError();
            }
        }
    }

    private static interface LittleEndianBytes {
        public long getLongLittleEndian(byte[] var1, int var2);

        public void putLongLittleEndian(byte[] var1, int var2, long var3);
    }
}

