/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import java.io.FilterOutputStream;
import java.io.OutputStream;

@Beta
public final class HashingOutputStream
extends FilterOutputStream {
    private final Hasher hasher;

    public HashingOutputStream(HashFunction hashFunction, OutputStream outputStream) {
        super(Preconditions.checkNotNull(outputStream));
        this.hasher = Preconditions.checkNotNull(hashFunction.newHasher());
    }

    @Override
    public void write(int n2) {
        this.hasher.putByte((byte)n2);
        this.out.write(n2);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        this.hasher.putBytes(byArray, n2, n3);
        this.out.write(byArray, n2, n3);
    }

    public HashCode hash() {
        return this.hasher.hash();
    }

    @Override
    public void close() {
        this.out.close();
    }
}

