/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractByteHasher;
import com.google.common.hash.AbstractHashFunction;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.ImmutableSupplier;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.util.zip.Checksum;

@Immutable
final class ChecksumHashFunction
extends AbstractHashFunction
implements Serializable {
    private final ImmutableSupplier<? extends Checksum> checksumSupplier;
    private final int bits;
    private final String toString;
    private static final long serialVersionUID = 0L;

    ChecksumHashFunction(ImmutableSupplier<? extends Checksum> immutableSupplier, int n2, String string) {
        this.checksumSupplier = Preconditions.checkNotNull(immutableSupplier);
        Preconditions.checkArgument(n2 == 32 || n2 == 64, "bits (%s) must be either 32 or 64", n2);
        this.bits = n2;
        this.toString = Preconditions.checkNotNull(string);
    }

    @Override
    public int bits() {
        return this.bits;
    }

    @Override
    public Hasher newHasher() {
        return new ChecksumHasher((Checksum)this.checksumSupplier.get());
    }

    public String toString() {
        return this.toString;
    }

    private final class ChecksumHasher
    extends AbstractByteHasher {
        private final Checksum checksum;

        private ChecksumHasher(Checksum checksum) {
            this.checksum = Preconditions.checkNotNull(checksum);
        }

        @Override
        protected void update(byte by2) {
            this.checksum.update(by2);
        }

        @Override
        protected void update(byte[] byArray, int n2, int n3) {
            this.checksum.update(byArray, n2, n3);
        }

        @Override
        public HashCode hash() {
            long l2 = this.checksum.getValue();
            if (ChecksumHashFunction.this.bits == 32) {
                return HashCode.fromInt((int)l2);
            }
            return HashCode.fromLong(l2);
        }
    }
}

